"use strict";
/*! Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to you under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *Ø
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const mocha_1 = require("mocha");
const StandardInits_1 = require("../frameworkBase/_ext/shared/StandardInits");
const sinon = __importStar(require("sinon"));
const XmlResponses_1 = require("../frameworkBase/_ext/shared/XmlResponses");
const chai_1 = require("chai");
var protocolPage = StandardInits_1.StandardInits.protocolPage;
const mona_dish_1 = require("mona-dish");
const Const_1 = require("../../impl/core/Const");
var HTML_PREFIX_EMBEDDED_BODY = StandardInits_1.StandardInits.HTML_PREFIX_EMBEDDED_BODY;
/**
 * response test
 * the idea is simply to pass in a dom
 * the context and a response xml and then check what happens
 * we do not need to to through the entire ajax cyle for that.
 */
(0, mocha_1.describe)('Tests of the various aspects of the response protocol functionality', function () {
    beforeEach(function () {
        return __awaiter(this, void 0, void 0, function* () {
            let waitForResult = protocolPage(true, false);
            return waitForResult.then((close) => {
                this.xhr = sinon.useFakeXMLHttpRequest();
                this.requests = [];
                this.respond = (response) => {
                    response = (0, Const_1.$nsp)(response);
                    let xhrReq = this.requests.shift();
                    xhrReq.responsetype = "text/xml";
                    xhrReq.respond(200, { 'Content-Type': 'text/xml' }, response);
                    return xhrReq;
                };
                this.xhr.onCreate = (xhr) => {
                    this.requests.push(xhr);
                };
                global.XMLHttpRequest = this.xhr;
                window.XMLHttpRequest = this.xhr;
                this.closeIt = () => {
                    global.XMLHttpRequest = window.XMLHttpRequest = this.xhr.restore();
                    Implementation.reset();
                    close();
                };
            });
        });
    });
    afterEach(function () {
        this.closeIt();
    });
    it("must have a simple field updated as well as the viewstate", function (done) {
        //DQ.byId("cmd_update_insert").click();
        mona_dish_1.DQ.byId("cmd_update_insert").click();
        this.respond(XmlResponses_1.XmlResponses.UPDATE_INSERT_1);
        (0, chai_1.expect)(mona_dish_1.DQ.byId("changesArea")
            .html()
            .orElse("fail")
            .value.indexOf("update succeeded 1") != -1)
            .to.be.true;
        let pos1 = mona_dish_1.DQ.byId(document.body).html()
            .value.indexOf("insert before succeeded should display before test1");
        let pos3 = mona_dish_1.DQ.byId(document.body).html()
            .value.indexOf("insert after succeeded should display after test1");
        let pos2 = mona_dish_1.DQ.byId(document.body).html()
            .value.indexOf("update succeeded 1");
        (0, chai_1.expect)(pos1 != -1).to.be.true;
        (0, chai_1.expect)(pos1 < pos2 && pos2 < pos3).to.be.true;
        let pos4 = mona_dish_1.DQ.byId(document.body).html()
            .value.indexOf("embedded script at update succeed");
        (0, chai_1.expect)(pos4 != -1).to.be.true;
        done();
    });
    it("must have a simple field updated  with the second before update rendering path", function (done) {
        //DQ.byId("cmd_update_insert").click();
        mona_dish_1.DQ.byId("cmd_update_insert").click();
        this.respond(XmlResponses_1.XmlResponses.UPDATE_INSERT_2);
        (0, chai_1.expect)(mona_dish_1.DQ.byId("changesArea")
            .html()
            .orElse("fail")
            .value.indexOf("update succeeded 2") != -1)
            .to.be.true;
        let pos1 = mona_dish_1.DQ.byId(document.body).html()
            .value.indexOf("insert before succeeded should display before test1");
        let pos3 = mona_dish_1.DQ.byId(document.body).html()
            .value.indexOf("insert after succeeded should display after test1");
        let pos2 = mona_dish_1.DQ.byId(document.body).html()
            .value.indexOf("update succeeded 2");
        (0, chai_1.expect)(pos1 != -1).to.be.true;
        (0, chai_1.expect)(pos1 < pos2 && pos2 < pos3).to.be.true;
        let pos4 = mona_dish_1.DQ.byId(document.body).html()
            .value.indexOf("embedded script at update succeed");
        (0, chai_1.expect)(pos4 != -1).to.be.true;
        done();
    });
    it("must have a full body update", function () {
        mona_dish_1.DQ.byId("cmd_replace").click();
        this.respond(XmlResponses_1.XmlResponses.BODY_REPLACEMENT);
        //basic replacement
        let newBody = mona_dish_1.DQ.byId(document.body);
        let newContent = newBody.html().value;
        //standard replacement successful
        (0, chai_1.expect)(newContent.indexOf("<h3>Body replacement test successful</h3>") != -1, "elements must be updated").to.be.true;
        //script eval
        (0, chai_1.expect)(newContent.indexOf(">hello from embedded script in replacement body<") != -1, "embedded scripts must be executed").to.be.true;
        //body attributes
        (0, chai_1.expect)(newBody.hasClass("tundra"), "attributes must be updated").to.be.true;
        (0, chai_1.expect)(newBody.id.value == "the_id", "id must be updated").to.be.true;
    });
    it("must have a proper workiung head replace", function () {
        mona_dish_1.DQ.byId("cmd_replace").click();
        this.respond(XmlResponses_1.XmlResponses.HEAD_REPLACEMENT);
        //basic replacement
        let newBody = mona_dish_1.DQ.byId(document.body);
        let newContent = newBody.html().value;
        //standard replacement successful
        //script eval
        //modern browsers block head replacement but you still can eval
        (0, chai_1.expect)(newContent.indexOf(">hello from embedded script in replacement head") != -1, "embedded scripts must be executed").to.be.true;
    });
    it("must have a proper workiung  root replace", function () {
        mona_dish_1.DQ.byId("cmd_replace").click();
        this.respond(XmlResponses_1.XmlResponses.VIEW_ROOT_REPLACEMENT);
        //basic replacement
        let newHead = mona_dish_1.DQ.byId(document.head);
        let newBody = mona_dish_1.DQ.byId(document.body);
        let newContent = newBody.html().value;
        (0, chai_1.expect)(newHead.isPresent(), " head must exist ").to.be.true;
        //standard replacement successful
        (0, chai_1.expect)(newContent.indexOf("<h3>Body replacement test successful</h3>") != -1, "elements must be updated").to.be.true;
        //script eval
        (0, chai_1.expect)(newContent.indexOf(">hello from embedded script in replacement body<") != -1, "embedded scripts must be executed").to.be.true;
        //body attributes
        (0, chai_1.expect)(newBody.hasClass("tundra"), "attributes must be updated").to.be.true;
        (0, chai_1.expect)(newBody.id.value == "the_id", "id must be updated").to.be.true;
        //standard replacement successful
        //script eval
        //modern browsers block head replacement but you still can eval
        (0, chai_1.expect)(newContent.indexOf(">hello from embedded script in replacement head") != -1, "embedded scripts must be executed").to.be.true;
    });
    it("must have a viewstate update to be peformed", function () {
        mona_dish_1.DQ.byId("cmd_viewstate").click();
        this.respond(XmlResponses_1.XmlResponses.VIEWSTATE_1);
        let viewStateElem = mona_dish_1.DQ.byId('javax.faces.ViewState');
        (0, chai_1.expect)(viewStateElem.inputValue.value == "hello world").to.be.true;
    });
    it("must have processed a proper delete", function () {
        mona_dish_1.DQ.byId("cmd_delete").click();
        this.respond(XmlResponses_1.XmlResponses.DELETE_1);
        (0, chai_1.expect)(mona_dish_1.DQ.byId("deletable").isAbsent()).to.be.true;
    });
    it("must have processed a proper eval of a script given in the eval tag", function () {
        mona_dish_1.DQ.byId("cmd_eval").click();
        this.respond(XmlResponses_1.XmlResponses.EVAL_1);
        let resultHTML = mona_dish_1.DQ.byId(document.body).html().value;
        (0, chai_1.expect)(resultHTML.indexOf('eval test succeeded') != -1).to.be.true;
    });
    it("must have updated the viewstates properly 2.3", function () {
        mona_dish_1.DQ.byId("cmd_eval").click();
        /*js full submit form, coming from the integration tests*/
        window.document.body.innerHTML = `<form id="j_id__v_0" name="j_id__v_0" method="post" action="/IntegrationJSTest/integrationtestsjasmine/test7-eventtest.jsf"
      enctype="application/x-www-form-urlencoded"><span id="updatePanel">hello world</span><a href="#"
                                                                                              onclick="return (faces || jsf).util.chain(this, event,'return false;', 'return myfaces.ab(\'j_id_1l\',\'updateTrigger\');');"
                                                                                              id="updateTrigger"
                                                                                              name="updateTrigger"
                                                                                              class="updateTrigger">[Press
    me for Update]</a><input type="hidden" name="j_id_1l_SUBMIT" value="1">
</form>`;
        jsf.ajax.request(window.document.getElementById("updateTrigger"), null, {
            render: "updatePanel",
            execute: "updatePanel updateTrigger"
        });
        global["MF_23"] = true;
        // language=XML
        this.respond(`<?xml version="1.0" encoding="UTF-8"?>
            <partial-response id="j_id__v_0">
                <changes>
                    <update id="updatePanel"><![CDATA[<span id="updatePanel">hello world</span>]]></update>
                    <update id="j_id__v_0:javax.faces.ViewState:1"><![CDATA[RTUyRDI0NzE4QzAxM0E5RDAwMDAwMDVD]]></update>
                </changes>
            </partial-response>`);
        (0, chai_1.expect)((0, mona_dish_1.DQ$)("[name*='javax.faces.ViewState']").isAbsent()).to.be.false;
        //expect((<HTMLInputElement>document.getElementsByName("javax.faces.ViewState")[0]).value == "RTUyRDI0NzE4QzAxM0E5RDAwMDAwMDVD").to.be.true;
        (0, chai_1.expect)((0, mona_dish_1.DQ$)("[name*='javax.faces.ViewState']").val == "RTUyRDI0NzE4QzAxM0E5RDAwMDAwMDVD").to.be.true;
    });
    it("must have updated the viewstates properly with lenient update block 2.3", function () {
        mona_dish_1.DQ.byId("cmd_eval").click();
        /*js full submit form, coming from the integration tests*/
        window.document.body.innerHTML = `<form id="j_id__v_0" name="j_id__v_0" method="post" action="/IntegrationJSTest/integrationtestsjasmine/test7-eventtest.jsf"
      enctype="application/x-www-form-urlencoded"><span id="updatePanel">hello world</span><a href="#"
                                                                                              onclick="return jsf.util.chain(this, event,'return false;', 'return myfaces.ab(\'j_id_1l\',\'updateTrigger\');');"
                                                                                              id="updateTrigger"
                                                                                              name="updateTrigger"
                                                                                              class="updateTrigger">[Press
    me for Update]</a><input type="hidden" name="j_id_1l_SUBMIT" value="1">
</form>`;
        jsf.ajax.request(window.document.getElementById("updateTrigger"), null, {
            render: "updatePanel",
            execute: "updatePanel updateTrigger"
        });
        // language=XML
        this.respond(`<?xml version="1.0" encoding="UTF-8"?>
            <partial-response id="j_id__v_0">
                <changes>
                    <update id="updatePanel"><![CDATA[<span id="updatePanel">hello world</span>]]></update>
                    <update id="j_id__v_0:javax.faces.ViewState:1"><![CDATA[RTUyRDI0NzE4QzAxM0E5RDAwMDAwMDVD]]><!-- 
                        Some random junk which is sent by the server
                    --></update>
                </changes>
            </partial-response>`);
        (0, chai_1.expect)((0, mona_dish_1.DQ$)("[name*='javax.faces.ViewState']").isAbsent()).to.be.false;
        //expect((<HTMLInputElement>document.getElementsByName("javax.faces.ViewState")[0]).value == "RTUyRDI0NzE4QzAxM0E5RDAwMDAwMDVD").to.be.true;
        (0, chai_1.expect)((0, mona_dish_1.DQ$)("[name*='javax.faces.ViewState']").inputValue.value == "RTUyRDI0NzE4QzAxM0E5RDAwMDAwMDVD").to.be.true;
    });
    /**
     * The body innerHTML is based on a Tobago page. View state and client window id is rendered within a
     * jsf-state-container.
     * Beside the tobago-out tag, the view state and the client window id must be updated properly.
     */
    it("must have updated the client window tag properly", function () {
        window.document.body.innerHTML = `<tobago-page locale='en' class='container-fluid' id='page'>
   <form action='/IntegrationJSTest/integrationtestsjasmine/tobago-jfwid-test.jsf' id='page::form' method='post' accept-charset='UTF-8' data-tobago-context-path=''>
    <input type='hidden' name='javax.faces.source' id='javax.faces.source' disabled='disabled'>
    <tobago-focus id='page::lastFocusId'>
     <input type='hidden' name='page::lastFocusId' id='page::lastFocusId::field'>
    </tobago-focus>
    <input type='hidden' name='org.apache.myfaces.tobago.webapp.Secret' id='org.apache.myfaces.tobago.webapp.Secret' value='SLrPlxqLEaR/oYFLSu4wgg=='>
    <tobago-in id='page:input' class='tobago-margin-bottom'>
     <input type='text' name='page:input' id='page:input::field' class='tobago-in form-control' value='Alice'>
     <tobago-behavior event='change' client-id='page:input' field-id='page:input::field' execute='page:input' render='page:output'></tobago-behavior>
    </tobago-in>
    <div id='page:output' class='tobago-margin-bottom'>
     <tobago-out class='form-control-plaintext'></tobago-out>
    </div>
    <div class='tobago-page-menuStore'></div>
    <span id='page::jsf-state-container'>
      <input type='hidden' name='javax.faces.ViewState' id='j_id__v_0:javax.faces.ViewState:1' value='RkExQ0Q1NTYzOTNCNzg0RjAwMDAwMDE4' autocomplete='off'>
      <input type='hidden' name='javax.faces.RenderKitId' value='tobago'>
      <input type='hidden' id='j_id__v_0:javax.faces.ClientWindow:1' name='javax.faces.ClientWindow' value='5m10kooxi'>
    </span>
   </form>
  </tobago-page>`;
        (0, chai_1.expect)(mona_dish_1.DQ.querySelectorAll("#page\\:output tobago-out").textContent() === "").to.be.true;
        (0, chai_1.expect)(mona_dish_1.DQ.byId("j_id__v_0:javax.faces.ViewState:1").isAbsent()).to.be.false;
        (0, chai_1.expect)(mona_dish_1.DQ.byId("j_id__v_0:javax.faces.ClientWindow:1").isAbsent()).to.be.false;
        jsf.ajax.request(window.document.getElementById("page:input"), "change", {
            "javax.faces.behavior.event": "change",
            execute: "page:input",
            render: "page:output"
        });
        this.respond(`<?xml version="1.0" encoding="UTF-8"?>
<partial-response id='j_id__v_0'>
<changes>
<update id='page:output'><![CDATA[
<div id='page:output' class='tobago-margin-bottom'>
<tobago-out class='form-control-plaintext'>Alice</tobago-out>
</div>]]>
</update>
<update id='j_id__v_0:javax.faces.ViewState:1'><![CDATA[MDQwQzkxNkU0MTg0RTQxRjAwMDAwMDE3]]>
</update>
<update id='j_id__v_0:javax.faces.ClientWindow:1'><![CDATA[5m10kooxg]]>
</update>
</changes>
</partial-response>`);
        (0, chai_1.expect)(mona_dish_1.DQ.querySelectorAll("#page\\:output tobago-out").textContent() === "Alice").to.be.true;
        (0, chai_1.expect)(mona_dish_1.DQ.byId("j_id__v_0:javax.faces.ViewState:1").isAbsent()).to.be.false;
        (0, chai_1.expect)(mona_dish_1.DQ.byId("j_id__v_0:javax.faces.ClientWindow:1").isAbsent()).to.be.false;
    });
    it("<style> element must be in <tobago-sheet> instead of <head>", function () {
        window.document.documentElement.innerHTML = StandardInits_1.StandardInits.HTML_TOBAGO_SHEET_WITH_STYLE;
        (0, chai_1.expect)(mona_dish_1.DQ.querySelectorAll("head > style").length).to.be.eq(0);
        (0, chai_1.expect)(mona_dish_1.DQ.querySelectorAll("body tobago-page tobago-sheet > style").length).to.be.eq(1);
        jsf.ajax.request(window.document.getElementById("page:ajaxButton"), null, {
            "jakarta.faces.behavior.event": "click",
            execute: "page:ajaxButton",
            render: "page:s1"
        });
        this.respond(XmlResponses_1.XmlResponses.UPDATE_TOBAGO_SHEET_WITH_STYLE);
        (0, chai_1.expect)(mona_dish_1.DQ.querySelectorAll("head > style").length).to.be.eq(0);
        (0, chai_1.expect)(mona_dish_1.DQ.querySelectorAll("body tobago-page tobago-sheet > style").length).to.be.eq(1);
        (0, chai_1.expect)(mona_dish_1.DQ.querySelectorAll("body tobago-page tobago-sheet > style").nonce.value).to.be.eq("nonceValue");
    });
    it("must pass named params properly (tobago testcase)", function (done) {
        window.document.body.innerHTML = HTML_PREFIX_EMBEDDED_BODY;
        try {
            let event = {
                isTrusted: true,
                type: 'change',
                target: document.getElementById("page:input::field"),
                currentTarget: document.getElementById("page:input::field")
            };
            jsf.ajax.request(document.getElementById("page:input"), event, {
                render: "page:output",
                execute: "page:input",
                params: {
                    "booga2.xxx": "yyy",
                    "javax.faces.behavior.event": "change",
                    "booga": "bla"
                }
            });
        }
        catch (err) {
            console.error(err);
            (0, chai_1.expect)(false).to.eq(true);
        }
        const requestBody = this.requests[0].requestBody;
        (0, chai_1.expect)(requestBody.indexOf("javax.faces.behavior.event")).to.not.eq(-1);
        (0, chai_1.expect)(requestBody.indexOf("javax.faces.behavior.event=change")).to.not.eq(-1);
        (0, chai_1.expect)(requestBody.indexOf("page%3Ainput=input_value")).to.not.eq(-1);
        done();
    });
});
//# sourceMappingURL=ResponseTest23.spec.js.map