"use strict";
/*! Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to you under the Apache License, Version 2.0
 * (the "License"); you may not use this file exceptin compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const mocha_1 = require("mocha");
const sinon = __importStar(require("sinon"));
const Const_1 = require("../../impl/core/Const");
const StandardInits_1 = require("../frameworkBase/_ext/shared/StandardInits");
const XmlResponses_1 = require("../frameworkBase/_ext/shared/XmlResponses");
const chai_1 = require("chai");
const AjaxImpl_1 = require("../../impl/AjaxImpl");
var errorChainPage = StandardInits_1.StandardInits.errorChainPage;
const mona_dish_1 = require("mona-dish");
const ErrorData_1 = require("../../impl/xhrCore/ErrorData");
/**
 * Tests for error recover if an error is triggered mid chain
 */
(0, mocha_1.describe)('Tests of the various aspects of the response protocol functionality', function () {
    beforeEach(function () {
        return __awaiter(this, void 0, void 0, function* () {
            let waitForResult = errorChainPage(true);
            return waitForResult.then((close) => {
                this.xhr = sinon.useFakeXMLHttpRequest();
                this.requests = [];
                this.respond = (response) => {
                    response = (0, Const_1.$nsp)(response);
                    let xhrReq = this.requests.shift();
                    xhrReq.responsetype = "text/xml";
                    xhrReq.respond(200, { 'Content-Type': 'text/xml' }, response);
                    return xhrReq;
                };
                this.respond403 = (response) => {
                    let xhrReq = this.requests.shift();
                    xhrReq.responsetype = "text/html";
                    xhrReq.respond(403, { 'Content-Type': 'text/html' }, "server error");
                    return xhrReq;
                };
                this.xhr.onCreate = (xhr) => {
                    this.requests.push(xhr);
                };
                global.XMLHttpRequest = this.xhr;
                window.XMLHttpRequest = this.xhr;
                this.closeIt = () => {
                    global.XMLHttpRequest = window.XMLHttpRequest = this.xhr.restore();
                    AjaxImpl_1.Implementation.reset();
                    close();
                };
            });
        });
    });
    afterEach(function () {
        this.closeIt();
    });
    it("No Error Case", function (done) {
        mona_dish_1.DQ.byId("form1:button1").click();
        (0, chai_1.expect)(AjaxImpl_1.Implementation.requestQueue.queue.length >= 4).to.be.true;
        for (let cnt = 1; cnt <= 5; cnt++) {
            if (!AjaxImpl_1.Implementation.requestQueue.queue.length) {
                //the last non queued element waits for another response
                this.respond(XmlResponses_1.XmlResponses.ERROR_CHAIN_RESPOND_OK(cnt));
                break;
            }
            this.respond(XmlResponses_1.XmlResponses.ERROR_CHAIN_RESPOND_OK(cnt));
        }
        (0, chai_1.expect)(mona_dish_1.DQ.byId("errorCalled").innerHTML).to.eq("");
        (0, chai_1.expect)(mona_dish_1.DQ.byId("form1:out1").innerHTML).to.eq("5");
        done();
    });
    it("must process the error chain properly", function (done) {
        mona_dish_1.DQ.byId("form1:button1").click();
        (0, chai_1.expect)(AjaxImpl_1.Implementation.requestQueue.queue.length >= 4).to.be.true;
        for (let cnt = 1; cnt <= 5; cnt++) {
            if (!AjaxImpl_1.Implementation.requestQueue.queue.length) {
                this.respond(XmlResponses_1.XmlResponses.ERROR_CHAIN_RESPOND_OK(cnt));
                break;
            }
            if (cnt == 3) {
                //any error suffices
                this.respond403();
            }
            else {
                this.respond(XmlResponses_1.XmlResponses.ERROR_CHAIN_RESPOND_OK(cnt));
            }
        }
        (0, chai_1.expect)(AjaxImpl_1.Implementation.requestQueue.queue.length).to.eq(0);
        (0, chai_1.expect)(mona_dish_1.DQ.byId("errorCalled").innerHTML).to.eq("1");
        (0, chai_1.expect)(mona_dish_1.DQ.byId("form1:out1").innerHTML).to.eq("5");
        done();
    });
    it("must process the error chain properly with a standard Ajax Error", function (done) {
        mona_dish_1.DQ.byId("form1:button1").click();
        (0, chai_1.expect)(AjaxImpl_1.Implementation.requestQueue.queue.length >= 4).to.be.true;
        for (let cnt = 1; cnt <= 5; cnt++) {
            if (!AjaxImpl_1.Implementation.requestQueue.queue.length) {
                this.respond(XmlResponses_1.XmlResponses.ERROR_CHAIN_RESPOND_OK(cnt));
                break;
            }
            if (cnt == 3) {
                //any error suffices
                this.respond(XmlResponses_1.XmlResponses.ERROR_1);
            }
            else {
                this.respond(XmlResponses_1.XmlResponses.ERROR_CHAIN_RESPOND_OK(cnt));
            }
        }
        (0, chai_1.expect)(AjaxImpl_1.Implementation.requestQueue.queue.length).to.eq(0);
        (0, chai_1.expect)(mona_dish_1.DQ.byId("errorCalled").innerHTML).to.eq("1");
        (0, chai_1.expect)(mona_dish_1.DQ.byId("form1:out1").innerHTML).to.eq("5");
        done();
    });
    it('must have correct source element within the error Data Object', () => {
        const errorData = new ErrorData_1.ErrorData("form1:button1", "errorName", "errorMessage");
        (0, chai_1.expect)(errorData.source.id).to.eq("form1:button1");
    });
    it('should have correct source id string within the error Data Object if element not existing', () => {
        const errorData = new ErrorData_1.ErrorData("form1:button1:booga", "errorName", "errorMessage");
        (0, chai_1.expect)(errorData.source).to.eq("form1:button1:booga");
    });
});
//# sourceMappingURL=ErrorChainTest.spec.js.map