/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.authorization.resource;

import java.util.Map;
import org.apache.nifi.authorization.AccessDeniedException;
import org.apache.nifi.authorization.AuthorizationResult;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.Resource;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.resource.EnforcePolicyPermissionsThroughBaseResource;
import org.apache.nifi.authorization.resource.ResourceFactory;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.web.ResourceNotFoundException;

public class DataAuthorizable
implements Authorizable,
EnforcePolicyPermissionsThroughBaseResource {
    final Authorizable authorizable;

    public DataAuthorizable(Authorizable authorizable) {
        this.authorizable = authorizable;
    }

    @Override
    public Authorizable getBaseAuthorizable() {
        return this.authorizable;
    }

    public Authorizable getParentAuthorizable() {
        if (this.authorizable.getParentAuthorizable() == null) {
            return null;
        }
        return new DataAuthorizable(this.authorizable.getParentAuthorizable());
    }

    public Resource getResource() {
        return ResourceFactory.getDataResource(this.authorizable.getResource());
    }

    public AuthorizationResult checkAuthorization(Authorizer authorizer, RequestAction action, NiFiUser user, Map<String, String> resourceContext) {
        if (user == null) {
            return AuthorizationResult.denied((String)"Unknown user.");
        }
        AuthorizationResult result = null;
        NiFiUser chainedUser = user;
        do {
            try {
                result = super.checkAuthorization(authorizer, action, chainedUser, resourceContext);
                if (!AuthorizationResult.Result.Approved.equals((Object)result.getResult())) {
                    return result;
                }
                chainedUser = chainedUser.getChain();
            }
            catch (ResourceNotFoundException e) {
                result = AuthorizationResult.denied((String)"Unknown source component.");
            }
        } while (chainedUser != null);
        if (result == null) {
            result = AuthorizationResult.denied();
        }
        return result;
    }

    public void authorize(Authorizer authorizer, RequestAction action, NiFiUser user, Map<String, String> resourceContext) throws AccessDeniedException {
        if (user == null) {
            throw new AccessDeniedException("Unknown user.");
        }
        NiFiUser chainedUser = user;
        do {
            try {
                super.authorize(authorizer, action, chainedUser, resourceContext);
                chainedUser = chainedUser.getChain();
            }
            catch (ResourceNotFoundException e) {
                throw new AccessDeniedException("Unknown source component.");
            }
        } while (chainedUser != null);
    }
}

