/****************************************************************************
 * arch/risc-v/src/esp32c6/esp32c6_vectors.S
 *
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.  The
 * ASF licenses this file to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 ****************************************************************************/

/****************************************************************************
 * Included Files
 ****************************************************************************/

#include <nuttx/config.h>
#include <arch/irq.h>
#include <arch/esp32c6/irq.h>

#include "chip.h"

/****************************************************************************
 * Public Symbols
 ****************************************************************************/

  .global  _vector_table

/****************************************************************************
 * Section: .exception_vectors.text
 ****************************************************************************/

  .section .exception_vectors.text

/****************************************************************************
 * Name: _vector_table
 ****************************************************************************/

  .balign   0x100
  .type     _vector_table, @function

_vector_table:
  .option push
  .option norvc

  .rept (32)
  j    exception_common
  .endr
