/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.webbeans.newtests.injection.named;

import javax.inject.Inject;
import javax.inject.Named;

public class NamedInjectionPoints {

    @Inject
    @Named("named")
    private NamedInterface namedBeanWithNamedInjectionPoint;
    @Inject
    @Named
    private NamedInterface named;

    @Inject
    @Named("defaultNamedBean")
    private NamedInterface defaultNamedBeanWithNamedInjectionPoint;
    @Inject
    @Named
    private NamedInterface defaultNamedBean;

    public NamedInterface getNamedBeanWithNamedInjectionPoint() {
        return namedBeanWithNamedInjectionPoint;
    }
    
    public NamedInterface getNamed() {
        return named;
    }
    
    public NamedInterface getDefaultNamedBeanWithNamedInjectionPoint() {
        return defaultNamedBeanWithNamedInjectionPoint;
    }
    
    public NamedInterface getDefaultNamedBean() {
        return defaultNamedBean;
    }
}
