/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.freon;

import com.codahale.metrics.Timer;
import java.io.OutputStream;
import java.util.concurrent.Callable;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.conf.StorageSize;
import org.apache.hadoop.ozone.freon.ContentGenerator;
import org.apache.hadoop.ozone.freon.HadoopBaseFreonGenerator;
import org.apache.hadoop.ozone.freon.StorageSizeConverter;
import picocli.CommandLine;

@CommandLine.Command(name="dfsg", aliases={"dfs-file-generator"}, description={"Create random files to the any dfs compatible file system."}, versionProvider=HddsVersionProvider.class, mixinStandardHelpOptions=true, showDefaultValues=true)
public class HadoopFsGenerator
extends HadoopBaseFreonGenerator
implements Callable<Void> {
    @CommandLine.Option(names={"-s", "--size"}, description={"Size of the generated files. You can specify the size using data units like 'GB', 'MB', 'KB', etc. Size is in base 2 binary."}, defaultValue="10KB", converter={StorageSizeConverter.class})
    private StorageSize fileSize;
    @CommandLine.Option(names={"--buffer"}, description={"Size of buffer used store the generated key content"}, defaultValue="10240")
    private int bufferSize;
    @CommandLine.Option(names={"--copy-buffer"}, description={"Size of bytes written to the output in one operation"}, defaultValue="4096")
    private int copyBufferSize;
    @CommandLine.Option(names={"--sync"}, description={"Type of operation to execute after a write. Supported options include NONE (default), HFLUSH and HSYNC"}, defaultValue="NONE")
    private static ContentGenerator.SyncOptions flushOrSync;
    private ContentGenerator contentGenerator;
    private Timer timer;

    @Override
    public Void call() throws Exception {
        super.init();
        Path file = new Path(this.getRootPath() + "/" + this.generateObjectName(0L));
        this.getFileSystem().mkdirs(file.getParent());
        this.contentGenerator = new ContentGenerator(this.fileSize.toBytes(), this.bufferSize, this.copyBufferSize, flushOrSync);
        this.timer = this.getMetrics().timer("file-create");
        this.runTests(this::createFile);
        return null;
    }

    private void createFile(long counter) throws Exception {
        Path file = new Path(this.getRootPath() + "/" + this.generateObjectName(counter));
        FileSystem fileSystem = this.getFileSystem();
        this.timer.time(() -> {
            try (FSDataOutputStream output = fileSystem.create(file);){
                this.contentGenerator.write((OutputStream)output);
            }
            return null;
        });
    }
}

