/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.block;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.time.Clock;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.ReconfigurableConfig;
import org.apache.hadoop.hdds.conf.ReconfigurationHandler;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.ScmConfig;
import org.apache.hadoop.hdds.scm.block.DatanodeDeletedBlockTransactions;
import org.apache.hadoop.hdds.scm.block.DeletedBlockLog;
import org.apache.hadoop.hdds.scm.block.ScmBlockDeletingServiceMetrics;
import org.apache.hadoop.hdds.scm.events.SCMEvents;
import org.apache.hadoop.hdds.scm.ha.SCMContext;
import org.apache.hadoop.hdds.scm.ha.SCMService;
import org.apache.hadoop.hdds.scm.ha.SCMServiceManager;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.node.NodeStatus;
import org.apache.hadoop.hdds.scm.node.states.NodeNotFoundException;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.hdds.utils.BackgroundService;
import org.apache.hadoop.hdds.utils.BackgroundTask;
import org.apache.hadoop.hdds.utils.BackgroundTaskQueue;
import org.apache.hadoop.hdds.utils.BackgroundTaskResult;
import org.apache.hadoop.ozone.container.common.statemachine.DatanodeConfiguration;
import org.apache.hadoop.ozone.protocol.commands.CommandForDatanode;
import org.apache.hadoop.ozone.protocol.commands.DeleteBlocksCommand;
import org.apache.hadoop.ozone.protocol.commands.SCMCommand;
import org.apache.hadoop.util.Time;
import org.apache.ratis.protocol.exceptions.NotLeaderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCMBlockDeletingService
extends BackgroundService
implements SCMService {
    public static final Logger LOG = LoggerFactory.getLogger(SCMBlockDeletingService.class);
    private static final int BLOCK_DELETING_SERVICE_CORE_POOL_SIZE = 1;
    private final DeletedBlockLog deletedBlockLog;
    private final NodeManager nodeManager;
    private final EventPublisher eventPublisher;
    private final SCMContext scmContext;
    private final ScmConfig scmConf;
    private final ScmBlockDeletingServiceMetrics metrics;
    private final Lock serviceLock = new ReentrantLock();
    private SCMService.ServiceStatus serviceStatus = SCMService.ServiceStatus.PAUSING;
    private long safemodeExitMillis = 0L;
    private final long safemodeExitRunDelayMillis;
    private final long deleteBlocksPendingCommandLimit;
    private final Clock clock;

    public SCMBlockDeletingService(DeletedBlockLog deletedBlockLog, NodeManager nodeManager, EventPublisher eventPublisher, SCMContext scmContext, SCMServiceManager serviceManager, ConfigurationSource conf, ScmConfig scmConfig, ScmBlockDeletingServiceMetrics metrics, Clock clock, ReconfigurationHandler reconfigurationHandler) {
        super("SCMBlockDeletingService", scmConfig.getBlockDeletionInterval().toMillis(), TimeUnit.MILLISECONDS, 1, conf.getTimeDuration("ozone.block.deleting.service.timeout", "300s", TimeUnit.MILLISECONDS), scmContext.threadNamePrefix());
        this.safemodeExitRunDelayMillis = conf.getTimeDuration("hdds.scm.wait.time.after.safemode.exit", "5m", TimeUnit.MILLISECONDS);
        DatanodeConfiguration dnConf = (DatanodeConfiguration)conf.getObject(DatanodeConfiguration.class);
        this.deleteBlocksPendingCommandLimit = dnConf.getBlockDeleteQueueLimit();
        this.clock = clock;
        this.deletedBlockLog = deletedBlockLog;
        this.nodeManager = nodeManager;
        this.eventPublisher = eventPublisher;
        this.scmContext = scmContext;
        this.metrics = metrics;
        this.scmConf = scmConfig;
        Preconditions.checkArgument((this.scmConf.getBlockDeletionLimit() > 0 ? 1 : 0) != 0, (Object)"Block deletion limit should be positive.");
        reconfigurationHandler.register((ReconfigurableConfig)this.scmConf);
        serviceManager.register(this);
    }

    public BackgroundTaskQueue getTasks() {
        BackgroundTaskQueue queue = new BackgroundTaskQueue();
        queue.add((BackgroundTask)new DeletedBlockTransactionScanner());
        return queue;
    }

    @VisibleForTesting
    public void setBlockDeleteTXNum(int numTXs) {
        Preconditions.checkArgument((numTXs > 0 ? 1 : 0) != 0, (Object)"Block deletion limit should be positive.");
        this.scmConf.setBlockDeletionLimit(numTXs);
    }

    public int getBlockDeleteTXNum() {
        return this.scmConf.getBlockDeletionLimit();
    }

    @Override
    public void notifyStatusChanged() {
        this.serviceLock.lock();
        try {
            if (this.scmContext.isLeaderReady() && !this.scmContext.isInSafeMode()) {
                if (this.serviceStatus != SCMService.ServiceStatus.RUNNING) {
                    LOG.info("notifyStatusChanged:" + (Object)((Object)SCMService.ServiceStatus.RUNNING));
                    this.safemodeExitMillis = this.clock.millis();
                    this.serviceStatus = SCMService.ServiceStatus.RUNNING;
                }
            } else {
                this.serviceStatus = SCMService.ServiceStatus.PAUSING;
            }
        }
        finally {
            this.serviceLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean shouldRun() {
        this.serviceLock.lock();
        try {
            long alreadyWaitTimeInMillis = this.clock.millis() - this.safemodeExitMillis;
            boolean run = this.serviceStatus == SCMService.ServiceStatus.RUNNING && alreadyWaitTimeInMillis >= this.safemodeExitRunDelayMillis;
            LOG.debug("Check scm block delete run: {} serviceStatus: {} safemodeExitRunDelayMillis: {} alreadyWaitTimeInMillis: {}", new Object[]{run, this.serviceStatus, this.safemodeExitRunDelayMillis, alreadyWaitTimeInMillis});
            boolean bl = run;
            return bl;
        }
        finally {
            this.serviceLock.unlock();
        }
    }

    @Override
    public String getServiceName() {
        return SCMBlockDeletingService.class.getSimpleName();
    }

    @Override
    public void stop() {
        this.shutdown();
    }

    @VisibleForTesting
    public ScmBlockDeletingServiceMetrics getMetrics() {
        return this.metrics;
    }

    @VisibleForTesting
    protected Set<DatanodeDetails> getDatanodesWithinCommandLimit(List<DatanodeDetails> datanodes) throws NodeNotFoundException {
        HashSet<DatanodeDetails> included = new HashSet<DatanodeDetails>();
        for (DatanodeDetails dn : datanodes) {
            if ((long)this.nodeManager.getTotalDatanodeCommandCount(dn, StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.deleteBlocksCommand) >= this.deleteBlocksPendingCommandLimit || this.nodeManager.getCommandQueueCount(dn.getUuid(), StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.deleteBlocksCommand) >= 2) continue;
            included.add(dn);
        }
        return included;
    }

    private class DeletedBlockTransactionScanner
    implements BackgroundTask {
        private DeletedBlockTransactionScanner() {
        }

        public int getPriority() {
            return 1;
        }

        public BackgroundTaskResult.EmptyTaskResult call() throws Exception {
            List<DatanodeDetails> datanodes;
            if (!SCMBlockDeletingService.this.shouldRun()) {
                return BackgroundTaskResult.EmptyTaskResult.newResult();
            }
            long startTime = Time.monotonicNow();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Running DeletedBlockTransactionScanner");
            }
            if ((datanodes = SCMBlockDeletingService.this.nodeManager.getNodes(NodeStatus.inServiceHealthy())) != null) {
                try {
                    Set<DatanodeDetails> included = SCMBlockDeletingService.this.getDatanodesWithinCommandLimit(datanodes);
                    int blockDeletionLimit = SCMBlockDeletingService.this.getBlockDeleteTXNum();
                    DatanodeDeletedBlockTransactions transactions = SCMBlockDeletingService.this.deletedBlockLog.getTransactions(blockDeletionLimit, included);
                    if (transactions.isEmpty()) {
                        return BackgroundTaskResult.EmptyTaskResult.newResult();
                    }
                    HashSet<Long> processedTxIDs = new HashSet<Long>();
                    for (Map.Entry<UUID, List<StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction>> entry : transactions.getDatanodeTransactionMap().entrySet()) {
                        UUID dnId = entry.getKey();
                        List<StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction> dnTXs = entry.getValue();
                        if (dnTXs.isEmpty()) continue;
                        Set<Long> dnTxSet = dnTXs.stream().map(StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction::getTxID).collect(Collectors.toSet());
                        processedTxIDs.addAll(dnTxSet);
                        DeleteBlocksCommand command = new DeleteBlocksCommand(dnTXs);
                        command.setTerm(SCMBlockDeletingService.this.scmContext.getTermOfLeader());
                        SCMBlockDeletingService.this.deletedBlockLog.recordTransactionCreated(dnId, command.getId(), dnTxSet);
                        SCMBlockDeletingService.this.eventPublisher.fireEvent(SCMEvents.DATANODE_COMMAND, (Object)new CommandForDatanode(dnId, (SCMCommand)command));
                        SCMBlockDeletingService.this.metrics.incrBlockDeletionCommandSent();
                        SCMBlockDeletingService.this.metrics.incrBlockDeletionTransactionSent(dnTXs.size());
                        SCMBlockDeletingService.this.metrics.incrDNCommandsSent(dnId, 1L);
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("Added delete block command for datanode {} in the queue, number of delete block transactions: {}{}", new Object[]{dnId, dnTXs.size(), LOG.isTraceEnabled() ? ", TxID list: " + String.join((CharSequence)",", transactions.getTransactionIDList(dnId)) : ""});
                    }
                    LOG.info("Totally added {} blocks to be deleted for {} datanodes / {} totalnodes, limit per iteration : {}blocks, task elapsed time: {}ms", new Object[]{transactions.getBlocksDeleted(), transactions.getDatanodeTransactionMap().size(), included.size(), blockDeletionLimit, Time.monotonicNow() - startTime});
                    SCMBlockDeletingService.this.deletedBlockLog.incrementCount(new ArrayList<Long>(processedTxIDs));
                }
                catch (NotLeaderException nle) {
                    LOG.warn("Skip current run, since not leader any more.", (Throwable)nle);
                }
                catch (NodeNotFoundException e) {
                    LOG.error("Datanode not found in NodeManager. Should not happen", (Throwable)e);
                }
                catch (IOException e) {
                    LOG.error("Failed to get block deletion transactions from delTX log", (Throwable)e);
                }
            }
            return BackgroundTaskResult.EmptyTaskResult.newResult();
        }
    }
}

