/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.balancer;

import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.scm.container.balancer.ContainerBalancerConfiguration;
import org.apache.hadoop.hdds.scm.container.balancer.FindSourceStrategy;
import org.apache.hadoop.hdds.scm.node.DatanodeUsageInfo;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FindSourceGreedy
implements FindSourceStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(FindSourceGreedy.class);
    private Map<DatanodeDetails, Long> sizeLeavingNode = new ConcurrentHashMap<DatanodeDetails, Long>();
    private PriorityQueue<DatanodeUsageInfo> potentialSources = new PriorityQueue((a, b) -> {
        double currentUsageOfA = a.calculateUtilization(-this.sizeLeavingNode.get(a.getDatanodeDetails()).longValue());
        double currentUsageOfB = b.calculateUtilization(-this.sizeLeavingNode.get(b.getDatanodeDetails()).longValue());
        int ret = Double.compare(currentUsageOfB, currentUsageOfA);
        if (ret != 0) {
            return ret;
        }
        UUID uuidA = a.getDatanodeDetails().getUuid();
        UUID uuidB = b.getDatanodeDetails().getUuid();
        return uuidA.compareTo(uuidB);
    });
    private NodeManager nodeManager;
    private ContainerBalancerConfiguration config;
    private Double lowerLimit;

    FindSourceGreedy(NodeManager nodeManager) {
        this.nodeManager = nodeManager;
    }

    private void setLowerLimit(Double lowerLimit) {
        this.lowerLimit = lowerLimit;
    }

    @Override
    public void resetPotentialSources(@Nonnull Collection<DatanodeDetails> sources) {
        ArrayList<DatanodeUsageInfo> usageInfos = new ArrayList<DatanodeUsageInfo>(sources.size());
        sources.forEach(source -> usageInfos.add(this.nodeManager.getUsageInfo((DatanodeDetails)source)));
        this.resetSources(usageInfos);
    }

    private void resetSources(Collection<DatanodeUsageInfo> sources) {
        this.potentialSources.clear();
        sources.forEach(source -> {
            this.sizeLeavingNode.putIfAbsent(source.getDatanodeDetails(), 0L);
            this.potentialSources.add((DatanodeUsageInfo)source);
        });
    }

    private void setConfiguration(ContainerBalancerConfiguration conf) {
        this.config = conf;
    }

    @Override
    public void increaseSizeLeaving(DatanodeDetails dui, long size) {
        Long currentSize = this.sizeLeavingNode.get(dui);
        if (currentSize != null) {
            this.sizeLeavingNode.put(dui, currentSize + size);
            this.addBackSourceDataNode(dui);
            return;
        }
        LOG.warn("Cannot find datanode {} in candidate source datanodes", (Object)dui.getUuid());
    }

    @Override
    public DatanodeDetails getNextCandidateSourceDataNode() {
        if (this.potentialSources.isEmpty()) {
            LOG.info("no more candidate source data node");
            return null;
        }
        return this.potentialSources.poll().getDatanodeDetails();
    }

    @Override
    public void removeCandidateSourceDataNode(DatanodeDetails dui) {
        this.potentialSources.removeIf(a -> a.getDatanodeDetails().equals((Object)dui));
    }

    @Override
    public void addBackSourceDataNode(DatanodeDetails dn) {
        DatanodeUsageInfo dui = this.nodeManager.getUsageInfo(dn);
        this.potentialSources.add(dui);
    }

    @Override
    public boolean canSizeLeaveSource(DatanodeDetails source, long size) {
        if (this.sizeLeavingNode.containsKey(source)) {
            long sizeLeavingAfterMove = this.sizeLeavingNode.get(source) + size;
            if (size <= 0L) {
                LOG.debug("{} bytes container cannot leave datanode {}", (Object)size, (Object)source.getUuidString());
                return false;
            }
            if (sizeLeavingAfterMove > this.config.getMaxSizeLeavingSource()) {
                LOG.debug("{} bytes cannot leave datanode {} because 'size.leaving.source.max' limit is {} and {} bytes have already left.", new Object[]{size, source.getUuidString(), this.config.getMaxSizeLeavingSource(), this.sizeLeavingNode.get(source)});
                return false;
            }
            if (Double.compare(this.nodeManager.getUsageInfo(source).calculateUtilization(-sizeLeavingAfterMove), this.lowerLimit) < 0) {
                LOG.debug("{} bytes cannot leave datanode {} because its utilization will drop below the lower limit of {}.", new Object[]{size, source.getUuidString(), this.lowerLimit});
                return false;
            }
            return true;
        }
        LOG.warn("No record of how much size has left datanode {}", (Object)source);
        return false;
    }

    @Override
    public void reInitialize(List<DatanodeUsageInfo> potentialDataNodes, ContainerBalancerConfiguration conf, Double lowLimit) {
        this.setConfiguration(conf);
        this.setLowerLimit(lowLimit);
        this.sizeLeavingNode.clear();
        this.resetSources(potentialDataNodes);
    }

    @Override
    public Map<DatanodeDetails, Long> getSizeLeavingNodes() {
        return this.sizeLeavingNode;
    }

    @Override
    public void clearSizeLeavingNodes() {
        this.sizeLeavingNode.clear();
    }
}

