/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.replication.health;

import java.util.Set;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;
import org.apache.hadoop.hdds.scm.container.ReplicationManagerReport;
import org.apache.hadoop.hdds.scm.container.replication.ContainerCheckRequest;
import org.apache.hadoop.hdds.scm.container.replication.ContainerHealthResult;
import org.apache.hadoop.hdds.scm.container.replication.ContainerReplicaOp;
import org.apache.hadoop.hdds.scm.container.replication.QuasiClosedStuckReplicaCount;
import org.apache.hadoop.hdds.scm.container.replication.health.AbstractCheck;
import org.apache.hadoop.hdds.scm.container.replication.health.QuasiClosedContainerHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuasiClosedStuckReplicationCheck
extends AbstractCheck {
    public static final Logger LOG = LoggerFactory.getLogger(QuasiClosedStuckReplicationCheck.class);

    public static boolean shouldHandleAsQuasiClosedStuck(ContainerInfo containerInfo, Set<ContainerReplica> replicas) {
        if (containerInfo.getState() != HddsProtos.LifeCycleState.QUASI_CLOSED) {
            return false;
        }
        if (!QuasiClosedContainerHandler.isQuasiClosedStuck(containerInfo, replicas)) {
            return false;
        }
        QuasiClosedStuckReplicaCount replicaCount = new QuasiClosedStuckReplicaCount(replicas, 0);
        if (replicaCount.availableOrigins() == 1) {
            return false;
        }
        return !QuasiClosedStuckReplicationCheck.hasEnoughOriginsWithOpen(containerInfo, replicas);
    }

    @Override
    public boolean handle(ContainerCheckRequest request) {
        if (!QuasiClosedStuckReplicationCheck.shouldHandleAsQuasiClosedStuck(request.getContainerInfo(), request.getContainerReplicas())) {
            return false;
        }
        if (request.getContainerReplicas().isEmpty()) {
            request.getReport().incrementAndSample(ReplicationManagerReport.HealthState.MISSING, request.getContainerInfo().containerID());
            return true;
        }
        QuasiClosedStuckReplicaCount replicaCount = new QuasiClosedStuckReplicaCount(request.getContainerReplicas(), request.getMaintenanceRedundancy());
        if (!replicaCount.hasHealthyReplicas()) {
            return false;
        }
        int pendingAdd = 0;
        int pendingDelete = 0;
        for (ContainerReplicaOp op : request.getPendingOps()) {
            if (op.getOpType() == ContainerReplicaOp.PendingOpType.ADD) {
                ++pendingAdd;
                continue;
            }
            if (op.getOpType() != ContainerReplicaOp.PendingOpType.DELETE) continue;
            ++pendingDelete;
        }
        if (replicaCount.isUnderReplicated()) {
            LOG.debug("Container {} is quasi-closed-stuck under-replicated", (Object)request.getContainerInfo());
            request.getReport().incrementAndSample(ReplicationManagerReport.HealthState.UNDER_REPLICATED, request.getContainerInfo().containerID());
            if (pendingAdd == 0) {
                LOG.debug("Queueing under-replicated health result for container {}", (Object)request.getContainerInfo());
                ContainerHealthResult.UnderReplicatedHealthResult underReplicatedHealthResult = new ContainerHealthResult.UnderReplicatedHealthResult(request.getContainerInfo(), 1, replicaCount.hasOutOfServiceReplicas(), false, false);
                request.getReplicationQueue().enqueue(underReplicatedHealthResult);
            }
            return true;
        }
        if (replicaCount.isOverReplicated()) {
            LOG.debug("Container {} is quasi-closed-stuck over-replicated", (Object)request.getContainerInfo());
            request.getReport().incrementAndSample(ReplicationManagerReport.HealthState.OVER_REPLICATED, request.getContainerInfo().containerID());
            if (pendingDelete == 0) {
                LOG.debug("Queueing over-replicated health result for container {}", (Object)request.getContainerInfo());
                ContainerHealthResult.OverReplicatedHealthResult overReplicatedHealthResult = new ContainerHealthResult.OverReplicatedHealthResult(request.getContainerInfo(), 1, false);
                request.getReplicationQueue().enqueue(overReplicatedHealthResult);
            }
            return true;
        }
        return false;
    }

    private static boolean hasEnoughOriginsWithOpen(ContainerInfo containerInfo, Set<ContainerReplica> replicas) {
        int replicationFactor;
        long uniqueOpenReplicaCount = replicas.stream().filter(r -> r.getState() == StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.QUASI_CLOSED || r.getState() == StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.OPEN).map(ContainerReplica::getOriginDatanodeId).distinct().count();
        return uniqueOpenReplicaCount >= (long)(replicationFactor = containerInfo.getReplicationConfig().getRequiredNodes());
    }
}

