/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.server;

import java.io.IOException;
import java.util.concurrent.Callable;
import org.apache.hadoop.hdds.cli.GenericCli;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.scm.server.SCMStarterInterface;
import org.apache.hadoop.hdds.scm.server.StorageContainerManager;
import org.apache.hadoop.hdds.tracing.TracingUtil;
import org.apache.hadoop.hdds.utils.HddsServerUtil;
import org.apache.hadoop.hdds.utils.HddsVersionInfo;
import org.apache.hadoop.hdds.utils.VersionInfo;
import org.apache.hadoop.ozone.common.StorageInfo;
import org.apache.hadoop.ozone.util.OzoneNetUtils;
import org.apache.hadoop.ozone.util.ShutdownHookManager;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="ozone scm", hidden=true, description={"Start or initialize the scm server."}, versionProvider=HddsVersionProvider.class, mixinStandardHelpOptions=true)
public class StorageContainerManagerStarter
extends GenericCli
implements Callable<Void> {
    private OzoneConfiguration conf;
    private SCMStarterInterface receiver;
    private static final Logger LOG = LoggerFactory.getLogger(StorageContainerManagerStarter.class);

    public static void main(String[] args) {
        OzoneNetUtils.disableJvmNetworkAddressCacheIfRequired((OzoneConfiguration)new OzoneConfiguration());
        new StorageContainerManagerStarter(new SCMStarterHelper()).run(args);
    }

    public StorageContainerManagerStarter(SCMStarterInterface receiverObj) {
        this.receiver = receiverObj;
    }

    @Override
    public Void call() throws Exception {
        try {
            this.commonInit();
            this.startScm();
        }
        catch (Exception ex) {
            LOG.error("SCM start failed with exception", (Throwable)ex);
            throw ex;
        }
        return null;
    }

    @CommandLine.Command(name="--genclusterid", customSynopsis={"ozone scm [global options] --genclusterid [options]"}, hidden=false, description={"Generate a new Cluster ID"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
    public void generateClusterId() {
        this.commonInit();
        this.out().println("Generating new cluster id:");
        this.out().println(this.receiver.generateClusterId());
    }

    @CommandLine.Command(name="--init", customSynopsis={"ozone scm [global options] --init [options]"}, hidden=false, description={"Initialize the SCM if not already initialized"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
    public void initScm(@CommandLine.Option(names={"--clusterid"}, description={"Optional: The cluster id to use when formatting SCM"}, paramLabel="id") String clusterId) throws Exception {
        this.commonInit();
        boolean result = this.receiver.init(this.conf, clusterId);
        if (!result) {
            throw new IOException("scm init failed");
        }
    }

    @CommandLine.Command(name="--bootstrap", customSynopsis={"ozone scm [global options] --bootstrap"}, hidden=false, description={"Bootstrap SCM if not already done"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
    public void bootStrapScm() throws Exception {
        this.commonInit();
        boolean result = this.receiver.bootStrap(this.conf);
        if (!result) {
            throw new IOException("scm bootstrap failed");
        }
    }

    private void startScm() throws Exception {
        this.receiver.start(this.conf);
    }

    private void commonInit() {
        this.conf = this.getOzoneConf();
        TracingUtil.initTracing((String)"StorageContainerManager", (ConfigurationSource)this.conf);
        String[] originalArgs = this.getCmd().getParseResult().originalArgs().toArray(new String[0]);
        HddsServerUtil.startupShutdownMessage((VersionInfo)HddsVersionInfo.HDDS_VERSION_INFO, StorageContainerManager.class, (String[])originalArgs, (Logger)LOG, (OzoneConfiguration)this.conf);
    }

    static class SCMStarterHelper
    implements SCMStarterInterface {
        SCMStarterHelper() {
        }

        @Override
        public void start(OzoneConfiguration conf) throws Exception {
            StorageContainerManager stm = StorageContainerManager.createSCM(conf);
            stm.start();
            ShutdownHookManager.get().addShutdownHook(() -> {
                try {
                    stm.stop();
                    stm.join();
                }
                catch (Exception e) {
                    LOG.error("Error during stop StorageContainerManager", (Throwable)e);
                }
            }, 10);
        }

        @Override
        public boolean init(OzoneConfiguration conf, String clusterId) throws IOException {
            return StorageContainerManager.scmInit(conf, clusterId);
        }

        @Override
        public boolean bootStrap(OzoneConfiguration conf) throws AuthenticationException, IOException {
            return StorageContainerManager.scmBootstrap(conf);
        }

        @Override
        public String generateClusterId() {
            return StorageInfo.newClusterID();
        }
    }
}

