/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.server.upgrade;

import java.io.IOException;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManager;
import org.apache.hadoop.hdds.scm.server.upgrade.FinalizationCheckpoint;
import org.apache.hadoop.hdds.scm.server.upgrade.FinalizationStateManager;
import org.apache.hadoop.hdds.scm.server.upgrade.SCMUpgradeFinalizationContext;
import org.apache.hadoop.hdds.upgrade.HDDSLayoutFeature;
import org.apache.hadoop.hdds.upgrade.HDDSLayoutVersionManager;
import org.apache.hadoop.ozone.common.Storage;
import org.apache.hadoop.ozone.upgrade.AbstractLayoutVersionManager;
import org.apache.hadoop.ozone.upgrade.BasicUpgradeFinalizer;
import org.apache.hadoop.ozone.upgrade.LayoutFeature;
import org.apache.hadoop.ozone.upgrade.UpgradeException;
import org.apache.hadoop.ozone.upgrade.UpgradeFinalizationExecutor;
import org.apache.ratis.protocol.exceptions.NotLeaderException;

public class SCMUpgradeFinalizer
extends BasicUpgradeFinalizer<SCMUpgradeFinalizationContext, HDDSLayoutVersionManager> {
    public SCMUpgradeFinalizer(HDDSLayoutVersionManager versionManager) {
        super((AbstractLayoutVersionManager)versionManager);
    }

    public SCMUpgradeFinalizer(HDDSLayoutVersionManager versionManager, UpgradeFinalizationExecutor<SCMUpgradeFinalizationContext> executor) {
        super((AbstractLayoutVersionManager)versionManager, executor);
    }

    private void logCheckpointCrossed(FinalizationCheckpoint checkpoint) {
        LOG.info("SCM Finalization has crossed checkpoint {}", (Object)checkpoint);
    }

    public void preFinalizeUpgrade(SCMUpgradeFinalizationContext context) throws IOException {
        FinalizationStateManager stateManager = context.getFinalizationStateManager();
        if (!stateManager.crossedCheckpoint(FinalizationCheckpoint.FINALIZATION_STARTED)) {
            context.getFinalizationStateManager().addFinalizingMark();
        }
        this.logCheckpointCrossed(FinalizationCheckpoint.FINALIZATION_STARTED);
        if (!stateManager.crossedCheckpoint(FinalizationCheckpoint.MLV_EQUALS_SLV)) {
            this.closePipelinesBeforeFinalization(context.getPipelineManager());
        }
    }

    public void finalizeLayoutFeature(LayoutFeature lf, SCMUpgradeFinalizationContext context) throws UpgradeException {
        try {
            context.getFinalizationStateManager().finalizeLayoutFeature(lf.layoutVersion());
        }
        catch (IOException ex) {
            throw new UpgradeException((Throwable)ex, UpgradeException.ResultCodes.LAYOUT_FEATURE_FINALIZATION_FAILED);
        }
    }

    void replicatedFinalizationSteps(HDDSLayoutFeature lf, SCMUpgradeFinalizationContext context) throws UpgradeException {
        super.finalizeLayoutFeature((LayoutFeature)lf, lf.scmAction(LayoutFeature.UpgradeActionType.ON_FINALIZE), (Storage)context.getStorage());
    }

    public void postFinalizeUpgrade(SCMUpgradeFinalizationContext context) throws IOException {
        this.logCheckpointCrossed(FinalizationCheckpoint.MLV_EQUALS_SLV);
        FinalizationStateManager stateManager = context.getFinalizationStateManager();
        if (!stateManager.crossedCheckpoint(FinalizationCheckpoint.FINALIZATION_COMPLETE)) {
            this.createPipelinesAfterFinalization(context);
            stateManager.removeFinalizingMark();
        }
    }

    public void runPrefinalizeStateActions(Storage storage, SCMUpgradeFinalizationContext context) throws IOException {
        super.runPrefinalizeStateActions(lf -> arg_0 -> ((HDDSLayoutFeature)((HDDSLayoutFeature)lf)).scmAction(arg_0), storage, (Object)context);
    }

    private void closePipelinesBeforeFinalization(PipelineManager pipelineManager) throws IOException {
        String msg = "  Existing pipelines and containers will be closed during Upgrade.";
        msg = msg + "\n  New pipelines creation will remain frozen until Upgrade is finalized.";
        if (!pipelineManager.isPipelineCreationFrozen()) {
            throw new SCMException("Error during finalization. Pipeline creationshould have been frozen before closing existing pipelines.", SCMException.ResultCodes.INTERNAL_ERROR);
        }
        for (Pipeline pipeline : pipelineManager.getPipelines()) {
            if (pipeline.getPipelineState() == Pipeline.PipelineState.CLOSED) continue;
            pipelineManager.closePipeline(pipeline, true);
        }
        this.logAndEmit(msg);
    }

    private void createPipelinesAfterFinalization(SCMUpgradeFinalizationContext context) throws SCMException, NotLeaderException {
        PipelineManager pipelineManager = context.getPipelineManager();
        if (pipelineManager.isPipelineCreationFrozen()) {
            throw new SCMException("Error during finalization. Pipeline creation should have been resumed before waiting for new pipelines.", SCMException.ResultCodes.INTERNAL_ERROR);
        }
        boolean hasPipeline = false;
        while (!hasPipeline) {
            context.getSCMContext().getTermOfLeader();
            ReplicationConfig ratisThree = ReplicationConfig.fromProtoTypeAndFactor((HddsProtos.ReplicationType)HddsProtos.ReplicationType.RATIS, (HddsProtos.ReplicationFactor)HddsProtos.ReplicationFactor.THREE);
            int pipelineCount = pipelineManager.getPipelines(ratisThree, Pipeline.PipelineState.OPEN).size();
            boolean bl = hasPipeline = pipelineCount >= 1;
            if (!hasPipeline) {
                LOG.info("Waiting for at least one open Ratis 3 pipeline after SCM finalization.");
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            LOG.info("Open pipeline found after SCM finalization");
        }
    }
}

