/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.api;

import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.placement.metrics.SCMNodeStat;
import org.apache.hadoop.hdds.scm.node.NodeStatus;
import org.apache.hadoop.hdds.scm.server.OzoneStorageContainerManager;
import org.apache.hadoop.ozone.recon.api.types.ClusterStateResponse;
import org.apache.hadoop.ozone.recon.api.types.ContainerStateCounts;
import org.apache.hadoop.ozone.recon.api.types.DatanodeStorageReport;
import org.apache.hadoop.ozone.recon.persistence.ContainerHealthSchemaManager;
import org.apache.hadoop.ozone.recon.scm.ReconContainerManager;
import org.apache.hadoop.ozone.recon.scm.ReconNodeManager;
import org.apache.hadoop.ozone.recon.scm.ReconPipelineManager;
import org.apache.hadoop.ozone.recon.tasks.OmTableInsightTask;
import org.apache.ozone.recon.schema.ContainerSchemaDefinition;
import org.apache.ozone.recon.schema.generated.tables.daos.GlobalStatsDao;
import org.apache.ozone.recon.schema.generated.tables.pojos.GlobalStats;
import org.apache.ozone.recon.schema.generated.tables.pojos.UnhealthyContainers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/clusterState")
@Produces(value={"application/json"})
public class ClusterStateEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterStateEndpoint.class);
    public static final int MISSING_CONTAINER_COUNT_LIMIT = 1001;
    private ReconNodeManager nodeManager;
    private ReconPipelineManager pipelineManager;
    private ReconContainerManager containerManager;
    private GlobalStatsDao globalStatsDao;
    private OzoneConfiguration ozoneConfiguration;
    private final ContainerHealthSchemaManager containerHealthSchemaManager;

    @Inject
    ClusterStateEndpoint(OzoneStorageContainerManager reconSCM, GlobalStatsDao globalStatsDao, ContainerHealthSchemaManager containerHealthSchemaManager, OzoneConfiguration ozoneConfiguration) {
        this.nodeManager = (ReconNodeManager)reconSCM.getScmNodeManager();
        this.pipelineManager = (ReconPipelineManager)reconSCM.getPipelineManager();
        this.containerManager = (ReconContainerManager)reconSCM.getContainerManager();
        this.globalStatsDao = globalStatsDao;
        this.containerHealthSchemaManager = containerHealthSchemaManager;
        this.ozoneConfiguration = ozoneConfiguration;
    }

    @GET
    public Response getClusterState() {
        ContainerStateCounts containerStateCounts = new ContainerStateCounts();
        List datanodeDetails = this.nodeManager.getAllNodes();
        int pipelines = this.pipelineManager.getPipelines().size();
        List<UnhealthyContainers> missingContainers = this.containerHealthSchemaManager.getUnhealthyContainers(ContainerSchemaDefinition.UnHealthyContainerStates.MISSING, 0, 1001);
        containerStateCounts.setMissingContainerCount(missingContainers.size() == 1001 ? 1001 : missingContainers.size());
        containerStateCounts.setOpenContainersCount(this.containerManager.getContainerStateCount(HddsProtos.LifeCycleState.OPEN));
        containerStateCounts.setDeletedContainersCount(this.containerManager.getContainerStateCount(HddsProtos.LifeCycleState.DELETED));
        int healthyDatanodes = this.nodeManager.getNodeCount(NodeStatus.inServiceHealthy()) + this.nodeManager.getNodeCount(NodeStatus.inServiceHealthyReadOnly());
        SCMNodeStat stats = this.nodeManager.getStats();
        DatanodeStorageReport storageReport = new DatanodeStorageReport(stats.getCapacity().get(), stats.getScmUsed().get(), stats.getRemaining().get(), stats.getCommitted().get());
        ClusterStateResponse.Builder builder = ClusterStateResponse.newBuilder();
        GlobalStats volumeRecord = (GlobalStats)this.globalStatsDao.findById(OmTableInsightTask.getTableCountKeyFromTable("volumeTable"));
        GlobalStats bucketRecord = (GlobalStats)this.globalStatsDao.findById(OmTableInsightTask.getTableCountKeyFromTable("bucketTable"));
        GlobalStats keyRecord = (GlobalStats)this.globalStatsDao.findById(OmTableInsightTask.getTableCountKeyFromTable("keyTable"));
        GlobalStats fileRecord = (GlobalStats)this.globalStatsDao.findById(OmTableInsightTask.getTableCountKeyFromTable("fileTable"));
        GlobalStats deletedKeyRecord = (GlobalStats)this.globalStatsDao.findById(OmTableInsightTask.getTableCountKeyFromTable("deletedTable"));
        GlobalStats deletedDirRecord = (GlobalStats)this.globalStatsDao.findById(OmTableInsightTask.getTableCountKeyFromTable("deletedDirectoryTable"));
        if (volumeRecord != null) {
            builder.setVolumes(volumeRecord.getValue());
        }
        if (bucketRecord != null) {
            builder.setBuckets(bucketRecord.getValue());
        }
        Long totalKeys = 0L;
        Long keysPendingDeletion = 0L;
        Long deletedDirs = 0L;
        if (keyRecord != null) {
            totalKeys = totalKeys + keyRecord.getValue();
        }
        if (fileRecord != null) {
            totalKeys = totalKeys + fileRecord.getValue();
        }
        if (deletedKeyRecord != null) {
            keysPendingDeletion = keysPendingDeletion + deletedKeyRecord.getValue();
        }
        if (deletedDirRecord != null) {
            deletedDirs = deletedDirs + deletedDirRecord.getValue();
        }
        builder.setKeys(totalKeys);
        builder.setKeysPendingDeletion(keysPendingDeletion);
        builder.setDeletedDirs(deletedDirs);
        containerStateCounts.setTotalContainerCount(this.containerManager.getContainers().size() - containerStateCounts.getDeletedContainersCount());
        ClusterStateResponse response = builder.setStorageReport(storageReport).setPipelines(pipelines).setContainers(containerStateCounts.getTotalContainerCount()).setMissingContainers(containerStateCounts.getMissingContainerCount()).setTotalDatanodes(datanodeDetails.size()).setHealthyDatanodes(healthyDatanodes).setOpenContainers(containerStateCounts.getOpenContainersCount()).setDeletedContainers(containerStateCounts.getDeletedContainersCount()).setScmServiceId(this.ozoneConfiguration.get("ozone.scm.service.ids")).setOmServiceId(this.ozoneConfiguration.get("ozone.om.service.ids")).build();
        return Response.ok((Object)response).build();
    }
}

