/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.persistence;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.jolbox.bonecp.BoneCPDataSource;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.ozone.recon.persistence.DataSourceConfiguration;
import org.apache.hadoop.ozone.recon.persistence.DerbyDataSourceProvider;
import org.apache.hadoop.ozone.recon.persistence.SqliteDataSourceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDataSourceProvider
implements Provider<DataSource> {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultDataSourceProvider.class);
    @Inject
    private DataSourceConfiguration configuration;

    public DataSource get() {
        String jdbcUrl = this.configuration.getJdbcUrl();
        LOG.info("JDBC Url for Recon : {} ", (Object)jdbcUrl);
        if (StringUtils.contains((CharSequence)jdbcUrl, (CharSequence)"derby")) {
            return new DerbyDataSourceProvider(this.configuration).get();
        }
        if (StringUtils.contains((CharSequence)jdbcUrl, (CharSequence)"sqlite")) {
            return new SqliteDataSourceProvider(this.configuration).get();
        }
        BoneCPDataSource cpDataSource = new BoneCPDataSource();
        cpDataSource.setDriverClass(this.configuration.getDriverClass());
        cpDataSource.setJdbcUrl(this.configuration.getJdbcUrl());
        cpDataSource.setUsername(this.configuration.getUserName());
        cpDataSource.setPassword(this.configuration.getPassword());
        cpDataSource.setDefaultAutoCommit(this.configuration.setAutoCommit());
        cpDataSource.setConnectionTimeoutInMs(this.configuration.getConnectionTimeout());
        cpDataSource.setMaxConnectionsPerPartition(this.configuration.getMaxActiveConnections().intValue());
        cpDataSource.setMaxConnectionAgeInSeconds(this.configuration.getMaxConnectionAge());
        cpDataSource.setIdleMaxAgeInSeconds(this.configuration.getMaxIdleConnectionAge());
        cpDataSource.setIdleConnectionTestPeriodInSeconds(this.configuration.getIdleConnectionTestPeriod());
        cpDataSource.setConnectionTestStatement(this.configuration.getConnectionTestStatement());
        return cpDataSource;
    }
}

