/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.persistence;

import com.google.inject.AbstractModule;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.matcher.Matchers;
import java.sql.Connection;
import javax.sql.DataSource;
import org.aopalliance.intercept.MethodInterceptor;
import org.apache.hadoop.ozone.recon.persistence.DataSourceConfiguration;
import org.apache.hadoop.ozone.recon.persistence.DefaultDataSourceProvider;
import org.apache.hadoop.ozone.recon.persistence.TransactionalMethodInterceptor;
import org.jooq.Configuration;
import org.jooq.ConnectionProvider;
import org.jooq.SQLDialect;
import org.jooq.impl.DefaultConfiguration;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.transaction.annotation.Transactional;

public class JooqPersistenceModule
extends AbstractModule {
    private Provider<DataSourceConfiguration> configurationProvider;
    public static final SQLDialect DEFAULT_DIALECT = SQLDialect.DERBY;

    public JooqPersistenceModule(Provider<DataSourceConfiguration> configurationProvider) {
        this.configurationProvider = configurationProvider;
    }

    protected void configure() {
        this.bind(DataSource.class).toProvider(DefaultDataSourceProvider.class).in(Singleton.class);
        TransactionalMethodInterceptor interceptor = new TransactionalMethodInterceptor((Provider<DataSourceTransactionManager>)this.getProvider(DataSourceTransactionManager.class));
        this.bindInterceptor(Matchers.annotatedWith(Transactional.class), Matchers.any(), new MethodInterceptor[]{interceptor});
        this.bindInterceptor(Matchers.any(), Matchers.annotatedWith(Transactional.class), new MethodInterceptor[]{interceptor});
        System.setProperty("org.jooq.no-logo", "true");
    }

    @Provides
    @Singleton
    Configuration getConfiguration(DefaultDataSourceProvider provider) {
        DataSource dataSource = provider.get();
        return new DefaultConfiguration().set(dataSource).set((ConnectionProvider)new SpringConnectionProvider(dataSource)).set(SQLDialect.valueOf((String)((DataSourceConfiguration)this.configurationProvider.get()).getSqlDialect()));
    }

    @Provides
    @Singleton
    DataSourceTransactionManager provideDataSourceTransactionManager(DataSource dataSource) {
        return new DataSourceTransactionManager((DataSource)new TransactionAwareDataSourceProxy(dataSource));
    }

    static class SpringConnectionProvider
    implements ConnectionProvider {
        private final DataSource dataSource;

        SpringConnectionProvider(DataSource dataSource) {
            this.dataSource = dataSource;
        }

        public Connection acquire() throws DataAccessException {
            return DataSourceUtils.getConnection((DataSource)this.dataSource);
        }

        public void release(Connection connection) throws DataAccessException {
            DataSourceUtils.releaseConnection((Connection)connection, (DataSource)this.dataSource);
        }
    }
}

