/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.spi.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import javax.inject.Singleton;
import javax.ws.rs.core.Response;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdfs.web.URLConnectionFactory;
import org.apache.hadoop.ozone.recon.ReconUtils;
import org.apache.hadoop.ozone.recon.metrics.Metric;
import org.apache.hadoop.ozone.recon.spi.MetricsServiceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class PrometheusServiceProviderImpl
implements MetricsServiceProvider {
    public static final String PROMETHEUS_INSTANT_QUERY_API = "query";
    public static final String PROMETHEUS_RANGED_QUERY_API = "query_range";
    private static final Logger LOG = LoggerFactory.getLogger(PrometheusServiceProviderImpl.class);
    private URLConnectionFactory connectionFactory;
    private final String prometheusEndpoint;
    private ReconUtils reconUtils;

    public PrometheusServiceProviderImpl(OzoneConfiguration configuration, ReconUtils reconUtils) {
        int connectionTimeout = (int)configuration.getTimeDuration("ozone.recon.metrics.http.connection.timeout", "10s", TimeUnit.MILLISECONDS);
        int connectionRequestTimeout = (int)configuration.getTimeDuration("ozone.recon.metrics.http.connection.request.timeout", "10s", TimeUnit.MILLISECONDS);
        this.connectionFactory = URLConnectionFactory.newDefaultURLConnectionFactory((int)connectionTimeout, (int)connectionRequestTimeout, (Configuration)configuration);
        String endpoint = configuration.getTrimmed(PrometheusServiceProviderImpl.getEndpointConfigKey());
        if (endpoint != null && endpoint.endsWith("/")) {
            endpoint = endpoint.substring(0, endpoint.length() - 1);
        }
        this.prometheusEndpoint = endpoint;
        this.reconUtils = reconUtils;
    }

    @Override
    public HttpURLConnection getMetricsResponse(String api, String queryString) throws Exception {
        String url = String.format("%s/api/v1/%s?%s", this.prometheusEndpoint, api, queryString);
        return this.reconUtils.makeHttpCall(this.connectionFactory, url, false);
    }

    public static String getEndpointConfigKey() {
        return "ozone.recon.prometheus.http.endpoint";
    }

    @Override
    public List<Metric> getMetricsInstant(String queryString) throws Exception {
        return this.getMetrics(PROMETHEUS_INSTANT_QUERY_API, queryString);
    }

    @Override
    public List<Metric> getMetricsRanged(String queryString) throws Exception {
        return this.getMetrics(PROMETHEUS_RANGED_QUERY_API, queryString);
    }

    private List<Metric> getMetrics(String api, String queryString) throws Exception {
        HttpURLConnection urlConnection = this.getMetricsResponse(api, queryString);
        ArrayList<Metric> metrics = null;
        if (Response.Status.fromStatusCode((int)urlConnection.getResponseCode()).getFamily() == Response.Status.Family.SUCCESSFUL) {
            InputStream inputStream = urlConnection.getInputStream();
            ObjectMapper mapper = new ObjectMapper();
            Map jsonMap = (Map)mapper.readValue(inputStream, Map.class);
            inputStream.close();
            String status = (String)jsonMap.get("status");
            if (status != null && status.equals("success")) {
                String resultType;
                Map data = (Map)jsonMap.get("data");
                if (data != null && (resultType = (String)data.get("resultType")) != null) {
                    String valueKey = resultType.equals("matrix") ? "values" : "value";
                    List result = (List)data.get("result");
                    if (!result.isEmpty()) {
                        metrics = new ArrayList<Metric>();
                        for (Map metricJson : result) {
                            Map metadata = (Map)metricJson.get("metric");
                            TreeMap<Double, Double> values = new TreeMap<Double, Double>();
                            List<List> valuesJson = new ArrayList();
                            if (resultType.equals("matrix")) {
                                valuesJson = (List)metricJson.get(valueKey);
                            } else if (resultType.equals("vector")) {
                                valuesJson.add((List)metricJson.get(valueKey));
                            }
                            for (List value : valuesJson) {
                                if (value.size() != 2) continue;
                                values.put((Double)value.get(0), Double.parseDouble((String)value.get(1)));
                            }
                            metrics.add(new Metric(metadata, values));
                        }
                    }
                }
            } else if (LOG.isErrorEnabled()) {
                LOG.error(String.format("Error while getting metrics: %s", jsonMap.get("error")));
            }
        } else {
            LOG.error("Error while connecting to metrics endpoint. Got a status code " + urlConnection.getResponseCode() + ": " + urlConnection.getResponseMessage());
        }
        return metrics;
    }
}

