/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.tasks;

import java.util.Collections;
import java.util.Map;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.recon.tasks.OMUpdateEventBatch;

public interface ReconOmTask {
    public String getTaskName();

    default public void init() {
    }

    public TaskResult process(OMUpdateEventBatch var1, Map<String, Integer> var2);

    public TaskResult reprocess(OMMetadataManager var1);

    default public TaskResult buildTaskResult(boolean success) {
        return new TaskResult.Builder().setTaskName(this.getTaskName()).setTaskSuccess(success).build();
    }

    public static class TaskResult {
        private final String taskName;
        private final Map<String, Integer> subTaskSeekPositions;
        private final boolean taskSuccess;

        private TaskResult(Builder builder) {
            this.taskName = builder.taskName;
            this.subTaskSeekPositions = builder.subTaskSeekPositions != null ? builder.subTaskSeekPositions : Collections.emptyMap();
            this.taskSuccess = builder.taskSuccess;
        }

        public String getTaskName() {
            return this.taskName;
        }

        public Map<String, Integer> getSubTaskSeekPositions() {
            return this.subTaskSeekPositions;
        }

        public boolean isTaskSuccess() {
            return this.taskSuccess;
        }

        public String toString() {
            return "TaskResult{taskName='" + this.taskName + '\'' + ", subTaskSeekPositions=" + this.subTaskSeekPositions + ", taskSuccess=" + this.taskSuccess + '}';
        }

        public static class Builder {
            private String taskName;
            private Map<String, Integer> subTaskSeekPositions = Collections.emptyMap();
            private boolean taskSuccess;

            public Builder setTaskName(String taskName) {
                this.taskName = taskName;
                return this;
            }

            public Builder setSubTaskSeekPositions(Map<String, Integer> subTaskSeekPositions) {
                this.subTaskSeekPositions = subTaskSeekPositions;
                return this;
            }

            public Builder setTaskSuccess(boolean taskSuccess) {
                this.taskSuccess = taskSuccess;
                return this;
            }

            public TaskResult build() {
                return new TaskResult(this);
            }
        }
    }
}

