/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.ozone;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.util.GlobalTracer;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import org.apache.hadoop.fs.ByteBufferPositionedReadable;
import org.apache.hadoop.fs.ByteBufferReadable;
import org.apache.hadoop.fs.CanUnbuffer;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Seekable;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.annotation.InterfaceStability;
import org.apache.hadoop.hdds.tracing.TracingUtil;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class OzoneFSInputStream
extends FSInputStream
implements ByteBufferReadable,
CanUnbuffer,
ByteBufferPositionedReadable {
    private final InputStream inputStream;
    private final FileSystem.Statistics statistics;

    public OzoneFSInputStream(InputStream inputStream, FileSystem.Statistics statistics) {
        this.inputStream = inputStream;
        this.statistics = statistics;
    }

    /*
     * Loose catch block
     */
    public int read() throws IOException {
        Span span = GlobalTracer.get().buildSpan("OzoneFSInputStream.read").start();
        try {
            try (Scope scope = GlobalTracer.get().activateSpan(span);){
                int byteRead = this.inputStream.read();
                if (this.statistics != null && byteRead >= 0) {
                    this.statistics.incrementBytesRead(1L);
                }
                int n = byteRead;
                return n;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            span.finish();
        }
    }

    /*
     * Loose catch block
     */
    public int read(byte[] b, int off, int len) throws IOException {
        Span span = GlobalTracer.get().buildSpan("OzoneFSInputStream.read").start();
        try {
            try (Scope scope = GlobalTracer.get().activateSpan(span);){
                span.setTag("offset", (Number)off).setTag("length", (Number)len);
                int bytesRead = this.inputStream.read(b, off, len);
                if (this.statistics != null && bytesRead >= 0) {
                    this.statistics.incrementBytesRead((long)bytesRead);
                }
                int n = bytesRead;
                return n;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            span.finish();
        }
    }

    public synchronized void close() throws IOException {
        TracingUtil.executeInNewSpan((String)"OzoneFSInputStream.close", this.inputStream::close);
    }

    public void seek(long pos) throws IOException {
        ((Seekable)this.inputStream).seek(pos);
    }

    public long getPos() throws IOException {
        return ((Seekable)this.inputStream).getPos();
    }

    public long skip(long n) throws IOException {
        return this.inputStream.skip(n);
    }

    public boolean seekToNewSource(long targetPos) throws IOException {
        return false;
    }

    public int available() throws IOException {
        return this.inputStream.available();
    }

    public int read(ByteBuffer buf) throws IOException {
        return (Integer)TracingUtil.executeInNewSpan((String)"OzoneFSInputStream.read(ByteBuffer)", () -> this.readInTrace(buf));
    }

    private int readInTrace(ByteBuffer buf) throws IOException {
        int bytesRead;
        if (buf.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        if (this.inputStream instanceof ByteBufferReadable) {
            bytesRead = ((ByteBufferReadable)this.inputStream).read(buf);
        } else {
            int readLen = Math.min(buf.remaining(), this.available());
            if (buf.hasArray()) {
                int pos = buf.position();
                bytesRead = this.read(buf.array(), pos, readLen);
                if (bytesRead > 0) {
                    buf.position(pos + bytesRead);
                }
            } else {
                byte[] readData = new byte[readLen];
                bytesRead = this.read(readData, 0, readLen);
                if (bytesRead > 0) {
                    buf.put(readData);
                }
            }
        }
        if (this.statistics != null && bytesRead >= 0) {
            this.statistics.incrementBytesRead((long)bytesRead);
        }
        return bytesRead;
    }

    public void unbuffer() {
        if (this.inputStream instanceof CanUnbuffer) {
            ((CanUnbuffer)this.inputStream).unbuffer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(long position, ByteBuffer buf) throws IOException {
        int bytesRead;
        if (!buf.hasRemaining()) {
            return 0;
        }
        long oldPos = this.getPos();
        try {
            ((Seekable)this.inputStream).seek(position);
            bytesRead = ((ByteBufferReadable)this.inputStream).read(buf);
        }
        catch (EOFException e) {
            int n = -1;
            return n;
        }
        finally {
            ((Seekable)this.inputStream).seek(oldPos);
        }
        return bytesRead;
    }

    @Override
    public void readFully(long position, ByteBuffer buf) throws IOException {
        int readCount = 0;
        while (buf.hasRemaining()) {
            int bytesRead = this.read(position + (long)readCount, buf);
            if (bytesRead < 0) {
                throw new EOFException("End of file reached before reading fully.");
            }
            readCount += bytesRead;
        }
    }
}

