/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.snapshot;

import com.google.common.base.Preconditions;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.ozone.om.snapshot.ReferenceCountedCallback;

public class ReferenceCounted<T>
implements AutoCloseable {
    private final T obj;
    private final ConcurrentHashMap<Long, Long> threadMap;
    private final AtomicLong refCount;
    private final Object refCountLock = new Object();
    private final ReferenceCountedCallback parentWithCallback;

    public ReferenceCounted(T obj, boolean disableCounter, ReferenceCountedCallback parentWithCallback) {
        this.obj = obj;
        if (disableCounter) {
            this.threadMap = null;
            this.refCount = null;
        } else {
            this.threadMap = new ConcurrentHashMap();
            this.refCount = new AtomicLong(0L);
        }
        this.parentWithCallback = parentWithCallback;
    }

    public T get() {
        return this.obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long incrementRefCount() {
        if (this.refCount == null || this.threadMap == null) {
            return -1L;
        }
        long tid = Thread.currentThread().getId();
        this.threadMap.putIfAbsent(tid, 0L);
        Object object = this.refCountLock;
        synchronized (object) {
            this.threadMap.computeIfPresent(tid, (k, v) -> {
                long newVal = v + 1L;
                Preconditions.checkState((newVal > 0L ? 1 : 0) != 0, (Object)"Thread reference count overflown");
                return newVal;
            });
            long newValTotal = this.refCount.incrementAndGet();
            Preconditions.checkState((newValTotal > 0L ? 1 : 0) != 0, (Object)"Total reference count overflown");
        }
        return this.refCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long decrementRefCount() {
        if (this.refCount == null || this.threadMap == null) {
            return -1L;
        }
        long tid = Thread.currentThread().getId();
        Preconditions.checkState((boolean)this.threadMap.containsKey(tid), (Object)"Current thread have not holden reference before");
        Preconditions.checkState((this.threadMap.get(tid) > 0L ? 1 : 0) != 0, (Object)("This thread " + tid + " already have a reference count of zero."));
        Object object = this.refCountLock;
        synchronized (object) {
            this.threadMap.computeIfPresent(tid, (k, v) -> {
                long newValue = v - 1L;
                Preconditions.checkState((newValue >= 0L ? 1 : 0) != 0, (Object)"Thread reference count underflow");
                return newValue != 0L ? Long.valueOf(newValue) : null;
            });
            long newValTotal = this.refCount.decrementAndGet();
            Preconditions.checkState((newValTotal >= 0L ? 1 : 0) != 0, (Object)"Total reference count underflow");
        }
        if (this.refCount.get() == 0L) {
            this.parentWithCallback.callback(this);
        }
        return this.refCount.get();
    }

    public long getTotalRefCount() {
        if (this.refCount == null) {
            return -1L;
        }
        return this.refCount.get();
    }

    public long getCurrentThreadRefCount() {
        if (this.refCount == null || this.threadMap == null) {
            return -1L;
        }
        long tid = Thread.currentThread().getId();
        return this.threadMap.getOrDefault(tid, 0L);
    }

    @Override
    public void close() {
        this.decrementRefCount();
    }
}

