/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3.endpoint;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hdds.client.ReplicationType;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.S3GAction;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneKey;
import org.apache.hadoop.ozone.client.OzoneMultipartUploadList;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.ErrorInfo;
import org.apache.hadoop.ozone.om.helpers.OzoneAclUtil;
import org.apache.hadoop.ozone.s3.commontypes.EncodingTypeObject;
import org.apache.hadoop.ozone.s3.commontypes.KeyMetadata;
import org.apache.hadoop.ozone.s3.endpoint.EndpointBase;
import org.apache.hadoop.ozone.s3.endpoint.ListMultipartUploadsResult;
import org.apache.hadoop.ozone.s3.endpoint.ListObjectResponse;
import org.apache.hadoop.ozone.s3.endpoint.MultiDeleteRequest;
import org.apache.hadoop.ozone.s3.endpoint.MultiDeleteResponse;
import org.apache.hadoop.ozone.s3.endpoint.ObjectEndpoint;
import org.apache.hadoop.ozone.s3.endpoint.PutBucketAclRequestUnmarshaller;
import org.apache.hadoop.ozone.s3.endpoint.S3Acl;
import org.apache.hadoop.ozone.s3.endpoint.S3BucketAcl;
import org.apache.hadoop.ozone.s3.endpoint.S3Owner;
import org.apache.hadoop.ozone.s3.exception.OS3Exception;
import org.apache.hadoop.ozone.s3.exception.S3ErrorTable;
import org.apache.hadoop.ozone.s3.util.ContinueToken;
import org.apache.hadoop.ozone.s3.util.S3StorageType;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/{bucket}")
public class BucketEndpoint
extends EndpointBase {
    private static final Logger LOG = LoggerFactory.getLogger(BucketEndpoint.class);
    private boolean listKeysShallowEnabled;
    @Inject
    private OzoneConfiguration ozoneConfiguration;

    @GET
    public Response get(@PathParam(value="bucket") String bucketName, @QueryParam(value="delimiter") String delimiter, @QueryParam(value="encoding-type") String encodingType, @QueryParam(value="marker") String marker, @DefaultValue(value="1000") @QueryParam(value="max-keys") int maxKeys, @QueryParam(value="prefix") String prefix, @QueryParam(value="continuation-token") String continueToken, @QueryParam(value="start-after") String startAfter, @QueryParam(value="uploads") String uploads, @QueryParam(value="acl") String aclMarker, @QueryParam(value="key-marker") String keyMarker, @QueryParam(value="upload-id-marker") String uploadIdMarker, @DefaultValue(value="1000") @QueryParam(value="max-uploads") int maxUploads, @Context HttpHeaders hh) throws OS3Exception, IOException {
        long startNanos = Time.monotonicNowNanos();
        S3GAction s3GAction = S3GAction.GET_BUCKET;
        AuditLogger.PerformanceStringBuilder perf = new AuditLogger.PerformanceStringBuilder();
        Iterator ozoneKeyIterator = null;
        ContinueToken decodedToken = ContinueToken.decodeFromString(continueToken);
        OzoneBucket bucket = null;
        try {
            if (aclMarker != null) {
                s3GAction = S3GAction.GET_ACL;
                S3BucketAcl result = this.getAcl(bucketName);
                this.getMetrics().updateGetAclSuccessStats(startNanos);
                AUDIT.logReadSuccess(this.buildAuditMessageForSuccess(s3GAction, this.getAuditParameters()));
                return Response.ok((Object)result, (MediaType)MediaType.APPLICATION_XML_TYPE).build();
            }
            if (uploads != null) {
                s3GAction = S3GAction.LIST_MULTIPART_UPLOAD;
                return this.listMultipartUploads(bucketName, prefix, keyMarker, uploadIdMarker, maxUploads);
            }
            if (prefix == null) {
                prefix = "";
            }
            if (startAfter == null && marker != null) {
                startAfter = marker;
            }
            String prevKey = continueToken != null ? decodedToken.getLastKey() : startAfter;
            boolean shallow = this.listKeysShallowEnabled && "/".equals(delimiter);
            bucket = this.getBucket(bucketName);
            ozoneKeyIterator = bucket.listKeys(prefix, prevKey, shallow);
        }
        catch (OMException ex) {
            AUDIT.logReadFailure(this.buildAuditMessageForFailure(s3GAction, this.getAuditParameters(), ex));
            this.getMetrics().updateGetBucketFailureStats(startNanos);
            if (this.isAccessDenied(ex)) {
                throw S3ErrorTable.newError(S3ErrorTable.ACCESS_DENIED, bucketName, (Exception)((Object)ex));
            }
            if (ex.getResult() == OMException.ResultCodes.FILE_NOT_FOUND) {
                LOG.debug("Key Not found prefix: {}", (Object)prefix);
            }
            throw ex;
        }
        catch (Exception ex) {
            this.getMetrics().updateGetBucketFailureStats(startNanos);
            AUDIT.logReadFailure(this.buildAuditMessageForFailure(s3GAction, this.getAuditParameters(), ex));
            throw ex;
        }
        if (encodingType != null && !encodingType.equals("url")) {
            throw S3ErrorTable.newError(S3ErrorTable.INVALID_ARGUMENT, encodingType);
        }
        ListObjectResponse response = new ListObjectResponse();
        response.setDelimiter(EncodingTypeObject.createNullable(delimiter, encodingType));
        response.setName(bucketName);
        response.setPrefix(EncodingTypeObject.createNullable(prefix, encodingType));
        response.setMarker(marker == null ? "" : marker);
        response.setMaxKeys(maxKeys);
        response.setEncodingType(encodingType);
        response.setTruncated(false);
        response.setContinueToken(continueToken);
        response.setStartAfter(EncodingTypeObject.createNullable(startAfter, encodingType));
        String prevDir = null;
        if (continueToken != null) {
            prevDir = decodedToken.getLastDir();
        }
        String lastKey = null;
        int count = 0;
        while (ozoneKeyIterator != null && ozoneKeyIterator.hasNext()) {
            OzoneKey next = (OzoneKey)ozoneKeyIterator.next();
            if (bucket != null && bucket.getBucketLayout().isFileSystemOptimized() && StringUtils.isNotEmpty((CharSequence)prefix) && !next.getName().startsWith(prefix) || startAfter != null && count == 0 && Objects.equals(startAfter, next.getName())) continue;
            String relativeKeyName = next.getName().substring(prefix.length());
            int depth = StringUtils.countMatches((CharSequence)relativeKeyName, (CharSequence)delimiter);
            if (!StringUtils.isEmpty((CharSequence)delimiter)) {
                if (depth > 0) {
                    String dirName = relativeKeyName.substring(0, relativeKeyName.indexOf(delimiter));
                    if (!dirName.equals(prevDir)) {
                        response.addPrefix(EncodingTypeObject.createNullable(prefix + dirName + delimiter, encodingType));
                        prevDir = dirName;
                        ++count;
                    }
                } else if (relativeKeyName.endsWith(delimiter)) {
                    response.addPrefix(EncodingTypeObject.createNullable(relativeKeyName, encodingType));
                    ++count;
                } else {
                    this.addKey(response, next);
                    ++count;
                }
            } else {
                this.addKey(response, next);
                ++count;
            }
            if (count != maxKeys) continue;
            lastKey = next.getName();
            break;
        }
        response.setKeyCount(count);
        if (count < maxKeys) {
            response.setTruncated(false);
        } else if (ozoneKeyIterator.hasNext()) {
            response.setTruncated(true);
            ContinueToken nextToken = new ContinueToken(lastKey, prevDir);
            response.setNextToken(nextToken.encodeToString());
            response.setNextMarker(lastKey);
        } else {
            response.setTruncated(false);
        }
        int keyCount = response.getCommonPrefixes().size() + response.getContents().size();
        long opLatencyNs = this.getMetrics().updateGetBucketSuccessStats(startNanos);
        this.getMetrics().incListKeyCount(keyCount);
        perf.appendCount((long)keyCount);
        perf.appendOpLatencyNanos(opLatencyNs);
        AUDIT.logReadSuccess(this.buildAuditMessageForSuccess(s3GAction, this.getAuditParameters(), perf));
        response.setKeyCount(keyCount);
        return Response.ok((Object)response).build();
    }

    @PUT
    public Response put(@PathParam(value="bucket") String bucketName, @QueryParam(value="acl") String aclMarker, @Context HttpHeaders httpHeaders, InputStream body) throws IOException, OS3Exception {
        long startNanos = Time.monotonicNowNanos();
        S3GAction s3GAction = S3GAction.CREATE_BUCKET;
        try {
            if (aclMarker != null) {
                s3GAction = S3GAction.PUT_ACL;
                Response response = this.putAcl(bucketName, httpHeaders, body);
                AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess(s3GAction, this.getAuditParameters()));
                return response;
            }
            String location = this.createS3Bucket(bucketName);
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess(s3GAction, this.getAuditParameters()));
            this.getMetrics().updateCreateBucketSuccessStats(startNanos);
            return Response.status((int)200).header("Location", (Object)location).build();
        }
        catch (OMException exception) {
            this.auditWriteFailure(s3GAction, exception);
            this.getMetrics().updateCreateBucketFailureStats(startNanos);
            if (exception.getResult() == OMException.ResultCodes.INVALID_BUCKET_NAME) {
                throw S3ErrorTable.newError(S3ErrorTable.INVALID_BUCKET_NAME, bucketName, (Exception)((Object)exception));
            }
            throw exception;
        }
        catch (Exception ex) {
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure(s3GAction, this.getAuditParameters(), ex));
            throw ex;
        }
    }

    public Response listMultipartUploads(String bucketName, String prefix, String keyMarker, String uploadIdMarker, int maxUploads) throws OS3Exception, IOException {
        if (maxUploads < 1 || maxUploads > 1000) {
            throw S3ErrorTable.newError(S3ErrorTable.INVALID_ARGUMENT, "max-uploads", new Exception("max-uploads must be between 1 and 1000"));
        }
        long startNanos = Time.monotonicNowNanos();
        S3GAction s3GAction = S3GAction.LIST_MULTIPART_UPLOAD;
        OzoneBucket bucket = this.getBucket(bucketName);
        try {
            OzoneMultipartUploadList ozoneMultipartUploadList = bucket.listMultipartUploads(prefix, keyMarker, uploadIdMarker, maxUploads);
            ListMultipartUploadsResult result = new ListMultipartUploadsResult();
            result.setBucket(bucketName);
            result.setKeyMarker(keyMarker);
            result.setUploadIdMarker(uploadIdMarker);
            result.setNextKeyMarker(ozoneMultipartUploadList.getNextKeyMarker());
            result.setPrefix(prefix);
            result.setNextUploadIdMarker(ozoneMultipartUploadList.getNextUploadIdMarker());
            result.setMaxUploads(maxUploads);
            result.setTruncated(ozoneMultipartUploadList.isTruncated());
            ozoneMultipartUploadList.getUploads().forEach(upload -> result.addUpload(new ListMultipartUploadsResult.Upload(upload.getKeyName(), upload.getUploadId(), upload.getCreationTime(), S3StorageType.fromReplicationConfig(upload.getReplicationConfig()))));
            AUDIT.logReadSuccess(this.buildAuditMessageForSuccess(s3GAction, this.getAuditParameters()));
            this.getMetrics().updateListMultipartUploadsSuccessStats(startNanos);
            return Response.ok((Object)result).build();
        }
        catch (OMException exception) {
            AUDIT.logReadFailure(this.buildAuditMessageForFailure(s3GAction, this.getAuditParameters(), exception));
            this.getMetrics().updateListMultipartUploadsFailureStats(startNanos);
            if (this.isAccessDenied(exception)) {
                throw S3ErrorTable.newError(S3ErrorTable.ACCESS_DENIED, prefix, (Exception)((Object)exception));
            }
            throw exception;
        }
        catch (Exception ex) {
            AUDIT.logReadFailure(this.buildAuditMessageForFailure(s3GAction, this.getAuditParameters(), ex));
            throw ex;
        }
    }

    @HEAD
    public Response head(@PathParam(value="bucket") String bucketName) throws OS3Exception, IOException {
        long startNanos = Time.monotonicNowNanos();
        S3GAction s3GAction = S3GAction.HEAD_BUCKET;
        try {
            this.getBucket(bucketName);
            AUDIT.logReadSuccess(this.buildAuditMessageForSuccess(s3GAction, this.getAuditParameters()));
            this.getMetrics().updateHeadBucketSuccessStats(startNanos);
            return Response.ok().build();
        }
        catch (Exception e) {
            AUDIT.logReadFailure(this.buildAuditMessageForFailure(s3GAction, this.getAuditParameters(), e));
            throw e;
        }
    }

    @DELETE
    public Response delete(@PathParam(value="bucket") String bucketName) throws IOException, OS3Exception {
        long startNanos = Time.monotonicNowNanos();
        S3GAction s3GAction = S3GAction.DELETE_BUCKET;
        try {
            this.deleteS3Bucket(bucketName);
        }
        catch (OMException ex) {
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure(s3GAction, this.getAuditParameters(), ex));
            this.getMetrics().updateDeleteBucketFailureStats(startNanos);
            if (ex.getResult() == OMException.ResultCodes.BUCKET_NOT_EMPTY) {
                throw S3ErrorTable.newError(S3ErrorTable.BUCKET_NOT_EMPTY, bucketName, (Exception)((Object)ex));
            }
            if (ex.getResult() == OMException.ResultCodes.BUCKET_NOT_FOUND) {
                throw S3ErrorTable.newError(S3ErrorTable.NO_SUCH_BUCKET, bucketName, (Exception)((Object)ex));
            }
            if (this.isAccessDenied(ex)) {
                throw S3ErrorTable.newError(S3ErrorTable.ACCESS_DENIED, bucketName, (Exception)((Object)ex));
            }
            throw ex;
        }
        catch (Exception ex) {
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure(s3GAction, this.getAuditParameters(), ex));
            throw ex;
        }
        AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess(s3GAction, this.getAuditParameters()));
        this.getMetrics().updateDeleteBucketSuccessStats(startNanos);
        return Response.status((int)204).build();
    }

    @POST
    @Produces(value={"application/xml"})
    public MultiDeleteResponse multiDelete(@PathParam(value="bucket") String bucketName, @QueryParam(value="delete") String delete, MultiDeleteRequest request) throws OS3Exception, IOException {
        S3GAction s3GAction = S3GAction.MULTI_DELETE;
        OzoneBucket bucket = this.getBucket(bucketName);
        MultiDeleteResponse result = new MultiDeleteResponse();
        ArrayList<String> deleteKeys = new ArrayList<String>();
        if (request.getObjects() != null) {
            for (MultiDeleteRequest.DeleteObject keyToDelete : request.getObjects()) {
                deleteKeys.add(keyToDelete.getKey());
            }
            long startNanos = Time.monotonicNowNanos();
            try {
                Map undeletedKeyResultMap = bucket.deleteKeys(deleteKeys, true);
                for (MultiDeleteRequest.DeleteObject d : request.getObjects()) {
                    boolean deleted;
                    ErrorInfo error = (ErrorInfo)undeletedKeyResultMap.get(d.getKey());
                    boolean bl = deleted = error == null || OMException.ResultCodes.KEY_NOT_FOUND.name().equals(error.getCode());
                    if (deleted) {
                        deleteKeys.remove(d.getKey());
                        if (request.isQuiet()) continue;
                        result.addDeleted(new MultiDeleteResponse.DeletedObject(d.getKey()));
                        continue;
                    }
                    result.addError(new MultiDeleteResponse.Error(d.getKey(), error.getCode(), error.getMessage()));
                }
                this.getMetrics().updateDeleteKeySuccessStats(startNanos);
            }
            catch (IOException ex) {
                LOG.error("Delete key failed: {}", (Object)ex.getMessage());
                this.getMetrics().updateDeleteKeyFailureStats(startNanos);
                result.addError(new MultiDeleteResponse.Error("ALL", "InternalError", ex.getMessage()));
            }
        }
        Map<String, String> auditMap = this.getAuditParameters();
        auditMap.put("failedDeletes", ((Object)deleteKeys).toString());
        if (!result.getErrors().isEmpty()) {
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure(s3GAction, auditMap, new Exception("MultiDelete Exception")));
        } else {
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess(s3GAction, auditMap));
        }
        return result;
    }

    public S3BucketAcl getAcl(String bucketName) throws OS3Exception, IOException {
        long startNanos = Time.monotonicNowNanos();
        S3BucketAcl result = new S3BucketAcl();
        try {
            OzoneBucket bucket = this.getBucket(bucketName);
            OzoneVolume volume = this.getVolume();
            S3Owner owner = new S3Owner(volume.getOwner(), volume.getOwner());
            result.setOwner(owner);
            HashSet<S3BucketAcl.Grant> grantSet = new HashSet<S3BucketAcl.Grant>();
            for (OzoneAcl acl : bucket.getAcls()) {
                List<S3BucketAcl.Grant> grants = S3Acl.ozoneNativeAclToS3Acl(acl);
                grantSet.addAll(grants);
            }
            ArrayList<S3BucketAcl.Grant> grantList = new ArrayList<S3BucketAcl.Grant>();
            grantList.addAll(grantSet);
            result.setAclList(new S3BucketAcl.AccessControlList(grantList));
            return result;
        }
        catch (OMException ex) {
            this.getMetrics().updateGetAclFailureStats(startNanos);
            this.auditReadFailure(S3GAction.GET_ACL, (Exception)((Object)ex));
            if (ex.getResult() == OMException.ResultCodes.BUCKET_NOT_FOUND) {
                throw S3ErrorTable.newError(S3ErrorTable.NO_SUCH_BUCKET, bucketName, (Exception)((Object)ex));
            }
            if (this.isAccessDenied(ex)) {
                throw S3ErrorTable.newError(S3ErrorTable.ACCESS_DENIED, bucketName, (Exception)((Object)ex));
            }
            throw S3ErrorTable.newError(S3ErrorTable.INTERNAL_ERROR, bucketName, (Exception)((Object)ex));
        }
        catch (OS3Exception ex) {
            this.getMetrics().updateGetAclFailureStats(startNanos);
            throw ex;
        }
    }

    public Response putAcl(String bucketName, HttpHeaders httpHeaders, InputStream body) throws IOException, OS3Exception {
        long startNanos = Time.monotonicNowNanos();
        String grantReads = httpHeaders.getHeaderString("x-amz-grant-read");
        String grantWrites = httpHeaders.getHeaderString("x-amz-grant-write");
        String grantReadACP = httpHeaders.getHeaderString("x-amz-grant-read-acp");
        String grantWriteACP = httpHeaders.getHeaderString("x-amz-grant-write-acp");
        String grantFull = httpHeaders.getHeaderString("x-amz-grant-full-control");
        try {
            OzoneBucket bucket = this.getBucket(bucketName);
            OzoneVolume volume = this.getVolume();
            ArrayList<OzoneAcl> ozoneAclListOnBucket = new ArrayList<OzoneAcl>();
            ArrayList<OzoneAcl> ozoneAclListOnVolume = new ArrayList<OzoneAcl>();
            if (grantReads == null && grantWrites == null && grantReadACP == null && grantWriteACP == null && grantFull == null) {
                S3BucketAcl putBucketAclRequest = (S3BucketAcl)new PutBucketAclRequestUnmarshaller().readFrom(body);
                ozoneAclListOnBucket.addAll(S3Acl.s3AclToOzoneNativeAclOnBucket(putBucketAclRequest));
                ozoneAclListOnVolume.addAll(S3Acl.s3AclToOzoneNativeAclOnVolume(putBucketAclRequest));
            } else {
                if (grantReads != null) {
                    ozoneAclListOnBucket.addAll(this.getAndConvertAclOnBucket(grantReads, S3Acl.ACLType.READ.getValue()));
                    ozoneAclListOnVolume.addAll(this.getAndConvertAclOnVolume(grantReads, S3Acl.ACLType.READ.getValue()));
                }
                if (grantWrites != null) {
                    ozoneAclListOnBucket.addAll(this.getAndConvertAclOnBucket(grantWrites, S3Acl.ACLType.WRITE.getValue()));
                    ozoneAclListOnVolume.addAll(this.getAndConvertAclOnVolume(grantWrites, S3Acl.ACLType.WRITE.getValue()));
                }
                if (grantReadACP != null) {
                    ozoneAclListOnBucket.addAll(this.getAndConvertAclOnBucket(grantReadACP, S3Acl.ACLType.READ_ACP.getValue()));
                    ozoneAclListOnVolume.addAll(this.getAndConvertAclOnVolume(grantReadACP, S3Acl.ACLType.READ_ACP.getValue()));
                }
                if (grantWriteACP != null) {
                    ozoneAclListOnBucket.addAll(this.getAndConvertAclOnBucket(grantWriteACP, S3Acl.ACLType.WRITE_ACP.getValue()));
                    ozoneAclListOnVolume.addAll(this.getAndConvertAclOnVolume(grantWriteACP, S3Acl.ACLType.WRITE_ACP.getValue()));
                }
                if (grantFull != null) {
                    ozoneAclListOnBucket.addAll(this.getAndConvertAclOnBucket(grantFull, S3Acl.ACLType.FULL_CONTROL.getValue()));
                    ozoneAclListOnVolume.addAll(this.getAndConvertAclOnVolume(grantFull, S3Acl.ACLType.FULL_CONTROL.getValue()));
                }
            }
            bucket.setAcl(ozoneAclListOnBucket);
            List acls = bucket.getAcls();
            ArrayList aclsToRemoveOnVolume = new ArrayList();
            List currentAclsOnVolume = volume.getAcls();
            if (!currentAclsOnVolume.isEmpty()) {
                for (OzoneAcl acl : acls) {
                    if (acl.getAclScope() != OzoneAcl.AclScope.ACCESS) continue;
                    aclsToRemoveOnVolume.addAll(OzoneAclUtil.filterAclList((String)acl.getName(), (IAccessAuthorizer.ACLIdentityType)acl.getType(), (List)currentAclsOnVolume));
                }
                for (OzoneAcl acl : aclsToRemoveOnVolume) {
                    volume.removeAcl(acl);
                }
            }
            for (OzoneAcl acl : ozoneAclListOnVolume) {
                volume.addAcl(acl);
            }
        }
        catch (OMException exception) {
            this.getMetrics().updatePutAclFailureStats(startNanos);
            this.auditWriteFailure(S3GAction.PUT_ACL, exception);
            if (exception.getResult() == OMException.ResultCodes.BUCKET_NOT_FOUND) {
                throw S3ErrorTable.newError(S3ErrorTable.NO_SUCH_BUCKET, bucketName, (Exception)((Object)exception));
            }
            if (this.isAccessDenied(exception)) {
                throw S3ErrorTable.newError(S3ErrorTable.ACCESS_DENIED, bucketName, (Exception)((Object)exception));
            }
            throw exception;
        }
        catch (OS3Exception ex) {
            this.getMetrics().updatePutAclFailureStats(startNanos);
            throw ex;
        }
        this.getMetrics().updatePutAclSuccessStats(startNanos);
        return Response.status((int)200).build();
    }

    private List<OzoneAcl> getAndConvertAclOnBucket(String value, String permission) throws OS3Exception {
        String[] subValues;
        ArrayList<OzoneAcl> ozoneAclList = new ArrayList<OzoneAcl>();
        if (StringUtils.isEmpty((CharSequence)value)) {
            return ozoneAclList;
        }
        for (String acl : subValues = value.split(",")) {
            String[] part = acl.split("=");
            if (part.length != 2) {
                throw S3ErrorTable.newError(S3ErrorTable.INVALID_ARGUMENT, acl);
            }
            S3Acl.ACLIdentityType type = S3Acl.ACLIdentityType.getTypeFromHeaderType(part[0]);
            if (type == null || !type.isSupported()) {
                LOG.warn("S3 grantee {} is null or not supported", (Object)part[0]);
                throw S3ErrorTable.newError(S3ErrorTable.NOT_IMPLEMENTED, part[0]);
            }
            EnumSet<IAccessAuthorizer.ACLType> aclsOnBucket = S3Acl.getOzoneAclOnBucketFromS3Permission(permission);
            OzoneAcl defaultOzoneAcl = new OzoneAcl(IAccessAuthorizer.ACLIdentityType.USER, part[1], OzoneAcl.AclScope.DEFAULT, aclsOnBucket);
            OzoneAcl accessOzoneAcl = new OzoneAcl(IAccessAuthorizer.ACLIdentityType.USER, part[1], OzoneAcl.AclScope.ACCESS, aclsOnBucket);
            ozoneAclList.add(defaultOzoneAcl);
            ozoneAclList.add(accessOzoneAcl);
        }
        return ozoneAclList;
    }

    private List<OzoneAcl> getAndConvertAclOnVolume(String value, String permission) throws OS3Exception {
        String[] subValues;
        ArrayList<OzoneAcl> ozoneAclList = new ArrayList<OzoneAcl>();
        if (StringUtils.isEmpty((CharSequence)value)) {
            return ozoneAclList;
        }
        for (String acl : subValues = value.split(",")) {
            String[] part = acl.split("=");
            if (part.length != 2) {
                throw S3ErrorTable.newError(S3ErrorTable.INVALID_ARGUMENT, acl);
            }
            S3Acl.ACLIdentityType type = S3Acl.ACLIdentityType.getTypeFromHeaderType(part[0]);
            if (type == null || !type.isSupported()) {
                LOG.warn("S3 grantee {} is null or not supported", (Object)part[0]);
                throw S3ErrorTable.newError(S3ErrorTable.NOT_IMPLEMENTED, part[0]);
            }
            EnumSet<IAccessAuthorizer.ACLType> aclsOnVolume = S3Acl.getOzoneAclOnVolumeFromS3Permission(permission);
            OzoneAcl accessOzoneAcl = new OzoneAcl(IAccessAuthorizer.ACLIdentityType.USER, part[1], OzoneAcl.AclScope.ACCESS, aclsOnVolume);
            ozoneAclList.add(accessOzoneAcl);
        }
        return ozoneAclList;
    }

    private void addKey(ListObjectResponse response, OzoneKey next) {
        String ownerName;
        KeyMetadata keyMetadata = new KeyMetadata();
        keyMetadata.setKey(EncodingTypeObject.createNullable(next.getName(), response.getEncodingType()));
        keyMetadata.setSize(next.getDataSize());
        String eTag = (String)next.getMetadata().get("ETag");
        if (eTag != null) {
            keyMetadata.setETag(ObjectEndpoint.wrapInQuotes(eTag));
        }
        if (next.getReplicationType().toString().equals(ReplicationType.STAND_ALONE.toString())) {
            keyMetadata.setStorageClass(S3StorageType.REDUCED_REDUNDANCY.toString());
        } else {
            keyMetadata.setStorageClass(S3StorageType.STANDARD.toString());
        }
        keyMetadata.setLastModified(next.getModificationTime());
        String displayName = ownerName = next.getOwner();
        keyMetadata.setOwner(new S3Owner(ownerName, displayName));
        response.addKey(keyMetadata);
    }

    @Override
    public void init() {
        this.listKeysShallowEnabled = this.ozoneConfiguration.getBoolean("ozone.s3g.list-keys.shallow.enabled", true);
    }
}

