/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3secret;

import jakarta.annotation.Nullable;
import java.io.IOException;
import javax.ws.rs.DELETE;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.apache.hadoop.ozone.audit.S3GAction;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.S3SecretValue;
import org.apache.hadoop.ozone.s3secret.S3AdminEndpoint;
import org.apache.hadoop.ozone.s3secret.S3SecretEnabled;
import org.apache.hadoop.ozone.s3secret.S3SecretEndpointBase;
import org.apache.hadoop.ozone.s3secret.S3SecretResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
@S3SecretEnabled
@S3AdminEndpoint
public class S3SecretManagementEndpoint
extends S3SecretEndpointBase {
    private static final Logger LOG = LoggerFactory.getLogger(S3SecretManagementEndpoint.class);

    @PUT
    public Response generate() throws IOException {
        return this.generateInternal(null);
    }

    @PUT
    @Path(value="/{username}")
    public Response generate(@PathParam(value="username") String username) throws IOException {
        return this.generateInternal(username);
    }

    private Response generateInternal(@Nullable String username) throws IOException {
        try {
            S3SecretValue s3SecretValue = this.generateS3Secret(username);
            S3SecretResponse s3SecretResponse = new S3SecretResponse();
            s3SecretResponse.setAwsSecret(s3SecretValue.getAwsSecret());
            s3SecretResponse.setAwsAccessKey(s3SecretValue.getAwsAccessKey());
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess(S3GAction.GENERATE_SECRET, this.getAuditParameters()));
            return Response.ok((Object)s3SecretResponse).build();
        }
        catch (OMException e) {
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure(S3GAction.GENERATE_SECRET, this.getAuditParameters(), e));
            if (e.getResult() == OMException.ResultCodes.S3_SECRET_ALREADY_EXISTS) {
                return Response.status((int)Response.Status.BAD_REQUEST.getStatusCode(), (String)e.getResult().toString()).build();
            }
            LOG.error("Can't execute get secret request: ", (Throwable)e);
            return Response.serverError().build();
        }
    }

    private S3SecretValue generateS3Secret(@Nullable String username) throws IOException {
        String actualUsername = username == null ? this.userNameFromRequest() : username;
        return this.getClient().getObjectStore().getS3Secret(actualUsername);
    }

    @DELETE
    public Response revoke() throws IOException {
        return this.revokeInternal(null);
    }

    @DELETE
    @Path(value="/{username}")
    public Response revoke(@PathParam(value="username") String username) throws IOException {
        return this.revokeInternal(username);
    }

    private Response revokeInternal(@Nullable String username) throws IOException {
        try {
            this.revokeSecret(username);
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess(S3GAction.REVOKE_SECRET, this.getAuditParameters()));
            return Response.ok().build();
        }
        catch (OMException e) {
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure(S3GAction.REVOKE_SECRET, this.getAuditParameters(), e));
            if (e.getResult() == OMException.ResultCodes.S3_SECRET_NOT_FOUND) {
                return Response.status((int)Response.Status.NOT_FOUND.getStatusCode(), (String)OMException.ResultCodes.S3_SECRET_NOT_FOUND.toString()).build();
            }
            LOG.error("Can't execute revoke secret request: ", (Throwable)e);
            return Response.serverError().build();
        }
    }

    private void revokeSecret(@Nullable String username) throws IOException {
        String actualUsername = username == null ? this.userNameFromRequest() : username;
        this.getClient().getObjectStore().revokeS3Secret(actualUsername);
    }
}

