/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.cli.container;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.io.File;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.hdds.cli.AbstractSubcommand;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.cli.container.upgrade.UpgradeChecker;
import org.apache.hadoop.hdds.scm.cli.container.upgrade.UpgradeManager;
import org.apache.hadoop.hdds.scm.cli.container.upgrade.UpgradeUtils;
import org.apache.hadoop.hdds.server.OzoneAdmins;
import org.apache.hadoop.hdds.upgrade.HDDSLayoutFeature;
import org.apache.hadoop.ozone.container.common.volume.HddsVolume;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="upgrade", description={"Offline upgrade all schema V2 containers to schema V3 for this datanode."}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class UpgradeSubcommand
extends AbstractSubcommand
implements Callable<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(UpgradeSubcommand.class);
    @CommandLine.Option(names={"--volume"}, required=false, description={"volume path"})
    private String volume;
    @CommandLine.Option(names={"-y", "--yes"}, description={"Continue without interactive user confirmation"})
    private boolean yes;
    private static OzoneConfiguration ozoneConfiguration;

    @Override
    public Void call() throws Exception {
        HddsProtos.NodeOperationalState opState;
        OzoneConfiguration configuration = this.getConfiguration();
        OzoneAdmins admins = OzoneAdmins.getOzoneAdmins((String)"", (OzoneConfiguration)configuration);
        if (!admins.isAdmin(UserGroupInformation.getCurrentUser())) {
            this.out().println("It requires ozone administrator privilege. Current user is " + UserGroupInformation.getCurrentUser() + ".");
            return null;
        }
        UpgradeChecker upgradeChecker = new UpgradeChecker();
        Pair<Boolean, String> pair = upgradeChecker.checkDatanodeRunning();
        boolean isRunning = (Boolean)pair.getKey();
        if (isRunning) {
            this.out().println((String)pair.getValue());
            return null;
        }
        DatanodeDetails dnDetail = UpgradeUtils.getDatanodeDetails(configuration);
        Pair<HDDSLayoutFeature, HDDSLayoutFeature> layoutFeature = upgradeChecker.getLayoutFeature(dnDetail, configuration);
        HDDSLayoutFeature softwareLayoutFeature = (HDDSLayoutFeature)layoutFeature.getLeft();
        HDDSLayoutFeature metadataLayoutFeature = (HDDSLayoutFeature)layoutFeature.getRight();
        int needLayoutVersion = HDDSLayoutFeature.DATANODE_SCHEMA_V3.layoutVersion();
        if (metadataLayoutFeature.layoutVersion() < needLayoutVersion || softwareLayoutFeature.layoutVersion() < needLayoutVersion) {
            this.out().println(String.format("Please upgrade your software version, no less than %s, current metadata layout version is %s, software layout version is %s", HDDSLayoutFeature.DATANODE_SCHEMA_V3.name(), metadataLayoutFeature.name(), softwareLayoutFeature.name()));
            return null;
        }
        if (!Strings.isNullOrEmpty((String)this.volume)) {
            File volumeDir = new File(this.volume);
            if (!volumeDir.exists() || !volumeDir.isDirectory()) {
                this.out().println(String.format("Volume path %s is not a directory or doesn't exist", this.volume));
                return null;
            }
            File hddsRootDir = new File(this.volume + "/" + "hdds");
            File versionFile = new File(this.volume + "/" + "hdds" + "/" + "VERSION");
            if (!(hddsRootDir.exists() && hddsRootDir.isDirectory() && versionFile.exists() && versionFile.isFile())) {
                this.out().println(String.format("Volume path %s is not a valid data volume", this.volume));
                return null;
            }
            configuration.set("hdds.datanode.dir", this.volume);
        }
        if (!(opState = dnDetail.getPersistedOpState()).equals((Object)HddsProtos.NodeOperationalState.IN_MAINTENANCE)) {
            this.out().println("This command requires the datanode's NodeOperationalState to be IN_MAINTENANCE, currently is " + opState);
            return null;
        }
        List<HddsVolume> allVolume = upgradeChecker.getAllVolume(dnDetail, configuration);
        Iterator<HddsVolume> volumeIterator = allVolume.iterator();
        while (volumeIterator.hasNext()) {
            HddsVolume hddsVolume = volumeIterator.next();
            if (!UpgradeChecker.isAlreadyUpgraded(hddsVolume)) continue;
            this.out().println("Volume " + hddsVolume.getVolumeRootDir() + " is already upgraded, skip it.");
            volumeIterator.remove();
        }
        if (allVolume.isEmpty()) {
            this.out().println("There is no more volume to upgrade. Exit.");
            return null;
        }
        if (!this.yes) {
            Scanner scanner = new Scanner(new InputStreamReader(System.in, StandardCharsets.UTF_8));
            System.out.println("All volume db stores will be automatically backup, should we continue the upgrade ? [yes|no] : ");
            boolean confirm = scanner.next().trim().equals("yes");
            scanner.close();
            if (!confirm) {
                return null;
            }
        }
        UpgradeManager upgradeManager = new UpgradeManager();
        upgradeManager.run(configuration, allVolume);
        return null;
    }

    @VisibleForTesting
    public static void setOzoneConfiguration(OzoneConfiguration config) {
        ozoneConfiguration = config;
    }

    private OzoneConfiguration getConfiguration() {
        if (ozoneConfiguration == null) {
            ozoneConfiguration = new OzoneConfiguration();
        }
        return ozoneConfiguration;
    }
}

