/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.policyevaluator;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.conditionevaluator.RangerAbstractConditionEvaluator;
import org.apache.ranger.plugin.conditionevaluator.RangerConditionEvaluator;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.apache.ranger.plugin.policyengine.RangerPolicyEngineOptions;
import org.apache.ranger.plugin.policyevaluator.RangerAbstractPolicyItemEvaluator;
import org.apache.ranger.plugin.policyevaluator.RangerCustomConditionEvaluator;
import org.apache.ranger.plugin.policyevaluator.RangerPolicyEvaluator;
import org.apache.ranger.plugin.policyresourcematcher.RangerPolicyResourceMatcher;
import org.apache.ranger.plugin.util.RangerAccessRequestUtil;
import org.apache.ranger.plugin.util.RangerPerfTracer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerDefaultPolicyItemEvaluator
extends RangerAbstractPolicyItemEvaluator {
    private static final Logger LOG = LoggerFactory.getLogger(RangerDefaultPolicyItemEvaluator.class);
    private static final Logger PERF_POLICYITEM_REQUEST_LOG = RangerPerfTracer.getPerfLogger("policyitem.request");
    private static final Logger PERF_POLICYCONDITION_REQUEST_LOG = RangerPerfTracer.getPerfLogger("policycondition.request");
    private boolean hasCurrentUser;
    private boolean hasResourceOwner;

    public RangerDefaultPolicyItemEvaluator(RangerServiceDef serviceDef, RangerPolicy policy, RangerPolicy.RangerPolicyItem policyItem, int policyItemType, int policyItemIndex, RangerPolicyEngineOptions options) {
        super(serviceDef, policy, policyItem, policyItemType, policyItemIndex, options);
    }

    @Override
    public void init() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerDefaultPolicyItemEvaluator(policyId=" + this.policyId + ", policyItem=" + this.policyItem + ", serviceType=" + this.getServiceType() + ", conditionsDisabled=" + this.getConditionsDisabledOption() + ")");
        }
        RangerCustomConditionEvaluator rangerCustomConditionEvaluator = new RangerCustomConditionEvaluator();
        this.conditionEvaluators = rangerCustomConditionEvaluator.getPolicyItemConditionEvaluator(this.policy, this.policyItem, this.serviceDef, this.options, this.policyItemIndex);
        List<String> users = this.policyItem.getUsers();
        this.hasCurrentUser = CollectionUtils.isNotEmpty(users) && users.contains("{USER}");
        boolean bl = this.hasResourceOwner = CollectionUtils.isNotEmpty(users) && users.contains("{OWNER}");
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerDefaultPolicyItemEvaluator(policyId=" + this.policyId + ", conditionsCount=" + this.getConditionEvaluators().size() + ")");
        }
    }

    @Override
    public boolean isMatch(RangerAccessRequest request) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerDefaultPolicyItemEvaluator.isMatch(" + request + ")");
        }
        boolean ret = false;
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYITEM_REQUEST_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_POLICYITEM_REQUEST_LOG, "RangerPolicyItemEvaluator.isMatch(resource=" + request.getResource().getAsString() + ")");
        }
        if (this.policyItem != null && this.matchUserGroupAndOwner(request)) {
            if (request.isAccessTypeDelegatedAdmin()) {
                if (this.policyItem.getDelegateAdmin().booleanValue()) {
                    ret = true;
                }
            } else if (CollectionUtils.isNotEmpty(this.policyItem.getAccesses())) {
                boolean isAccessTypeMatched = false;
                for (RangerPolicy.RangerPolicyItemAccess access : this.policyItem.getAccesses()) {
                    if (!access.getIsAllowed().booleanValue() || !StringUtils.equalsIgnoreCase((String)access.getType(), (String)request.getAccessType())) continue;
                    isAccessTypeMatched = true;
                    break;
                }
                if (isAccessTypeMatched && this.matchCustomConditions(request)) {
                    ret = true;
                }
            }
        }
        RangerPerfTracer.log(perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerDefaultPolicyItemEvaluator.isMatch(" + request + "): " + ret);
        }
        return ret;
    }

    @Override
    public boolean matchUserGroupAndOwner(String user, Set<String> userGroups, Set<String> roles, String owner) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerDefaultPolicyItemEvaluator.matchUserGroup(" + this.policyItem + ", " + user + ", " + userGroups + ", " + roles + ", " + owner + ")");
        }
        boolean ret = false;
        if (this.policyItem != null) {
            if (!ret && user != null && this.policyItem.getUsers() != null) {
                boolean bl = ret = this.hasCurrentUser || this.policyItem.getUsers().contains(user);
            }
            if (!ret && userGroups != null && this.policyItem.getGroups() != null) {
                boolean bl = ret = this.policyItem.getGroups().contains("public") || !Collections.disjoint(this.policyItem.getGroups(), userGroups);
            }
            if (!ret && CollectionUtils.isNotEmpty(roles) && CollectionUtils.isNotEmpty(this.policyItem.getRoles())) {
                boolean bl = ret = !Collections.disjoint(this.policyItem.getRoles(), roles);
            }
            if (!ret && this.hasResourceOwner) {
                boolean bl = ret = user != null && user.equals(owner);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerDefaultPolicyItemEvaluator.matchUserGroup(" + this.policyItem + ", " + user + ", " + userGroups + ", " + roles + ", " + owner + "): " + ret);
        }
        return ret;
    }

    private boolean matchUserGroupAndOwner(RangerAccessRequest request) {
        String resourceOwner;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerDefaultPolicyItemEvaluator.matchUserGroupAndOwner(" + request + ")");
        }
        boolean ret = false;
        String user = request.getUser();
        Set<String> userGroups = request.getUserGroups();
        RangerAccessResource accessedResource = request.getResource();
        String string = resourceOwner = accessedResource != null ? accessedResource.getOwnerUser() : null;
        if (!ret) {
            Set<String> roles = null;
            if (CollectionUtils.isNotEmpty(this.policyItem.getRoles())) {
                roles = RangerAccessRequestUtil.getCurrentUserRolesFromContext(request.getContext());
            }
            ret = this.matchUserGroupAndOwner(user, userGroups, roles, resourceOwner);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerDefaultPolicyItemEvaluator.matchUserGroupAndOwner(" + request + "): " + ret);
        }
        return ret;
    }

    @Override
    public boolean matchAccessType(String accessType) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerDefaultPolicyItemEvaluator.matchAccessType(" + accessType + ")");
        }
        boolean ret = false;
        if (this.policyItem != null) {
            boolean isAdminAccess = StringUtils.equals((String)accessType, (String)"_admin");
            if (isAdminAccess) {
                ret = this.policyItem.getDelegateAdmin();
            } else if (CollectionUtils.isNotEmpty(this.policyItem.getAccesses())) {
                boolean isAnyAccess = StringUtils.equals((String)accessType, (String)"_any");
                for (RangerPolicy.RangerPolicyItemAccess itemAccess : this.policyItem.getAccesses()) {
                    if (!itemAccess.getIsAllowed().booleanValue()) continue;
                    if (isAnyAccess) {
                        ret = true;
                    } else {
                        if (!StringUtils.equalsIgnoreCase((String)itemAccess.getType(), (String)accessType)) continue;
                        ret = true;
                    }
                    break;
                }
            } else if (StringUtils.isEmpty((String)accessType)) {
                ret = true;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerDefaultPolicyItemEvaluator.matchAccessType(" + accessType + "): " + ret);
        }
        return ret;
    }

    @Override
    public boolean matchCustomConditions(RangerAccessRequest request) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerDefaultPolicyItemEvaluator.matchCustomConditions(" + request + ")");
        }
        boolean ret = true;
        if (CollectionUtils.isNotEmpty((Collection)this.conditionEvaluators)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("RangerDefaultPolicyItemEvaluator.matchCustomConditions(): conditionCount=" + this.conditionEvaluators.size());
            }
            for (RangerConditionEvaluator conditionEvaluator : this.conditionEvaluators) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("evaluating condition: " + conditionEvaluator);
                }
                RangerPerfTracer perf = null;
                if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYCONDITION_REQUEST_LOG)) {
                    String conditionType = null;
                    if (conditionEvaluator instanceof RangerAbstractConditionEvaluator) {
                        conditionType = ((RangerAbstractConditionEvaluator)conditionEvaluator).getPolicyItemCondition().getType();
                    }
                    perf = RangerPerfTracer.getPerfTracer(PERF_POLICYCONDITION_REQUEST_LOG, "RangerConditionEvaluator.matchCondition(policyId=" + this.policyId + ",policyItemIndex=" + this.getPolicyItemIndex() + ",policyConditionType=" + conditionType + ")");
                }
                boolean conditionEvalResult = conditionEvaluator.isMatched(request);
                RangerPerfTracer.log(perf);
                if (conditionEvalResult) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug(conditionEvaluator + " returned false");
                }
                ret = false;
                break;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerDefaultPolicyItemEvaluator.matchCustomConditions(" + request + "): " + ret);
        }
        return ret;
    }

    @Override
    public void updateAccessResult(RangerPolicyEvaluator policyEvaluator, RangerAccessResult result, RangerPolicyResourceMatcher.MatchType matchType) {
        policyEvaluator.updateAccessResult(result, matchType, this.getPolicyItemType() != 1, this.getComments());
    }

    RangerServiceDef.RangerPolicyConditionDef getConditionDef(String conditionName) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerDefaultPolicyItemEvaluator.getConditionDef(" + conditionName + ")");
        }
        RangerServiceDef.RangerPolicyConditionDef ret = null;
        if (this.serviceDef != null && CollectionUtils.isNotEmpty(this.serviceDef.getPolicyConditions())) {
            for (RangerServiceDef.RangerPolicyConditionDef conditionDef : this.serviceDef.getPolicyConditions()) {
                if (!StringUtils.equals((String)conditionName, (String)conditionDef.getName())) continue;
                ret = conditionDef;
                break;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerDefaultPolicyItemEvaluator.getConditionDef(" + conditionName + "): " + ret);
        }
        return ret;
    }

    RangerConditionEvaluator newConditionEvaluator(String className) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerDefaultPolicyItemEvaluator.newConditionEvaluator(" + className + ")");
        }
        RangerConditionEvaluator evaluator = null;
        try {
            Class<?> matcherClass = Class.forName(className);
            evaluator = (RangerConditionEvaluator)matcherClass.newInstance();
        }
        catch (Throwable t) {
            LOG.error("RangerDefaultPolicyItemEvaluator.newConditionEvaluator(" + className + "): error instantiating evaluator", t);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerDefaultPolicyItemEvaluator.newConditionEvaluator(" + className + "): " + evaluator);
        }
        return evaluator;
    }
}

