/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.fs.http;

import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;

public interface HttpFSConstants {
    public static final String HTTP_GET = "GET";
    public static final String HTTP_PUT = "PUT";
    public static final String HTTP_POST = "POST";
    public static final String HTTP_DELETE = "DELETE";
    public static final String SCHEME = "webhdfs";
    public static final String OP_PARAM = "op";
    public static final String DO_AS_PARAM = "doas";
    public static final String OVERWRITE_PARAM = "overwrite";
    public static final String REPLICATION_PARAM = "replication";
    public static final String BLOCKSIZE_PARAM = "blocksize";
    public static final String PERMISSION_PARAM = "permission";
    public static final String UNMASKED_PERMISSION_PARAM = "unmaskedpermission";
    public static final String ACLSPEC_PARAM = "aclspec";
    public static final String DESTINATION_PARAM = "destination";
    public static final String RECURSIVE_PARAM = "recursive";
    public static final String SOURCES_PARAM = "sources";
    public static final String OWNER_PARAM = "owner";
    public static final String GROUP_PARAM = "group";
    public static final String MODIFICATION_TIME_PARAM = "modificationtime";
    public static final String ACCESS_TIME_PARAM = "accesstime";
    public static final String XATTR_NAME_PARAM = "xattr.name";
    public static final String XATTR_VALUE_PARAM = "xattr.value";
    public static final String XATTR_SET_FLAG_PARAM = "flag";
    public static final String XATTR_ENCODING_PARAM = "encoding";
    public static final String NEW_LENGTH_PARAM = "newlength";
    public static final String START_AFTER_PARAM = "startAfter";
    public static final String POLICY_NAME_PARAM = "storagepolicy";
    public static final String SNAPSHOT_NAME_PARAM = "snapshotname";
    public static final String OLD_SNAPSHOT_NAME_PARAM = "oldsnapshotname";
    public static final String FSACTION_MODE_PARAM = "fsaction";
    public static final String EC_POLICY_NAME_PARAM = "ecpolicy";
    public static final Short DEFAULT_PERMISSION = 493;
    public static final String ACLSPEC_DEFAULT = "";
    public static final String RENAME_JSON = "boolean";
    public static final String TRUNCATE_JSON = "boolean";
    public static final String DELETE_JSON = "boolean";
    public static final String MKDIRS_JSON = "boolean";
    public static final String HOME_DIR_JSON = "Path";
    public static final String TRASH_DIR_JSON = "Path";
    public static final String SET_REPLICATION_JSON = "boolean";
    public static final String UPLOAD_CONTENT_TYPE = "application/octet-stream";
    public static final String SNAPSHOT_JSON = "Path";
    public static final String FILE_STATUSES_JSON = "FileStatuses";
    public static final String FILE_STATUS_JSON = "FileStatus";
    public static final String PATH_SUFFIX_JSON = "pathSuffix";
    public static final String TYPE_JSON = "type";
    public static final String LENGTH_JSON = "length";
    public static final String OWNER_JSON = "owner";
    public static final String GROUP_JSON = "group";
    public static final String PERMISSION_JSON = "permission";
    public static final String ACCESS_TIME_JSON = "accessTime";
    public static final String MODIFICATION_TIME_JSON = "modificationTime";
    public static final String BLOCK_SIZE_JSON = "blockSize";
    public static final String CHILDREN_NUM_JSON = "childrenNum";
    public static final String FILE_ID_JSON = "fileId";
    public static final String REPLICATION_JSON = "replication";
    public static final String STORAGEPOLICY_JSON = "storagePolicy";
    public static final String ECPOLICYNAME_JSON = "ecPolicy";
    public static final String XATTRS_JSON = "XAttrs";
    public static final String XATTR_NAME_JSON = "name";
    public static final String XATTR_VALUE_JSON = "value";
    public static final String XATTRNAMES_JSON = "XAttrNames";
    public static final String ECPOLICY_JSON = "ecPolicyObj";
    public static final String SYMLINK_JSON = "symlink";
    public static final String FILE_CHECKSUM_JSON = "FileChecksum";
    public static final String CHECKSUM_ALGORITHM_JSON = "algorithm";
    public static final String CHECKSUM_BYTES_JSON = "bytes";
    public static final String CHECKSUM_LENGTH_JSON = "length";
    public static final String CONTENT_SUMMARY_JSON = "ContentSummary";
    public static final String CONTENT_SUMMARY_DIRECTORY_COUNT_JSON = "directoryCount";
    public static final String CONTENT_SUMMARY_ECPOLICY_JSON = "ecPolicy";
    public static final String CONTENT_SUMMARY_FILE_COUNT_JSON = "fileCount";
    public static final String CONTENT_SUMMARY_LENGTH_JSON = "length";
    public static final String QUOTA_USAGE_JSON = "QuotaUsage";
    public static final String QUOTA_USAGE_FILE_AND_DIRECTORY_COUNT_JSON = "fileAndDirectoryCount";
    public static final String QUOTA_USAGE_QUOTA_JSON = "quota";
    public static final String QUOTA_USAGE_SPACE_CONSUMED_JSON = "spaceConsumed";
    public static final String QUOTA_USAGE_SPACE_QUOTA_JSON = "spaceQuota";
    public static final String QUOTA_USAGE_CONSUMED_JSON = "consumed";
    public static final String QUOTA_USAGE_TYPE_QUOTA_JSON = "typeQuota";
    public static final String ACL_STATUS_JSON = "AclStatus";
    public static final String ACL_STICKY_BIT_JSON = "stickyBit";
    public static final String ACL_ENTRIES_JSON = "entries";
    public static final String ACL_BIT_JSON = "aclBit";
    public static final String ENC_BIT_JSON = "encBit";
    public static final String EC_BIT_JSON = "ecBit";
    public static final String SNAPSHOT_BIT_JSON = "snapshotEnabled";
    public static final String DIRECTORY_LISTING_JSON = "DirectoryListing";
    public static final String PARTIAL_LISTING_JSON = "partialListing";
    public static final String REMAINING_ENTRIES_JSON = "remainingEntries";
    public static final String STORAGE_POLICIES_JSON = "BlockStoragePolicies";
    public static final String STORAGE_POLICY_JSON = "BlockStoragePolicy";
    public static final int HTTP_TEMPORARY_REDIRECT = 307;
    public static final String SERVICE_NAME = "/webhdfs";
    public static final String SERVICE_VERSION = "/v1";
    public static final String SERVICE_PATH = "/webhdfs/v1";
    public static final byte[] EMPTY_BYTES = new byte[0];

    public static String permissionToString(FsPermission p) {
        return Integer.toString(p == null ? DEFAULT_PERMISSION.shortValue() : p.toShort(), 8);
    }

    @InterfaceAudience.Private
    public static enum Operation {
        OPEN("GET"),
        GETFILESTATUS("GET"),
        LISTSTATUS("GET"),
        GETHOMEDIRECTORY("GET"),
        GETCONTENTSUMMARY("GET"),
        GETQUOTAUSAGE("GET"),
        GETFILECHECKSUM("GET"),
        GETFILEBLOCKLOCATIONS("GET"),
        INSTRUMENTATION("GET"),
        GETACLSTATUS("GET"),
        GETTRASHROOT("GET"),
        APPEND("POST"),
        CONCAT("POST"),
        TRUNCATE("POST"),
        CREATE("PUT"),
        MKDIRS("PUT"),
        RENAME("PUT"),
        SETOWNER("PUT"),
        SETPERMISSION("PUT"),
        SETREPLICATION("PUT"),
        SETTIMES("PUT"),
        MODIFYACLENTRIES("PUT"),
        REMOVEACLENTRIES("PUT"),
        REMOVEDEFAULTACL("PUT"),
        REMOVEACL("PUT"),
        SETACL("PUT"),
        DELETE("DELETE"),
        SETXATTR("PUT"),
        GETXATTRS("GET"),
        REMOVEXATTR("PUT"),
        LISTXATTRS("GET"),
        LISTSTATUS_BATCH("GET"),
        GETALLSTORAGEPOLICY("GET"),
        GETSTORAGEPOLICY("GET"),
        SETSTORAGEPOLICY("PUT"),
        UNSETSTORAGEPOLICY("POST"),
        ALLOWSNAPSHOT("PUT"),
        DISALLOWSNAPSHOT("PUT"),
        CREATESNAPSHOT("PUT"),
        DELETESNAPSHOT("DELETE"),
        RENAMESNAPSHOT("PUT"),
        GETSNAPSHOTDIFF("GET"),
        GETSNAPSHOTTABLEDIRECTORYLIST("GET"),
        GETSERVERDEFAULTS("GET"),
        CHECKACCESS("GET"),
        SETECPOLICY("PUT"),
        GETECPOLICY("GET"),
        UNSETECPOLICY("POST"),
        SATISFYSTORAGEPOLICY("PUT");

        private String httpMethod;

        private Operation(String httpMethod) {
            this.httpMethod = httpMethod;
        }

        public String getMethod() {
            return this.httpMethod;
        }
    }

    public static enum FILETYPE {
        FILE,
        DIRECTORY,
        SYMLINK;


        public static FILETYPE getType(FileStatus fileStatus) {
            if (fileStatus.isFile()) {
                return FILE;
            }
            if (fileStatus.isDirectory()) {
                return DIRECTORY;
            }
            if (fileStatus.isSymlink()) {
                return SYMLINK;
            }
            throw new IllegalArgumentException("Could not determine filetype for: " + fileStatus.getPath());
        }
    }
}

