/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.impl;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.scm.container.common.helpers.StorageContainerException;
import org.apache.hadoop.ozone.container.common.helpers.ContainerUtils;
import org.apache.hadoop.ozone.container.common.impl.ContainerData;

public enum ContainerLayoutVersion {
    FILE_PER_CHUNK(1, "One file per chunk"){

        @Override
        public File getChunkFile(File chunkDir, BlockID blockID, String chunkName) {
            return new File(chunkDir, chunkName);
        }
    }
    ,
    FILE_PER_BLOCK(2, "One file per block"){

        @Override
        public File getChunkFile(File chunkDir, BlockID blockID, String chunkName) {
            return new File(chunkDir, blockID.getLocalID() + ".block");
        }
    };

    public static final ContainerLayoutVersion DEFAULT_LAYOUT;
    private static final List<ContainerLayoutVersion> CONTAINER_LAYOUT_VERSIONS;
    private final int version;
    private final String description;

    private ContainerLayoutVersion(int version, String description) {
        this.version = version;
        this.description = description;
    }

    public static ContainerLayoutVersion getContainerLayoutVersion(int containerVersion) {
        for (ContainerLayoutVersion containerLayoutVersion : CONTAINER_LAYOUT_VERSIONS) {
            if (containerLayoutVersion.getVersion() != containerVersion) continue;
            return containerLayoutVersion;
        }
        return null;
    }

    public static List<ContainerLayoutVersion> getAllVersions() {
        return CONTAINER_LAYOUT_VERSIONS;
    }

    public static ContainerLayoutVersion getConfiguredVersion(ConfigurationSource conf) {
        try {
            return (ContainerLayoutVersion)conf.getEnum("ozone.scm.container.layout", (Enum)DEFAULT_LAYOUT);
        }
        catch (IllegalArgumentException e) {
            return DEFAULT_LAYOUT;
        }
    }

    public int getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }

    public abstract File getChunkFile(File var1, BlockID var2, String var3);

    public File getChunkFile(ContainerData containerData, BlockID blockID, String chunkName) throws StorageContainerException {
        File chunkDir = ContainerUtils.getChunkDir(containerData);
        return this.getChunkFile(chunkDir, blockID, chunkName);
    }

    public String toString() {
        return "ContainerLayout:v" + this.version;
    }

    static {
        DEFAULT_LAYOUT = FILE_PER_BLOCK;
        CONTAINER_LAYOUT_VERSIONS = ImmutableList.copyOf((Object[])ContainerLayoutVersion.values());
    }
}

