/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.utils;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.ozone.container.common.impl.ContainerData;
import org.apache.hadoop.ozone.container.common.interfaces.ContainerInspector;
import org.apache.hadoop.ozone.container.keyvalue.KeyValueContainerMetadataInspector;
import org.apache.hadoop.ozone.container.metadata.DatanodeStore;

public final class ContainerInspectorUtil {
    private static final EnumMap<ContainerProtos.ContainerType, List<ContainerInspector>> INSPECTORS = new EnumMap(ContainerProtos.ContainerType.class);

    private ContainerInspectorUtil() {
    }

    public static void load() {
        for (List<ContainerInspector> inspectors : INSPECTORS.values()) {
            for (ContainerInspector inspector : inspectors) {
                inspector.load();
            }
        }
    }

    public static void unload() {
        for (List<ContainerInspector> inspectors : INSPECTORS.values()) {
            for (ContainerInspector inspector : inspectors) {
                inspector.unload();
            }
        }
    }

    public static boolean isReadOnly(ContainerProtos.ContainerType type) {
        boolean readOnly = true;
        for (ContainerInspector inspector : INSPECTORS.get(type)) {
            if (inspector.isReadOnly()) continue;
            readOnly = false;
            break;
        }
        return readOnly;
    }

    public static void process(ContainerData data, DatanodeStore store) {
        for (ContainerInspector inspector : INSPECTORS.get(data.getContainerType())) {
            inspector.process(data, store);
        }
    }

    static {
        for (ContainerProtos.ContainerType type : ContainerProtos.ContainerType.values()) {
            INSPECTORS.put(type, new ArrayList());
        }
        INSPECTORS.get(ContainerProtos.ContainerType.KeyValueContainer).add(new KeyValueContainerMetadataInspector());
    }
}

