/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.metadata;

import java.io.IOException;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.hdds.utils.db.LongCodec;
import org.apache.hadoop.hdds.utils.db.StringCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SchemaOneKeyCodec
implements Codec<String> {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaOneKeyCodec.class);
    private static final Codec<String> INSTANCE = new SchemaOneKeyCodec();

    public static Codec<String> get() {
        return INSTANCE;
    }

    private SchemaOneKeyCodec() {
    }

    public Class<String> getTypeClass() {
        return String.class;
    }

    public byte[] toPersistedFormat(String stringObject) throws IOException {
        try {
            long longObject = Long.parseLong(stringObject);
            return LongCodec.get().toPersistedFormat(Long.valueOf(longObject));
        }
        catch (NumberFormatException ex) {
            return StringCodec.get().toPersistedFormat(stringObject);
        }
    }

    public String fromPersistedFormat(byte[] rawData) {
        String prefixedBlockRegex = "^#[a-zA-Z]+#[0-9]+$";
        String metadataRegex = "^#[a-zA-Z]$";
        String stringData = StringCodec.get().fromPersistedFormat(rawData);
        if (stringData.matches("^#[a-zA-Z]+#[0-9]+$") || stringData.matches("^#[a-zA-Z]$")) {
            LOG.trace("Byte array {} matched the format for a string key. It will be parsed as the string {}", (Object)rawData, (Object)stringData);
            return stringData;
        }
        if (rawData.length == 8) {
            long longData = LongCodec.get().fromPersistedFormat(rawData);
            LOG.trace("Byte array {} did not match the format for a string key and has {} bytes. It will be parsed as the long {}", new Object[]{rawData, 8, longData});
            return Long.toString(longData);
        }
        LOG.trace("Byte array {} did not match the format for a string key and does not have {} bytes. It will be parsed as the string {}", new Object[]{rawData, 8, stringData});
        return stringData;
    }

    public String copyObject(String object) {
        return object;
    }
}

