/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.util.Charsets;

public class TextToPDF {
    private static final int FONTSCALE = 1000;
    private static final PDType1Font DEFAULT_FONT = PDType1Font.HELVETICA;
    private static final float DEFAULT_FONT_SIZE = 10.0f;
    private static final float DEFAULT_LINE_HEIGHT_FACTOR = 1.05f;
    private static final float DEFAULT_MARGIN = 40.0f;
    private float fontSize = 10.0f;
    private float lineSpacing = 1.05f;
    private PDRectangle mediaBox = PDRectangle.LETTER;
    private boolean landscape = false;
    private PDFont font = DEFAULT_FONT;
    private float leftMargin = 40.0f;
    private float rightMargin = 40.0f;
    private float topMargin = 40.0f;
    private float bottomMargin = 40.0f;
    private static final Map<String, PDType1Font> STANDARD_14 = new HashMap<String, PDType1Font>();

    public PDDocument createPDFFromText(Reader text) throws IOException {
        PDDocument doc = new PDDocument();
        this.createPDFFromText(doc, text);
        return doc;
    }

    public void createPDFFromText(PDDocument doc, Reader text) throws IOException {
        String nextLine;
        float fontHeight = this.font.getBoundingBox().getHeight() / 1000.0f;
        PDRectangle actualMediaBox = this.landscape ? new PDRectangle(this.mediaBox.getHeight(), this.mediaBox.getWidth()) : this.mediaBox;
        float lineHeight = fontHeight * this.fontSize * this.lineSpacing;
        BufferedReader data = new BufferedReader(text);
        PDPage page = new PDPage(actualMediaBox);
        PDPageContentStream contentStream = null;
        float y = -1.0f;
        float maxStringLength = page.getMediaBox().getWidth() - this.leftMargin - this.rightMargin;
        boolean textIsEmpty = true;
        StringBuilder nextLineToDraw = new StringBuilder();
        while ((nextLine = data.readLine()) != null) {
            textIsEmpty = false;
            String[] lineWords = nextLine.replaceAll("[\\n\\r]+$", "").split(" ", -1);
            int lineIndex = 0;
            while (lineIndex < lineWords.length) {
                nextLineToDraw.setLength(0);
                boolean addSpace = false;
                float lengthIfUsingNextWord = 0.0f;
                boolean ff = false;
                do {
                    String word1;
                    String word2 = "";
                    String word = lineWords[lineIndex];
                    int indexFF = word.indexOf(12);
                    if (indexFF == -1) {
                        word1 = word;
                    } else {
                        ff = true;
                        word1 = word.substring(0, indexFF);
                        if (indexFF < word.length()) {
                            word2 = word.substring(indexFF + 1);
                        }
                    }
                    if (word1.length() > 0 || !ff) {
                        if (addSpace) {
                            nextLineToDraw.append(' ');
                        } else {
                            addSpace = true;
                        }
                        nextLineToDraw.append(word1);
                    }
                    if (!ff || word2.length() == 0) {
                        ++lineIndex;
                    } else {
                        lineWords[lineIndex] = word2;
                    }
                    if (ff) break;
                    if (lineIndex >= lineWords.length) continue;
                    String nextWord = lineWords[lineIndex];
                    indexFF = nextWord.indexOf(12);
                    if (indexFF != -1) {
                        nextWord = nextWord.substring(0, indexFF);
                    }
                    String lineWithNextWord = nextLineToDraw + " " + nextWord;
                    lengthIfUsingNextWord = this.font.getStringWidth(lineWithNextWord) / 1000.0f * this.fontSize;
                } while (lineIndex < lineWords.length && lengthIfUsingNextWord < maxStringLength);
                if (y - lineHeight < this.bottomMargin) {
                    page = new PDPage(actualMediaBox);
                    doc.addPage(page);
                    if (contentStream != null) {
                        contentStream.endText();
                        contentStream.close();
                    }
                    contentStream = new PDPageContentStream(doc, page);
                    contentStream.setFont(this.font, this.fontSize);
                    contentStream.beginText();
                    y = page.getMediaBox().getHeight() - this.topMargin;
                    contentStream.newLineAtOffset(this.leftMargin, y += lineHeight - fontHeight * this.fontSize);
                }
                if (contentStream == null) {
                    throw new IOException("Error:Expected non-null content stream.");
                }
                contentStream.newLineAtOffset(0.0f, -lineHeight);
                y -= lineHeight;
                contentStream.showText(nextLineToDraw.toString());
                if (!ff) continue;
                page = new PDPage(actualMediaBox);
                doc.addPage(page);
                contentStream.endText();
                contentStream.close();
                contentStream = new PDPageContentStream(doc, page);
                contentStream.setFont(this.font, this.fontSize);
                contentStream.beginText();
                y = page.getMediaBox().getHeight() - this.topMargin;
                contentStream.newLineAtOffset(this.leftMargin, y += lineHeight - fontHeight * this.fontSize);
            }
        }
        if (textIsEmpty) {
            doc.addPage(page);
        }
        if (contentStream != null) {
            contentStream.endText();
            contentStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        Charset charset = Charset.defaultCharset();
        System.setProperty("apple.awt.UIElement", "true");
        TextToPDF app = new TextToPDF();
        PDDocument doc = new PDDocument();
        try {
            if (args.length < 2) {
                app.usage();
            } else {
                long skipped;
                FileInputStream is;
                for (int i = 0; i < args.length - 2; ++i) {
                    if (args[i].equals("-standardFont")) {
                        app.setFont((PDFont)TextToPDF.getStandardFont(args[++i]));
                        continue;
                    }
                    if (args[i].equals("-ttf")) {
                        PDType0Font font = PDType0Font.load((PDDocument)doc, (File)new File(args[++i]));
                        app.setFont((PDFont)font);
                        continue;
                    }
                    if (args[i].equals("-charset")) {
                        charset = Charset.forName(args[++i]);
                        continue;
                    }
                    if (args[i].equals("-fontSize")) {
                        app.setFontSize(Float.parseFloat(args[++i]));
                        continue;
                    }
                    if (args[i].equals("-margins")) {
                        app.setLeftMargin(Float.parseFloat(args[++i]));
                        app.setRightMargin(Float.parseFloat(args[++i]));
                        app.setTopMargin(Float.parseFloat(args[++i]));
                        app.setBottomMargin(Float.parseFloat(args[++i]));
                        continue;
                    }
                    if (args[i].equals("-lineSpacing")) {
                        app.setLineSpacing(Float.parseFloat(args[++i]));
                        continue;
                    }
                    if (args[i].equals("-pageSize")) {
                        PDRectangle rectangle;
                        if ((rectangle = TextToPDF.createRectangle(args[++i])) == null) {
                            throw new IOException("Unknown argument: " + args[i]);
                        }
                        app.setMediaBox(rectangle);
                        continue;
                    }
                    if (args[i].equals("-landscape")) {
                        app.setLandscape(true);
                        continue;
                    }
                    throw new IOException("Unknown argument: " + args[i]);
                }
                boolean hasUtf8BOM = false;
                if (charset.equals(Charsets.UTF_8)) {
                    is = new FileInputStream(args[args.length - 1]);
                    if (((InputStream)is).read() == 239 && ((InputStream)is).read() == 187 && ((InputStream)is).read() == 191) {
                        hasUtf8BOM = true;
                    }
                    ((InputStream)is).close();
                }
                is = new FileInputStream(args[args.length - 1]);
                if (hasUtf8BOM && (skipped = ((InputStream)is).skip(3L)) != 3L) {
                    throw new IOException("Could not skip 3 bytes, size changed?!");
                }
                InputStreamReader reader = new InputStreamReader((InputStream)is, charset);
                app.createPDFFromText(doc, reader);
                ((Reader)reader).close();
                ((InputStream)is).close();
                doc.save(args[args.length - 2]);
            }
        }
        finally {
            doc.close();
        }
    }

    private static PDRectangle createRectangle(String paperSize) {
        if ("letter".equalsIgnoreCase(paperSize)) {
            return PDRectangle.LETTER;
        }
        if ("legal".equalsIgnoreCase(paperSize)) {
            return PDRectangle.LEGAL;
        }
        if ("A0".equalsIgnoreCase(paperSize)) {
            return PDRectangle.A0;
        }
        if ("A1".equalsIgnoreCase(paperSize)) {
            return PDRectangle.A1;
        }
        if ("A2".equalsIgnoreCase(paperSize)) {
            return PDRectangle.A2;
        }
        if ("A3".equalsIgnoreCase(paperSize)) {
            return PDRectangle.A3;
        }
        if ("A4".equalsIgnoreCase(paperSize)) {
            return PDRectangle.A4;
        }
        if ("A5".equalsIgnoreCase(paperSize)) {
            return PDRectangle.A5;
        }
        if ("A6".equalsIgnoreCase(paperSize)) {
            return PDRectangle.A6;
        }
        return null;
    }

    private void usage() {
        String[] std14 = TextToPDF.getStandard14Names();
        StringBuilder message = new StringBuilder();
        message.append("Usage: jar -jar pdfbox-app-x.y.z.jar TextToPDF [options] <outputfile> <textfile>\n");
        message.append("\nOptions:\n");
        message.append("  -standardFont <name> : ").append(DEFAULT_FONT.getBaseFont()).append(" (default)\n");
        for (String std14String : std14) {
            message.append("                         ").append(std14String).append("\n");
        }
        message.append("  -ttf <ttf file>      : The TTF font to use.\n");
        message.append("  -charset <charset>   : default: ").append(Charset.defaultCharset()).append("\n");
        message.append("  -fontSize <fontSize> : default: ").append(10.0f).append("\n");
        message.append("  -margins <left> <right> <top> <bottom> : default: ").append(40.0f).append(" ").append(40.0f).append(" ").append(40.0f).append(" ").append(40.0f).append("\n");
        message.append("  -lineSpacing <factor>: default: ").append(1.05f).append("\n");
        message.append("  -pageSize <pageSize> : Letter (default)\n");
        message.append("                         Legal\n");
        message.append("                         A0\n");
        message.append("                         A1\n");
        message.append("                         A2\n");
        message.append("                         A3\n");
        message.append("                         A4\n");
        message.append("                         A5\n");
        message.append("                         A6\n");
        message.append("  -landscape           : sets orientation to landscape");
        System.err.println(message.toString());
        System.exit(1);
    }

    private static PDType1Font getStandardFont(String name) {
        return STANDARD_14.get(name);
    }

    private static String[] getStandard14Names() {
        return STANDARD_14.keySet().toArray(new String[14]);
    }

    public PDFont getFont() {
        return this.font;
    }

    public void setFont(PDFont aFont) {
        this.font = aFont;
    }

    public int getFontSize() {
        return (int)this.fontSize;
    }

    @Deprecated
    public void setFontSize(int aFontSize) {
        this.fontSize = aFontSize;
    }

    public void setFontSize(float aFontSize) {
        this.fontSize = aFontSize;
    }

    public float getLineSpacing() {
        return this.lineSpacing;
    }

    public void setLineSpacing(float lineSpacing) {
        if (lineSpacing <= 0.0f) {
            throw new IllegalArgumentException("line spacing must be positive: " + lineSpacing);
        }
        this.lineSpacing = lineSpacing;
    }

    public float getLeftMargin() {
        return this.leftMargin;
    }

    public void setLeftMargin(float leftMargin) {
        this.leftMargin = leftMargin;
    }

    public float getRightMargin() {
        return this.rightMargin;
    }

    public void setRightMargin(float rightMargin) {
        this.rightMargin = rightMargin;
    }

    public float getTopMargin() {
        return this.topMargin;
    }

    public void setTopMargin(float topMargin) {
        this.topMargin = topMargin;
    }

    public float getBottomMargin() {
        return this.bottomMargin;
    }

    public void setBottomMargin(float bottomMargin) {
        this.bottomMargin = bottomMargin;
    }

    public PDRectangle getMediaBox() {
        return this.mediaBox;
    }

    public void setMediaBox(PDRectangle mediaBox) {
        this.mediaBox = mediaBox;
    }

    public boolean isLandscape() {
        return this.landscape;
    }

    public void setLandscape(boolean landscape) {
        this.landscape = landscape;
    }

    static {
        STANDARD_14.put(PDType1Font.TIMES_ROMAN.getBaseFont(), PDType1Font.TIMES_ROMAN);
        STANDARD_14.put(PDType1Font.TIMES_BOLD.getBaseFont(), PDType1Font.TIMES_BOLD);
        STANDARD_14.put(PDType1Font.TIMES_ITALIC.getBaseFont(), PDType1Font.TIMES_ITALIC);
        STANDARD_14.put(PDType1Font.TIMES_BOLD_ITALIC.getBaseFont(), PDType1Font.TIMES_BOLD_ITALIC);
        STANDARD_14.put(PDType1Font.HELVETICA.getBaseFont(), PDType1Font.HELVETICA);
        STANDARD_14.put(PDType1Font.HELVETICA_BOLD.getBaseFont(), PDType1Font.HELVETICA_BOLD);
        STANDARD_14.put(PDType1Font.HELVETICA_OBLIQUE.getBaseFont(), PDType1Font.HELVETICA_OBLIQUE);
        STANDARD_14.put(PDType1Font.HELVETICA_BOLD_OBLIQUE.getBaseFont(), PDType1Font.HELVETICA_BOLD_OBLIQUE);
        STANDARD_14.put(PDType1Font.COURIER.getBaseFont(), PDType1Font.COURIER);
        STANDARD_14.put(PDType1Font.COURIER_BOLD.getBaseFont(), PDType1Font.COURIER_BOLD);
        STANDARD_14.put(PDType1Font.COURIER_OBLIQUE.getBaseFont(), PDType1Font.COURIER_OBLIQUE);
        STANDARD_14.put(PDType1Font.COURIER_BOLD_OBLIQUE.getBaseFont(), PDType1Font.COURIER_BOLD_OBLIQUE);
        STANDARD_14.put(PDType1Font.SYMBOL.getBaseFont(), PDType1Font.SYMBOL);
        STANDARD_14.put(PDType1Font.ZAPF_DINGBATS.getBaseFont(), PDType1Font.ZAPF_DINGBATS);
    }
}

