/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataProfileLocation is the corresponding interface of BACnetConstructedDataProfileLocation
type BACnetConstructedDataProfileLocation interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetProfileLocation returns ProfileLocation (property field)
	GetProfileLocation() BACnetApplicationTagCharacterString
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetApplicationTagCharacterString
	// IsBACnetConstructedDataProfileLocation is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataProfileLocation()
	// CreateBuilder creates a BACnetConstructedDataProfileLocationBuilder
	CreateBACnetConstructedDataProfileLocationBuilder() BACnetConstructedDataProfileLocationBuilder
}

// _BACnetConstructedDataProfileLocation is the data-structure of this message
type _BACnetConstructedDataProfileLocation struct {
	BACnetConstructedDataContract
	ProfileLocation BACnetApplicationTagCharacterString
}

var _ BACnetConstructedDataProfileLocation = (*_BACnetConstructedDataProfileLocation)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataProfileLocation)(nil)

// NewBACnetConstructedDataProfileLocation factory function for _BACnetConstructedDataProfileLocation
func NewBACnetConstructedDataProfileLocation(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, profileLocation BACnetApplicationTagCharacterString, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataProfileLocation {
	if profileLocation == nil {
		panic("profileLocation of type BACnetApplicationTagCharacterString for BACnetConstructedDataProfileLocation must not be nil")
	}
	_result := &_BACnetConstructedDataProfileLocation{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		ProfileLocation:               profileLocation,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataProfileLocationBuilder is a builder for BACnetConstructedDataProfileLocation
type BACnetConstructedDataProfileLocationBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(profileLocation BACnetApplicationTagCharacterString) BACnetConstructedDataProfileLocationBuilder
	// WithProfileLocation adds ProfileLocation (property field)
	WithProfileLocation(BACnetApplicationTagCharacterString) BACnetConstructedDataProfileLocationBuilder
	// WithProfileLocationBuilder adds ProfileLocation (property field) which is build by the builder
	WithProfileLocationBuilder(func(BACnetApplicationTagCharacterStringBuilder) BACnetApplicationTagCharacterStringBuilder) BACnetConstructedDataProfileLocationBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataProfileLocation or returns an error if something is wrong
	Build() (BACnetConstructedDataProfileLocation, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataProfileLocation
}

// NewBACnetConstructedDataProfileLocationBuilder() creates a BACnetConstructedDataProfileLocationBuilder
func NewBACnetConstructedDataProfileLocationBuilder() BACnetConstructedDataProfileLocationBuilder {
	return &_BACnetConstructedDataProfileLocationBuilder{_BACnetConstructedDataProfileLocation: new(_BACnetConstructedDataProfileLocation)}
}

type _BACnetConstructedDataProfileLocationBuilder struct {
	*_BACnetConstructedDataProfileLocation

	parentBuilder *_BACnetConstructedDataBuilder

	collectedErr []error
}

var _ (BACnetConstructedDataProfileLocationBuilder) = (*_BACnetConstructedDataProfileLocationBuilder)(nil)

func (b *_BACnetConstructedDataProfileLocationBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataProfileLocation
}

func (b *_BACnetConstructedDataProfileLocationBuilder) WithMandatoryFields(profileLocation BACnetApplicationTagCharacterString) BACnetConstructedDataProfileLocationBuilder {
	return b.WithProfileLocation(profileLocation)
}

func (b *_BACnetConstructedDataProfileLocationBuilder) WithProfileLocation(profileLocation BACnetApplicationTagCharacterString) BACnetConstructedDataProfileLocationBuilder {
	b.ProfileLocation = profileLocation
	return b
}

func (b *_BACnetConstructedDataProfileLocationBuilder) WithProfileLocationBuilder(builderSupplier func(BACnetApplicationTagCharacterStringBuilder) BACnetApplicationTagCharacterStringBuilder) BACnetConstructedDataProfileLocationBuilder {
	builder := builderSupplier(b.ProfileLocation.CreateBACnetApplicationTagCharacterStringBuilder())
	var err error
	b.ProfileLocation, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetApplicationTagCharacterStringBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataProfileLocationBuilder) Build() (BACnetConstructedDataProfileLocation, error) {
	if b.ProfileLocation == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'profileLocation' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetConstructedDataProfileLocation.deepCopy(), nil
}

func (b *_BACnetConstructedDataProfileLocationBuilder) MustBuild() BACnetConstructedDataProfileLocation {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataProfileLocationBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataProfileLocationBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataProfileLocationBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataProfileLocationBuilder().(*_BACnetConstructedDataProfileLocationBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetConstructedDataProfileLocationBuilder creates a BACnetConstructedDataProfileLocationBuilder
func (b *_BACnetConstructedDataProfileLocation) CreateBACnetConstructedDataProfileLocationBuilder() BACnetConstructedDataProfileLocationBuilder {
	if b == nil {
		return NewBACnetConstructedDataProfileLocationBuilder()
	}
	return &_BACnetConstructedDataProfileLocationBuilder{_BACnetConstructedDataProfileLocation: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataProfileLocation) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataProfileLocation) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_PROFILE_LOCATION
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataProfileLocation) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataProfileLocation) GetProfileLocation() BACnetApplicationTagCharacterString {
	return m.ProfileLocation
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataProfileLocation) GetActualValue() BACnetApplicationTagCharacterString {
	ctx := context.Background()
	_ = ctx
	return CastBACnetApplicationTagCharacterString(m.GetProfileLocation())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataProfileLocation(structType any) BACnetConstructedDataProfileLocation {
	if casted, ok := structType.(BACnetConstructedDataProfileLocation); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataProfileLocation); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataProfileLocation) GetTypeName() string {
	return "BACnetConstructedDataProfileLocation"
}

func (m *_BACnetConstructedDataProfileLocation) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (profileLocation)
	lengthInBits += m.ProfileLocation.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataProfileLocation) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataProfileLocation) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataProfileLocation BACnetConstructedDataProfileLocation, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataProfileLocation"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataProfileLocation")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	profileLocation, err := ReadSimpleField[BACnetApplicationTagCharacterString](ctx, "profileLocation", ReadComplex[BACnetApplicationTagCharacterString](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagCharacterString](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'profileLocation' field"))
	}
	m.ProfileLocation = profileLocation

	actualValue, err := ReadVirtualField[BACnetApplicationTagCharacterString](ctx, "actualValue", (*BACnetApplicationTagCharacterString)(nil), profileLocation)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataProfileLocation"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataProfileLocation")
	}

	return m, nil
}

func (m *_BACnetConstructedDataProfileLocation) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataProfileLocation) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataProfileLocation"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataProfileLocation")
		}

		if err := WriteSimpleField[BACnetApplicationTagCharacterString](ctx, "profileLocation", m.GetProfileLocation(), WriteComplex[BACnetApplicationTagCharacterString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'profileLocation' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataProfileLocation"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataProfileLocation")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataProfileLocation) IsBACnetConstructedDataProfileLocation() {}

func (m *_BACnetConstructedDataProfileLocation) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataProfileLocation) deepCopy() *_BACnetConstructedDataProfileLocation {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataProfileLocationCopy := &_BACnetConstructedDataProfileLocation{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagCharacterString](m.ProfileLocation),
	}
	_BACnetConstructedDataProfileLocationCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataProfileLocationCopy
}

func (m *_BACnetConstructedDataProfileLocation) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
