/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetOptionalREALValue is the corresponding interface of BACnetOptionalREALValue
type BACnetOptionalREALValue interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetOptionalREAL
	// GetRealValue returns RealValue (property field)
	GetRealValue() BACnetApplicationTagReal
	// IsBACnetOptionalREALValue is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetOptionalREALValue()
	// CreateBuilder creates a BACnetOptionalREALValueBuilder
	CreateBACnetOptionalREALValueBuilder() BACnetOptionalREALValueBuilder
}

// _BACnetOptionalREALValue is the data-structure of this message
type _BACnetOptionalREALValue struct {
	BACnetOptionalREALContract
	RealValue BACnetApplicationTagReal
}

var _ BACnetOptionalREALValue = (*_BACnetOptionalREALValue)(nil)
var _ BACnetOptionalREALRequirements = (*_BACnetOptionalREALValue)(nil)

// NewBACnetOptionalREALValue factory function for _BACnetOptionalREALValue
func NewBACnetOptionalREALValue(peekedTagHeader BACnetTagHeader, realValue BACnetApplicationTagReal) *_BACnetOptionalREALValue {
	if realValue == nil {
		panic("realValue of type BACnetApplicationTagReal for BACnetOptionalREALValue must not be nil")
	}
	_result := &_BACnetOptionalREALValue{
		BACnetOptionalREALContract: NewBACnetOptionalREAL(peekedTagHeader),
		RealValue:                  realValue,
	}
	_result.BACnetOptionalREALContract.(*_BACnetOptionalREAL)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetOptionalREALValueBuilder is a builder for BACnetOptionalREALValue
type BACnetOptionalREALValueBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(realValue BACnetApplicationTagReal) BACnetOptionalREALValueBuilder
	// WithRealValue adds RealValue (property field)
	WithRealValue(BACnetApplicationTagReal) BACnetOptionalREALValueBuilder
	// WithRealValueBuilder adds RealValue (property field) which is build by the builder
	WithRealValueBuilder(func(BACnetApplicationTagRealBuilder) BACnetApplicationTagRealBuilder) BACnetOptionalREALValueBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetOptionalREALBuilder
	// Build builds the BACnetOptionalREALValue or returns an error if something is wrong
	Build() (BACnetOptionalREALValue, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetOptionalREALValue
}

// NewBACnetOptionalREALValueBuilder() creates a BACnetOptionalREALValueBuilder
func NewBACnetOptionalREALValueBuilder() BACnetOptionalREALValueBuilder {
	return &_BACnetOptionalREALValueBuilder{_BACnetOptionalREALValue: new(_BACnetOptionalREALValue)}
}

type _BACnetOptionalREALValueBuilder struct {
	*_BACnetOptionalREALValue

	parentBuilder *_BACnetOptionalREALBuilder

	collectedErr []error
}

var _ (BACnetOptionalREALValueBuilder) = (*_BACnetOptionalREALValueBuilder)(nil)

func (b *_BACnetOptionalREALValueBuilder) setParent(contract BACnetOptionalREALContract) {
	b.BACnetOptionalREALContract = contract
	contract.(*_BACnetOptionalREAL)._SubType = b._BACnetOptionalREALValue
}

func (b *_BACnetOptionalREALValueBuilder) WithMandatoryFields(realValue BACnetApplicationTagReal) BACnetOptionalREALValueBuilder {
	return b.WithRealValue(realValue)
}

func (b *_BACnetOptionalREALValueBuilder) WithRealValue(realValue BACnetApplicationTagReal) BACnetOptionalREALValueBuilder {
	b.RealValue = realValue
	return b
}

func (b *_BACnetOptionalREALValueBuilder) WithRealValueBuilder(builderSupplier func(BACnetApplicationTagRealBuilder) BACnetApplicationTagRealBuilder) BACnetOptionalREALValueBuilder {
	builder := builderSupplier(b.RealValue.CreateBACnetApplicationTagRealBuilder())
	var err error
	b.RealValue, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetApplicationTagRealBuilder failed"))
	}
	return b
}

func (b *_BACnetOptionalREALValueBuilder) Build() (BACnetOptionalREALValue, error) {
	if b.RealValue == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'realValue' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetOptionalREALValue.deepCopy(), nil
}

func (b *_BACnetOptionalREALValueBuilder) MustBuild() BACnetOptionalREALValue {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetOptionalREALValueBuilder) Done() BACnetOptionalREALBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetOptionalREALBuilder().(*_BACnetOptionalREALBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetOptionalREALValueBuilder) buildForBACnetOptionalREAL() (BACnetOptionalREAL, error) {
	return b.Build()
}

func (b *_BACnetOptionalREALValueBuilder) DeepCopy() any {
	_copy := b.CreateBACnetOptionalREALValueBuilder().(*_BACnetOptionalREALValueBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetOptionalREALValueBuilder creates a BACnetOptionalREALValueBuilder
func (b *_BACnetOptionalREALValue) CreateBACnetOptionalREALValueBuilder() BACnetOptionalREALValueBuilder {
	if b == nil {
		return NewBACnetOptionalREALValueBuilder()
	}
	return &_BACnetOptionalREALValueBuilder{_BACnetOptionalREALValue: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetOptionalREALValue) GetParent() BACnetOptionalREALContract {
	return m.BACnetOptionalREALContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetOptionalREALValue) GetRealValue() BACnetApplicationTagReal {
	return m.RealValue
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetOptionalREALValue(structType any) BACnetOptionalREALValue {
	if casted, ok := structType.(BACnetOptionalREALValue); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetOptionalREALValue); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetOptionalREALValue) GetTypeName() string {
	return "BACnetOptionalREALValue"
}

func (m *_BACnetOptionalREALValue) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetOptionalREALContract.(*_BACnetOptionalREAL).getLengthInBits(ctx))

	// Simple field (realValue)
	lengthInBits += m.RealValue.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetOptionalREALValue) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetOptionalREALValue) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetOptionalREAL) (__bACnetOptionalREALValue BACnetOptionalREALValue, err error) {
	m.BACnetOptionalREALContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetOptionalREALValue"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetOptionalREALValue")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	realValue, err := ReadSimpleField[BACnetApplicationTagReal](ctx, "realValue", ReadComplex[BACnetApplicationTagReal](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagReal](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'realValue' field"))
	}
	m.RealValue = realValue

	if closeErr := readBuffer.CloseContext("BACnetOptionalREALValue"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetOptionalREALValue")
	}

	return m, nil
}

func (m *_BACnetOptionalREALValue) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetOptionalREALValue) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetOptionalREALValue"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetOptionalREALValue")
		}

		if err := WriteSimpleField[BACnetApplicationTagReal](ctx, "realValue", m.GetRealValue(), WriteComplex[BACnetApplicationTagReal](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'realValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetOptionalREALValue"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetOptionalREALValue")
		}
		return nil
	}
	return m.BACnetOptionalREALContract.(*_BACnetOptionalREAL).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetOptionalREALValue) IsBACnetOptionalREALValue() {}

func (m *_BACnetOptionalREALValue) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetOptionalREALValue) deepCopy() *_BACnetOptionalREALValue {
	if m == nil {
		return nil
	}
	_BACnetOptionalREALValueCopy := &_BACnetOptionalREALValue{
		m.BACnetOptionalREALContract.(*_BACnetOptionalREAL).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagReal](m.RealValue),
	}
	_BACnetOptionalREALValueCopy.BACnetOptionalREALContract.(*_BACnetOptionalREAL)._SubType = m
	return _BACnetOptionalREALValueCopy
}

func (m *_BACnetOptionalREALValue) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
