/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// VTCloseErrorListOfVTSessionIdentifiers is the corresponding interface of VTCloseErrorListOfVTSessionIdentifiers
type VTCloseErrorListOfVTSessionIdentifiers interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetOpeningTag returns OpeningTag (property field)
	GetOpeningTag() BACnetOpeningTag
	// GetListOfVtSessionIdentifiers returns ListOfVtSessionIdentifiers (property field)
	GetListOfVtSessionIdentifiers() []BACnetApplicationTagUnsignedInteger
	// GetClosingTag returns ClosingTag (property field)
	GetClosingTag() BACnetClosingTag
	// IsVTCloseErrorListOfVTSessionIdentifiers is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsVTCloseErrorListOfVTSessionIdentifiers()
	// CreateBuilder creates a VTCloseErrorListOfVTSessionIdentifiersBuilder
	CreateVTCloseErrorListOfVTSessionIdentifiersBuilder() VTCloseErrorListOfVTSessionIdentifiersBuilder
}

// _VTCloseErrorListOfVTSessionIdentifiers is the data-structure of this message
type _VTCloseErrorListOfVTSessionIdentifiers struct {
	OpeningTag                 BACnetOpeningTag
	ListOfVtSessionIdentifiers []BACnetApplicationTagUnsignedInteger
	ClosingTag                 BACnetClosingTag

	// Arguments.
	TagNumber uint8
}

var _ VTCloseErrorListOfVTSessionIdentifiers = (*_VTCloseErrorListOfVTSessionIdentifiers)(nil)

// NewVTCloseErrorListOfVTSessionIdentifiers factory function for _VTCloseErrorListOfVTSessionIdentifiers
func NewVTCloseErrorListOfVTSessionIdentifiers(openingTag BACnetOpeningTag, listOfVtSessionIdentifiers []BACnetApplicationTagUnsignedInteger, closingTag BACnetClosingTag, tagNumber uint8) *_VTCloseErrorListOfVTSessionIdentifiers {
	if openingTag == nil {
		panic("openingTag of type BACnetOpeningTag for VTCloseErrorListOfVTSessionIdentifiers must not be nil")
	}
	if closingTag == nil {
		panic("closingTag of type BACnetClosingTag for VTCloseErrorListOfVTSessionIdentifiers must not be nil")
	}
	return &_VTCloseErrorListOfVTSessionIdentifiers{OpeningTag: openingTag, ListOfVtSessionIdentifiers: listOfVtSessionIdentifiers, ClosingTag: closingTag, TagNumber: tagNumber}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// VTCloseErrorListOfVTSessionIdentifiersBuilder is a builder for VTCloseErrorListOfVTSessionIdentifiers
type VTCloseErrorListOfVTSessionIdentifiersBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(openingTag BACnetOpeningTag, listOfVtSessionIdentifiers []BACnetApplicationTagUnsignedInteger, closingTag BACnetClosingTag) VTCloseErrorListOfVTSessionIdentifiersBuilder
	// WithOpeningTag adds OpeningTag (property field)
	WithOpeningTag(BACnetOpeningTag) VTCloseErrorListOfVTSessionIdentifiersBuilder
	// WithOpeningTagBuilder adds OpeningTag (property field) which is build by the builder
	WithOpeningTagBuilder(func(BACnetOpeningTagBuilder) BACnetOpeningTagBuilder) VTCloseErrorListOfVTSessionIdentifiersBuilder
	// WithListOfVtSessionIdentifiers adds ListOfVtSessionIdentifiers (property field)
	WithListOfVtSessionIdentifiers(...BACnetApplicationTagUnsignedInteger) VTCloseErrorListOfVTSessionIdentifiersBuilder
	// WithClosingTag adds ClosingTag (property field)
	WithClosingTag(BACnetClosingTag) VTCloseErrorListOfVTSessionIdentifiersBuilder
	// WithClosingTagBuilder adds ClosingTag (property field) which is build by the builder
	WithClosingTagBuilder(func(BACnetClosingTagBuilder) BACnetClosingTagBuilder) VTCloseErrorListOfVTSessionIdentifiersBuilder
	// WithArgTagNumber sets a parser argument
	WithArgTagNumber(uint8) VTCloseErrorListOfVTSessionIdentifiersBuilder
	// Build builds the VTCloseErrorListOfVTSessionIdentifiers or returns an error if something is wrong
	Build() (VTCloseErrorListOfVTSessionIdentifiers, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() VTCloseErrorListOfVTSessionIdentifiers
}

// NewVTCloseErrorListOfVTSessionIdentifiersBuilder() creates a VTCloseErrorListOfVTSessionIdentifiersBuilder
func NewVTCloseErrorListOfVTSessionIdentifiersBuilder() VTCloseErrorListOfVTSessionIdentifiersBuilder {
	return &_VTCloseErrorListOfVTSessionIdentifiersBuilder{_VTCloseErrorListOfVTSessionIdentifiers: new(_VTCloseErrorListOfVTSessionIdentifiers)}
}

type _VTCloseErrorListOfVTSessionIdentifiersBuilder struct {
	*_VTCloseErrorListOfVTSessionIdentifiers

	collectedErr []error
}

var _ (VTCloseErrorListOfVTSessionIdentifiersBuilder) = (*_VTCloseErrorListOfVTSessionIdentifiersBuilder)(nil)

func (b *_VTCloseErrorListOfVTSessionIdentifiersBuilder) WithMandatoryFields(openingTag BACnetOpeningTag, listOfVtSessionIdentifiers []BACnetApplicationTagUnsignedInteger, closingTag BACnetClosingTag) VTCloseErrorListOfVTSessionIdentifiersBuilder {
	return b.WithOpeningTag(openingTag).WithListOfVtSessionIdentifiers(listOfVtSessionIdentifiers...).WithClosingTag(closingTag)
}

func (b *_VTCloseErrorListOfVTSessionIdentifiersBuilder) WithOpeningTag(openingTag BACnetOpeningTag) VTCloseErrorListOfVTSessionIdentifiersBuilder {
	b.OpeningTag = openingTag
	return b
}

func (b *_VTCloseErrorListOfVTSessionIdentifiersBuilder) WithOpeningTagBuilder(builderSupplier func(BACnetOpeningTagBuilder) BACnetOpeningTagBuilder) VTCloseErrorListOfVTSessionIdentifiersBuilder {
	builder := builderSupplier(b.OpeningTag.CreateBACnetOpeningTagBuilder())
	var err error
	b.OpeningTag, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetOpeningTagBuilder failed"))
	}
	return b
}

func (b *_VTCloseErrorListOfVTSessionIdentifiersBuilder) WithListOfVtSessionIdentifiers(listOfVtSessionIdentifiers ...BACnetApplicationTagUnsignedInteger) VTCloseErrorListOfVTSessionIdentifiersBuilder {
	b.ListOfVtSessionIdentifiers = listOfVtSessionIdentifiers
	return b
}

func (b *_VTCloseErrorListOfVTSessionIdentifiersBuilder) WithClosingTag(closingTag BACnetClosingTag) VTCloseErrorListOfVTSessionIdentifiersBuilder {
	b.ClosingTag = closingTag
	return b
}

func (b *_VTCloseErrorListOfVTSessionIdentifiersBuilder) WithClosingTagBuilder(builderSupplier func(BACnetClosingTagBuilder) BACnetClosingTagBuilder) VTCloseErrorListOfVTSessionIdentifiersBuilder {
	builder := builderSupplier(b.ClosingTag.CreateBACnetClosingTagBuilder())
	var err error
	b.ClosingTag, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetClosingTagBuilder failed"))
	}
	return b
}

func (b *_VTCloseErrorListOfVTSessionIdentifiersBuilder) WithArgTagNumber(tagNumber uint8) VTCloseErrorListOfVTSessionIdentifiersBuilder {
	b.TagNumber = tagNumber
	return b
}

func (b *_VTCloseErrorListOfVTSessionIdentifiersBuilder) Build() (VTCloseErrorListOfVTSessionIdentifiers, error) {
	if b.OpeningTag == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'openingTag' not set"))
	}
	if b.ClosingTag == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'closingTag' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._VTCloseErrorListOfVTSessionIdentifiers.deepCopy(), nil
}

func (b *_VTCloseErrorListOfVTSessionIdentifiersBuilder) MustBuild() VTCloseErrorListOfVTSessionIdentifiers {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_VTCloseErrorListOfVTSessionIdentifiersBuilder) DeepCopy() any {
	_copy := b.CreateVTCloseErrorListOfVTSessionIdentifiersBuilder().(*_VTCloseErrorListOfVTSessionIdentifiersBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateVTCloseErrorListOfVTSessionIdentifiersBuilder creates a VTCloseErrorListOfVTSessionIdentifiersBuilder
func (b *_VTCloseErrorListOfVTSessionIdentifiers) CreateVTCloseErrorListOfVTSessionIdentifiersBuilder() VTCloseErrorListOfVTSessionIdentifiersBuilder {
	if b == nil {
		return NewVTCloseErrorListOfVTSessionIdentifiersBuilder()
	}
	return &_VTCloseErrorListOfVTSessionIdentifiersBuilder{_VTCloseErrorListOfVTSessionIdentifiers: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_VTCloseErrorListOfVTSessionIdentifiers) GetOpeningTag() BACnetOpeningTag {
	return m.OpeningTag
}

func (m *_VTCloseErrorListOfVTSessionIdentifiers) GetListOfVtSessionIdentifiers() []BACnetApplicationTagUnsignedInteger {
	return m.ListOfVtSessionIdentifiers
}

func (m *_VTCloseErrorListOfVTSessionIdentifiers) GetClosingTag() BACnetClosingTag {
	return m.ClosingTag
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastVTCloseErrorListOfVTSessionIdentifiers(structType any) VTCloseErrorListOfVTSessionIdentifiers {
	if casted, ok := structType.(VTCloseErrorListOfVTSessionIdentifiers); ok {
		return casted
	}
	if casted, ok := structType.(*VTCloseErrorListOfVTSessionIdentifiers); ok {
		return *casted
	}
	return nil
}

func (m *_VTCloseErrorListOfVTSessionIdentifiers) GetTypeName() string {
	return "VTCloseErrorListOfVTSessionIdentifiers"
}

func (m *_VTCloseErrorListOfVTSessionIdentifiers) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (openingTag)
	lengthInBits += m.OpeningTag.GetLengthInBits(ctx)

	// Array field
	if len(m.ListOfVtSessionIdentifiers) > 0 {
		for _, element := range m.ListOfVtSessionIdentifiers {
			lengthInBits += element.GetLengthInBits(ctx)
		}
	}

	// Simple field (closingTag)
	lengthInBits += m.ClosingTag.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_VTCloseErrorListOfVTSessionIdentifiers) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func VTCloseErrorListOfVTSessionIdentifiersParse(ctx context.Context, theBytes []byte, tagNumber uint8) (VTCloseErrorListOfVTSessionIdentifiers, error) {
	return VTCloseErrorListOfVTSessionIdentifiersParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), tagNumber)
}

func VTCloseErrorListOfVTSessionIdentifiersParseWithBufferProducer(tagNumber uint8) func(ctx context.Context, readBuffer utils.ReadBuffer) (VTCloseErrorListOfVTSessionIdentifiers, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (VTCloseErrorListOfVTSessionIdentifiers, error) {
		return VTCloseErrorListOfVTSessionIdentifiersParseWithBuffer(ctx, readBuffer, tagNumber)
	}
}

func VTCloseErrorListOfVTSessionIdentifiersParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8) (VTCloseErrorListOfVTSessionIdentifiers, error) {
	v, err := (&_VTCloseErrorListOfVTSessionIdentifiers{TagNumber: tagNumber}).parse(ctx, readBuffer, tagNumber)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_VTCloseErrorListOfVTSessionIdentifiers) parse(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8) (__vTCloseErrorListOfVTSessionIdentifiers VTCloseErrorListOfVTSessionIdentifiers, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("VTCloseErrorListOfVTSessionIdentifiers"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for VTCloseErrorListOfVTSessionIdentifiers")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	openingTag, err := ReadSimpleField[BACnetOpeningTag](ctx, "openingTag", ReadComplex[BACnetOpeningTag](BACnetOpeningTagParseWithBufferProducer((uint8)(tagNumber)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'openingTag' field"))
	}
	m.OpeningTag = openingTag

	listOfVtSessionIdentifiers, err := ReadTerminatedArrayField[BACnetApplicationTagUnsignedInteger](ctx, "listOfVtSessionIdentifiers", ReadComplex[BACnetApplicationTagUnsignedInteger](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagUnsignedInteger](), readBuffer), IsBACnetConstructedDataClosingTag(ctx, readBuffer, false, 1))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'listOfVtSessionIdentifiers' field"))
	}
	m.ListOfVtSessionIdentifiers = listOfVtSessionIdentifiers

	closingTag, err := ReadSimpleField[BACnetClosingTag](ctx, "closingTag", ReadComplex[BACnetClosingTag](BACnetClosingTagParseWithBufferProducer((uint8)(tagNumber)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'closingTag' field"))
	}
	m.ClosingTag = closingTag

	if closeErr := readBuffer.CloseContext("VTCloseErrorListOfVTSessionIdentifiers"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for VTCloseErrorListOfVTSessionIdentifiers")
	}

	return m, nil
}

func (m *_VTCloseErrorListOfVTSessionIdentifiers) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_VTCloseErrorListOfVTSessionIdentifiers) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("VTCloseErrorListOfVTSessionIdentifiers"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for VTCloseErrorListOfVTSessionIdentifiers")
	}

	if err := WriteSimpleField[BACnetOpeningTag](ctx, "openingTag", m.GetOpeningTag(), WriteComplex[BACnetOpeningTag](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'openingTag' field")
	}

	if err := WriteComplexTypeArrayField(ctx, "listOfVtSessionIdentifiers", m.GetListOfVtSessionIdentifiers(), writeBuffer); err != nil {
		return errors.Wrap(err, "Error serializing 'listOfVtSessionIdentifiers' field")
	}

	if err := WriteSimpleField[BACnetClosingTag](ctx, "closingTag", m.GetClosingTag(), WriteComplex[BACnetClosingTag](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'closingTag' field")
	}

	if popErr := writeBuffer.PopContext("VTCloseErrorListOfVTSessionIdentifiers"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for VTCloseErrorListOfVTSessionIdentifiers")
	}
	return nil
}

////
// Arguments Getter

func (m *_VTCloseErrorListOfVTSessionIdentifiers) GetTagNumber() uint8 {
	return m.TagNumber
}

//
////

func (m *_VTCloseErrorListOfVTSessionIdentifiers) IsVTCloseErrorListOfVTSessionIdentifiers() {}

func (m *_VTCloseErrorListOfVTSessionIdentifiers) DeepCopy() any {
	return m.deepCopy()
}

func (m *_VTCloseErrorListOfVTSessionIdentifiers) deepCopy() *_VTCloseErrorListOfVTSessionIdentifiers {
	if m == nil {
		return nil
	}
	_VTCloseErrorListOfVTSessionIdentifiersCopy := &_VTCloseErrorListOfVTSessionIdentifiers{
		utils.DeepCopy[BACnetOpeningTag](m.OpeningTag),
		utils.DeepCopySlice[BACnetApplicationTagUnsignedInteger, BACnetApplicationTagUnsignedInteger](m.ListOfVtSessionIdentifiers),
		utils.DeepCopy[BACnetClosingTag](m.ClosingTag),
		m.TagNumber,
	}
	return _VTCloseErrorListOfVTSessionIdentifiersCopy
}

func (m *_VTCloseErrorListOfVTSessionIdentifiers) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
