/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// Constant values.
const RequestNull_NULLINDICATOR uint32 = 0x6E756C6C

// RequestNull is the corresponding interface of RequestNull
type RequestNull interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	Request
	// IsRequestNull is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsRequestNull()
	// CreateBuilder creates a RequestNullBuilder
	CreateRequestNullBuilder() RequestNullBuilder
}

// _RequestNull is the data-structure of this message
type _RequestNull struct {
	RequestContract
}

var _ RequestNull = (*_RequestNull)(nil)
var _ RequestRequirements = (*_RequestNull)(nil)

// NewRequestNull factory function for _RequestNull
func NewRequestNull(peekedByte RequestType, startingCR *RequestType, resetMode *RequestType, secondPeek RequestType, termination RequestTermination, cBusOptions CBusOptions) *_RequestNull {
	_result := &_RequestNull{
		RequestContract: NewRequest(peekedByte, startingCR, resetMode, secondPeek, termination, cBusOptions),
	}
	_result.RequestContract.(*_Request)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// RequestNullBuilder is a builder for RequestNull
type RequestNullBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() RequestNullBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() RequestBuilder
	// Build builds the RequestNull or returns an error if something is wrong
	Build() (RequestNull, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() RequestNull
}

// NewRequestNullBuilder() creates a RequestNullBuilder
func NewRequestNullBuilder() RequestNullBuilder {
	return &_RequestNullBuilder{_RequestNull: new(_RequestNull)}
}

type _RequestNullBuilder struct {
	*_RequestNull

	parentBuilder *_RequestBuilder

	collectedErr []error
}

var _ (RequestNullBuilder) = (*_RequestNullBuilder)(nil)

func (b *_RequestNullBuilder) setParent(contract RequestContract) {
	b.RequestContract = contract
	contract.(*_Request)._SubType = b._RequestNull
}

func (b *_RequestNullBuilder) WithMandatoryFields() RequestNullBuilder {
	return b
}

func (b *_RequestNullBuilder) Build() (RequestNull, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._RequestNull.deepCopy(), nil
}

func (b *_RequestNullBuilder) MustBuild() RequestNull {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_RequestNullBuilder) Done() RequestBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewRequestBuilder().(*_RequestBuilder)
	}
	return b.parentBuilder
}

func (b *_RequestNullBuilder) buildForRequest() (Request, error) {
	return b.Build()
}

func (b *_RequestNullBuilder) DeepCopy() any {
	_copy := b.CreateRequestNullBuilder().(*_RequestNullBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateRequestNullBuilder creates a RequestNullBuilder
func (b *_RequestNull) CreateRequestNullBuilder() RequestNullBuilder {
	if b == nil {
		return NewRequestNullBuilder()
	}
	return &_RequestNullBuilder{_RequestNull: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_RequestNull) GetParent() RequestContract {
	return m.RequestContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for const fields.
///////////////////////

func (m *_RequestNull) GetNullIndicator() uint32 {
	return RequestNull_NULLINDICATOR
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastRequestNull(structType any) RequestNull {
	if casted, ok := structType.(RequestNull); ok {
		return casted
	}
	if casted, ok := structType.(*RequestNull); ok {
		return *casted
	}
	return nil
}

func (m *_RequestNull) GetTypeName() string {
	return "RequestNull"
}

func (m *_RequestNull) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.RequestContract.(*_Request).getLengthInBits(ctx))

	// Const Field (nullIndicator)
	lengthInBits += 32

	return lengthInBits
}

func (m *_RequestNull) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_RequestNull) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_Request, cBusOptions CBusOptions) (__requestNull RequestNull, err error) {
	m.RequestContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("RequestNull"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for RequestNull")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	nullIndicator, err := ReadConstField[uint32](ctx, "nullIndicator", ReadUnsignedInt(readBuffer, uint8(32)), RequestNull_NULLINDICATOR)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'nullIndicator' field"))
	}
	_ = nullIndicator

	if closeErr := readBuffer.CloseContext("RequestNull"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for RequestNull")
	}

	return m, nil
}

func (m *_RequestNull) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_RequestNull) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("RequestNull"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for RequestNull")
		}

		if err := WriteConstField(ctx, "nullIndicator", RequestNull_NULLINDICATOR, WriteUnsignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'nullIndicator' field")
		}

		if popErr := writeBuffer.PopContext("RequestNull"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for RequestNull")
		}
		return nil
	}
	return m.RequestContract.(*_Request).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_RequestNull) IsRequestNull() {}

func (m *_RequestNull) DeepCopy() any {
	return m.deepCopy()
}

func (m *_RequestNull) deepCopy() *_RequestNull {
	if m == nil {
		return nil
	}
	_RequestNullCopy := &_RequestNull{
		m.RequestContract.(*_Request).deepCopy(),
	}
	_RequestNullCopy.RequestContract.(*_Request)._SubType = m
	return _RequestNullCopy
}

func (m *_RequestNull) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
