/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// LldpTlvType is the corresponding interface of LldpTlvType
type LldpTlvType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetTlvType returns TlvType (property field)
	GetTlvType() uint32
	// GetTlvInfo returns TlvInfo (property field)
	GetTlvInfo() PascalByteString
	// IsLldpTlvType is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsLldpTlvType()
	// CreateBuilder creates a LldpTlvTypeBuilder
	CreateLldpTlvTypeBuilder() LldpTlvTypeBuilder
}

// _LldpTlvType is the data-structure of this message
type _LldpTlvType struct {
	ExtensionObjectDefinitionContract
	TlvType uint32
	TlvInfo PascalByteString
}

var _ LldpTlvType = (*_LldpTlvType)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_LldpTlvType)(nil)

// NewLldpTlvType factory function for _LldpTlvType
func NewLldpTlvType(tlvType uint32, tlvInfo PascalByteString) *_LldpTlvType {
	if tlvInfo == nil {
		panic("tlvInfo of type PascalByteString for LldpTlvType must not be nil")
	}
	_result := &_LldpTlvType{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		TlvType:                           tlvType,
		TlvInfo:                           tlvInfo,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// LldpTlvTypeBuilder is a builder for LldpTlvType
type LldpTlvTypeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(tlvType uint32, tlvInfo PascalByteString) LldpTlvTypeBuilder
	// WithTlvType adds TlvType (property field)
	WithTlvType(uint32) LldpTlvTypeBuilder
	// WithTlvInfo adds TlvInfo (property field)
	WithTlvInfo(PascalByteString) LldpTlvTypeBuilder
	// WithTlvInfoBuilder adds TlvInfo (property field) which is build by the builder
	WithTlvInfoBuilder(func(PascalByteStringBuilder) PascalByteStringBuilder) LldpTlvTypeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the LldpTlvType or returns an error if something is wrong
	Build() (LldpTlvType, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() LldpTlvType
}

// NewLldpTlvTypeBuilder() creates a LldpTlvTypeBuilder
func NewLldpTlvTypeBuilder() LldpTlvTypeBuilder {
	return &_LldpTlvTypeBuilder{_LldpTlvType: new(_LldpTlvType)}
}

type _LldpTlvTypeBuilder struct {
	*_LldpTlvType

	parentBuilder *_ExtensionObjectDefinitionBuilder

	collectedErr []error
}

var _ (LldpTlvTypeBuilder) = (*_LldpTlvTypeBuilder)(nil)

func (b *_LldpTlvTypeBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._LldpTlvType
}

func (b *_LldpTlvTypeBuilder) WithMandatoryFields(tlvType uint32, tlvInfo PascalByteString) LldpTlvTypeBuilder {
	return b.WithTlvType(tlvType).WithTlvInfo(tlvInfo)
}

func (b *_LldpTlvTypeBuilder) WithTlvType(tlvType uint32) LldpTlvTypeBuilder {
	b.TlvType = tlvType
	return b
}

func (b *_LldpTlvTypeBuilder) WithTlvInfo(tlvInfo PascalByteString) LldpTlvTypeBuilder {
	b.TlvInfo = tlvInfo
	return b
}

func (b *_LldpTlvTypeBuilder) WithTlvInfoBuilder(builderSupplier func(PascalByteStringBuilder) PascalByteStringBuilder) LldpTlvTypeBuilder {
	builder := builderSupplier(b.TlvInfo.CreatePascalByteStringBuilder())
	var err error
	b.TlvInfo, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "PascalByteStringBuilder failed"))
	}
	return b
}

func (b *_LldpTlvTypeBuilder) Build() (LldpTlvType, error) {
	if b.TlvInfo == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'tlvInfo' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._LldpTlvType.deepCopy(), nil
}

func (b *_LldpTlvTypeBuilder) MustBuild() LldpTlvType {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_LldpTlvTypeBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_LldpTlvTypeBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_LldpTlvTypeBuilder) DeepCopy() any {
	_copy := b.CreateLldpTlvTypeBuilder().(*_LldpTlvTypeBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateLldpTlvTypeBuilder creates a LldpTlvTypeBuilder
func (b *_LldpTlvType) CreateLldpTlvTypeBuilder() LldpTlvTypeBuilder {
	if b == nil {
		return NewLldpTlvTypeBuilder()
	}
	return &_LldpTlvTypeBuilder{_LldpTlvType: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_LldpTlvType) GetExtensionId() int32 {
	return int32(18957)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_LldpTlvType) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_LldpTlvType) GetTlvType() uint32 {
	return m.TlvType
}

func (m *_LldpTlvType) GetTlvInfo() PascalByteString {
	return m.TlvInfo
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastLldpTlvType(structType any) LldpTlvType {
	if casted, ok := structType.(LldpTlvType); ok {
		return casted
	}
	if casted, ok := structType.(*LldpTlvType); ok {
		return *casted
	}
	return nil
}

func (m *_LldpTlvType) GetTypeName() string {
	return "LldpTlvType"
}

func (m *_LldpTlvType) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (tlvType)
	lengthInBits += 32

	// Simple field (tlvInfo)
	lengthInBits += m.TlvInfo.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_LldpTlvType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_LldpTlvType) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__lldpTlvType LldpTlvType, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("LldpTlvType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for LldpTlvType")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	tlvType, err := ReadSimpleField(ctx, "tlvType", ReadUnsignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'tlvType' field"))
	}
	m.TlvType = tlvType

	tlvInfo, err := ReadSimpleField[PascalByteString](ctx, "tlvInfo", ReadComplex[PascalByteString](PascalByteStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'tlvInfo' field"))
	}
	m.TlvInfo = tlvInfo

	if closeErr := readBuffer.CloseContext("LldpTlvType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for LldpTlvType")
	}

	return m, nil
}

func (m *_LldpTlvType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_LldpTlvType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("LldpTlvType"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for LldpTlvType")
		}

		if err := WriteSimpleField[uint32](ctx, "tlvType", m.GetTlvType(), WriteUnsignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'tlvType' field")
		}

		if err := WriteSimpleField[PascalByteString](ctx, "tlvInfo", m.GetTlvInfo(), WriteComplex[PascalByteString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'tlvInfo' field")
		}

		if popErr := writeBuffer.PopContext("LldpTlvType"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for LldpTlvType")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_LldpTlvType) IsLldpTlvType() {}

func (m *_LldpTlvType) DeepCopy() any {
	return m.deepCopy()
}

func (m *_LldpTlvType) deepCopy() *_LldpTlvType {
	if m == nil {
		return nil
	}
	_LldpTlvTypeCopy := &_LldpTlvType{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		m.TlvType,
		utils.DeepCopy[PascalByteString](m.TlvInfo),
	}
	_LldpTlvTypeCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _LldpTlvTypeCopy
}

func (m *_LldpTlvType) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
