/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class JsonDataSetWriterMessageDataType extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 15666;
  }

  // Properties.
  protected final JsonDataSetMessageContentMask dataSetMessageContentMask;

  public JsonDataSetWriterMessageDataType(JsonDataSetMessageContentMask dataSetMessageContentMask) {
    super();
    this.dataSetMessageContentMask = dataSetMessageContentMask;
  }

  public JsonDataSetMessageContentMask getDataSetMessageContentMask() {
    return dataSetMessageContentMask;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("JsonDataSetWriterMessageDataType");

    // Simple Field (dataSetMessageContentMask)
    writeSimpleEnumField(
        "dataSetMessageContentMask",
        "JsonDataSetMessageContentMask",
        dataSetMessageContentMask,
        writeEnum(
            JsonDataSetMessageContentMask::getValue,
            JsonDataSetMessageContentMask::name,
            writeUnsignedLong(writeBuffer, 32)));

    writeBuffer.popContext("JsonDataSetWriterMessageDataType");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    JsonDataSetWriterMessageDataType _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (dataSetMessageContentMask)
    lengthInBits += 32;

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("JsonDataSetWriterMessageDataType");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    JsonDataSetMessageContentMask dataSetMessageContentMask =
        readEnumField(
            "dataSetMessageContentMask",
            "JsonDataSetMessageContentMask",
            readEnum(
                JsonDataSetMessageContentMask::enumForValue, readUnsignedLong(readBuffer, 32)));

    readBuffer.closeContext("JsonDataSetWriterMessageDataType");
    // Create the instance
    return new JsonDataSetWriterMessageDataTypeBuilderImpl(dataSetMessageContentMask);
  }

  public static class JsonDataSetWriterMessageDataTypeBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final JsonDataSetMessageContentMask dataSetMessageContentMask;

    public JsonDataSetWriterMessageDataTypeBuilderImpl(
        JsonDataSetMessageContentMask dataSetMessageContentMask) {
      this.dataSetMessageContentMask = dataSetMessageContentMask;
    }

    public JsonDataSetWriterMessageDataType build() {
      JsonDataSetWriterMessageDataType jsonDataSetWriterMessageDataType =
          new JsonDataSetWriterMessageDataType(dataSetMessageContentMask);
      return jsonDataSetWriterMessageDataType;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof JsonDataSetWriterMessageDataType)) {
      return false;
    }
    JsonDataSetWriterMessageDataType that = (JsonDataSetWriterMessageDataType) o;
    return (getDataSetMessageContentMask() == that.getDataSetMessageContentMask())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getDataSetMessageContentMask());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
