/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.profinet.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class PnIoCm_Submodule_NoInputNoOutputData extends PnIoCm_Submodule implements Message {

  // Accessors for discriminator values.
  public PnIoCm_SubmoduleType getSubmoduleType() {
    return PnIoCm_SubmoduleType.NO_INPUT_NO_OUTPUT_DATA;
  }

  // Constant values.
  public static final Integer DATADESCRIPTION = 0x0001;
  public static final Integer SUBMODULEDATALENGTH = 0x0000;
  public static final Short LENGTHIOCS = 0x01;
  public static final Short LENGTHIOPS = 0x01;

  public PnIoCm_Submodule_NoInputNoOutputData(
      int slotNumber,
      long submoduleIdentNumber,
      boolean discardIoxs,
      boolean reduceOutputModuleDataLength,
      boolean reduceInputModuleDataLength,
      boolean sharedInput) {
    super(
        slotNumber,
        submoduleIdentNumber,
        discardIoxs,
        reduceOutputModuleDataLength,
        reduceInputModuleDataLength,
        sharedInput);
  }

  public int getDataDescription() {
    return DATADESCRIPTION;
  }

  public int getSubmoduleDataLength() {
    return SUBMODULEDATALENGTH;
  }

  public short getLengthIoCs() {
    return LENGTHIOCS;
  }

  public short getLengthIoPs() {
    return LENGTHIOPS;
  }

  @Override
  protected void serializePnIoCm_SubmoduleChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("PnIoCm_Submodule_NoInputNoOutputData");

    // Const Field (dataDescription)
    writeConstField(
        "dataDescription",
        DATADESCRIPTION,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Const Field (submoduleDataLength)
    writeConstField(
        "submoduleDataLength",
        SUBMODULEDATALENGTH,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Const Field (lengthIoCs)
    writeConstField(
        "lengthIoCs",
        LENGTHIOCS,
        writeUnsignedShort(writeBuffer, 8),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Const Field (lengthIoPs)
    writeConstField(
        "lengthIoPs",
        LENGTHIOPS,
        writeUnsignedShort(writeBuffer, 8),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    writeBuffer.popContext("PnIoCm_Submodule_NoInputNoOutputData");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    PnIoCm_Submodule_NoInputNoOutputData _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Const Field (dataDescription)
    lengthInBits += 16;

    // Const Field (submoduleDataLength)
    lengthInBits += 16;

    // Const Field (lengthIoCs)
    lengthInBits += 8;

    // Const Field (lengthIoPs)
    lengthInBits += 8;

    return lengthInBits;
  }

  public static PnIoCm_SubmoduleBuilder staticParsePnIoCm_SubmoduleBuilder(ReadBuffer readBuffer)
      throws ParseException {
    readBuffer.pullContext("PnIoCm_Submodule_NoInputNoOutputData");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    int dataDescription =
        readConstField(
            "dataDescription",
            readUnsignedInt(readBuffer, 16),
            PnIoCm_Submodule_NoInputNoOutputData.DATADESCRIPTION,
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    int submoduleDataLength =
        readConstField(
            "submoduleDataLength",
            readUnsignedInt(readBuffer, 16),
            PnIoCm_Submodule_NoInputNoOutputData.SUBMODULEDATALENGTH,
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    short lengthIoCs =
        readConstField(
            "lengthIoCs",
            readUnsignedShort(readBuffer, 8),
            PnIoCm_Submodule_NoInputNoOutputData.LENGTHIOCS,
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    short lengthIoPs =
        readConstField(
            "lengthIoPs",
            readUnsignedShort(readBuffer, 8),
            PnIoCm_Submodule_NoInputNoOutputData.LENGTHIOPS,
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    readBuffer.closeContext("PnIoCm_Submodule_NoInputNoOutputData");
    // Create the instance
    return new PnIoCm_Submodule_NoInputNoOutputDataBuilderImpl();
  }

  public static class PnIoCm_Submodule_NoInputNoOutputDataBuilderImpl
      implements PnIoCm_Submodule.PnIoCm_SubmoduleBuilder {

    public PnIoCm_Submodule_NoInputNoOutputDataBuilderImpl() {}

    public PnIoCm_Submodule_NoInputNoOutputData build(
        int slotNumber,
        long submoduleIdentNumber,
        boolean discardIoxs,
        boolean reduceOutputModuleDataLength,
        boolean reduceInputModuleDataLength,
        boolean sharedInput) {
      PnIoCm_Submodule_NoInputNoOutputData pnIoCm_Submodule_NoInputNoOutputData =
          new PnIoCm_Submodule_NoInputNoOutputData(
              slotNumber,
              submoduleIdentNumber,
              discardIoxs,
              reduceOutputModuleDataLength,
              reduceInputModuleDataLength,
              sharedInput);
      return pnIoCm_Submodule_NoInputNoOutputData;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof PnIoCm_Submodule_NoInputNoOutputData)) {
      return false;
    }
    PnIoCm_Submodule_NoInputNoOutputData that = (PnIoCm_Submodule_NoInputNoOutputData) o;
    return super.equals(that) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
