/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.util;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Date;
import java.util.HashSet;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.admin.client.RangerAdminClient;
import org.apache.ranger.authorization.hadoop.config.RangerPluginConfig;
import org.apache.ranger.authorization.utils.JsonUtils;
import org.apache.ranger.plugin.model.RangerRole;
import org.apache.ranger.plugin.service.RangerBasePlugin;
import org.apache.ranger.plugin.util.RangerPerfTracer;
import org.apache.ranger.plugin.util.RangerRoles;
import org.apache.ranger.plugin.util.RangerServiceNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerRolesProvider {
    private static final Logger LOG = LoggerFactory.getLogger(RangerRolesProvider.class);
    private static final Logger PERF_POLICYENGINE_INIT_LOG = RangerPerfTracer.getPerfLogger("policyengine.init");
    private final String serviceType;
    private final String serviceName;
    private final RangerAdminClient rangerAdmin;
    private final String cacheFileName;
    private final String cacheFileNamePrefix;
    private final String cacheDir;
    private final boolean disableCacheIfServiceNotFound;
    private long lastActivationTimeInMillis;
    private long lastKnownRoleVersion = -1L;
    private boolean rangerUserGroupRolesSetInPlugin;
    private boolean serviceDefSetInPlugin;

    public RangerRolesProvider(String serviceType, String appId, String serviceName, RangerAdminClient rangerAdmin, String cacheDir, RangerPluginConfig config) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerRolesProvider(serviceName=" + serviceName + ").RangerRolesProvider()");
        }
        this.serviceType = serviceType;
        this.serviceName = serviceName;
        this.rangerAdmin = rangerAdmin;
        if (StringUtils.isEmpty((String)appId)) {
            appId = serviceType;
        }
        this.cacheFileNamePrefix = "roles";
        String cacheFilename = String.format("%s_%s_%s.json", appId, serviceName, this.cacheFileNamePrefix);
        cacheFilename = cacheFilename.replace(File.separatorChar, '_');
        this.cacheFileName = cacheFilename = cacheFilename.replace(File.pathSeparatorChar, '_');
        this.cacheDir = cacheDir;
        String propertyPrefix = config.getPropertyPrefix();
        this.disableCacheIfServiceNotFound = config.getBoolean(propertyPrefix + ".disable.cache.if.servicenotfound", true);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerRolesProvider(serviceName=" + serviceName + ").RangerRolesProvider()");
        }
    }

    public long getLastActivationTimeInMillis() {
        return this.lastActivationTimeInMillis;
    }

    public void setLastActivationTimeInMillis(long lastActivationTimeInMillis) {
        this.lastActivationTimeInMillis = lastActivationTimeInMillis;
    }

    public void loadUserGroupRoles(RangerBasePlugin plugIn) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerRolesProvider(serviceName= " + this.serviceName + " serviceType= " + this.serviceType + ").loadUserGroupRoles()");
        }
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYENGINE_INIT_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_POLICYENGINE_INIT_LOG, "RangerRolesProvider.loadUserGroupRoles(serviceName=" + this.serviceName + ")");
            long freeMemory = Runtime.getRuntime().freeMemory();
            long totalMemory = Runtime.getRuntime().totalMemory();
            PERF_POLICYENGINE_INIT_LOG.debug("In-Use memory: " + (totalMemory - freeMemory) + ", Free memory:" + freeMemory);
        }
        try {
            RangerRoles roles = this.loadUserGroupRolesFromAdmin();
            if (roles == null && !this.rangerUserGroupRolesSetInPlugin) {
                roles = this.loadUserGroupRolesFromCache();
            }
            if (PERF_POLICYENGINE_INIT_LOG.isDebugEnabled()) {
                long freeMemory = Runtime.getRuntime().freeMemory();
                long totalMemory = Runtime.getRuntime().totalMemory();
                PERF_POLICYENGINE_INIT_LOG.debug("In-Use memory: " + (totalMemory - freeMemory) + ", Free memory:" + freeMemory);
            }
            if (roles != null) {
                plugIn.setRoles(roles);
                this.rangerUserGroupRolesSetInPlugin = true;
                this.setLastActivationTimeInMillis(System.currentTimeMillis());
                this.lastKnownRoleVersion = roles.getRoleVersion() != null ? roles.getRoleVersion() : -1L;
            } else if (!this.rangerUserGroupRolesSetInPlugin && !this.serviceDefSetInPlugin) {
                plugIn.setRoles(null);
                this.serviceDefSetInPlugin = true;
            }
        }
        catch (RangerServiceNotFoundException snfe) {
            if (this.disableCacheIfServiceNotFound) {
                this.disableCache();
                plugIn.setRoles(null);
                this.setLastActivationTimeInMillis(System.currentTimeMillis());
                this.lastKnownRoleVersion = -1L;
                this.serviceDefSetInPlugin = true;
            }
        }
        catch (Exception excp) {
            LOG.error("Encountered unexpected exception, ignoring..", (Throwable)excp);
        }
        RangerPerfTracer.log(perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerRolesProvider(serviceName=" + this.serviceName + ").loadUserGroupRoles()");
        }
    }

    private RangerRoles loadUserGroupRolesFromAdmin() throws RangerServiceNotFoundException {
        RangerRoles roles;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerRolesProvider(serviceName=" + this.serviceName + ").loadUserGroupRolesFromAdmin()");
        }
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYENGINE_INIT_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_POLICYENGINE_INIT_LOG, "RangerRolesProvider.loadUserGroupRolesFromAdmin(serviceName=" + this.serviceName + ")");
        }
        try {
            boolean isUpdated;
            roles = this.rangerAdmin.getRolesIfUpdated(this.lastKnownRoleVersion, this.lastActivationTimeInMillis);
            boolean bl = isUpdated = roles != null;
            if (isUpdated) {
                long newVersion = roles.getRoleVersion() == null ? -1L : roles.getRoleVersion();
                this.saveToCache(roles);
                LOG.info("RangerRolesProvider(serviceName=" + this.serviceName + "): found updated version. lastKnownRoleVersion=" + this.lastKnownRoleVersion + "; newVersion=" + newVersion);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("RangerRolesProvider(serviceName=" + this.serviceName + ").run(): no update found. lastKnownRoleVersion=" + this.lastKnownRoleVersion);
            }
        }
        catch (RangerServiceNotFoundException snfe) {
            LOG.error("RangerRolesProvider(serviceName=" + this.serviceName + "): failed to find service. Will clean up local cache of roles (" + this.lastKnownRoleVersion + ")", (Throwable)snfe);
            throw snfe;
        }
        catch (Exception excp) {
            LOG.error("RangerRolesProvider(serviceName=" + this.serviceName + "): failed to refresh roles. Will continue to use last known version of roles (lastKnowRoleVersion= " + this.lastKnownRoleVersion, (Throwable)excp);
            roles = null;
        }
        RangerPerfTracer.log(perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerRolesProvider(serviceName=" + this.serviceName + " serviceType= " + this.serviceType + " ).loadUserGroupRolesFromAdmin()");
        }
        return roles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RangerRoles loadUserGroupRolesFromCache() {
        RangerRoles roles;
        block18: {
            block19: {
                RangerPerfTracer perf;
                FileReader reader;
                File cacheFile;
                block17: {
                    roles = null;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("==> RangerRolesProvider(serviceName=" + this.serviceName + ").loadUserGroupRolesFromCache()");
                    }
                    File file = cacheFile = this.cacheDir == null ? null : new File(this.cacheDir + File.separator + this.cacheFileName);
                    if (cacheFile == null || !cacheFile.isFile() || !cacheFile.canRead()) break block19;
                    reader = null;
                    perf = null;
                    if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYENGINE_INIT_LOG)) {
                        perf = RangerPerfTracer.getPerfTracer(PERF_POLICYENGINE_INIT_LOG, "RangerRolesProvider.loadUserGroupRolesFromCache(serviceName=" + this.serviceName + ")");
                    }
                    try {
                        reader = new FileReader(cacheFile);
                        roles = JsonUtils.jsonToObject(reader, RangerRoles.class);
                        if (roles == null) break block17;
                        if (!StringUtils.equals((String)this.serviceName, (String)roles.getServiceName())) {
                            LOG.warn("ignoring unexpected serviceName '" + roles.getServiceName() + "' in cache file '" + cacheFile.getAbsolutePath() + "'");
                            roles.setServiceName(this.serviceName);
                        }
                        this.lastKnownRoleVersion = roles.getRoleVersion() == null ? -1L : roles.getRoleVersion();
                    }
                    catch (Exception excp) {
                        try {
                            LOG.error("failed to load userGroupRoles from cache file " + cacheFile.getAbsolutePath(), (Throwable)excp);
                        }
                        catch (Throwable throwable) {
                            RangerPerfTracer.log(perf);
                            if (reader != null) {
                                try {
                                    ((Reader)reader).close();
                                }
                                catch (Exception excp2) {
                                    LOG.error("error while closing opened cache file " + cacheFile.getAbsolutePath(), (Throwable)excp2);
                                }
                            }
                            throw throwable;
                        }
                        RangerPerfTracer.log(perf);
                        if (reader != null) {
                            try {
                                ((Reader)reader).close();
                            }
                            catch (Exception excp3) {
                                LOG.error("error while closing opened cache file " + cacheFile.getAbsolutePath(), (Throwable)excp3);
                            }
                        }
                        break block18;
                    }
                }
                RangerPerfTracer.log(perf);
                if (reader != null) {
                    try {
                        ((Reader)reader).close();
                    }
                    catch (Exception excp) {
                        LOG.error("error while closing opened cache file " + cacheFile.getAbsolutePath(), (Throwable)excp);
                    }
                }
                break block18;
            }
            roles = new RangerRoles();
            roles.setServiceName(this.serviceName);
            roles.setRoleVersion(-1L);
            roles.setRoleUpdateTime(new Date());
            roles.setRangerRoles(new HashSet<RangerRole>());
            this.saveToCache(roles);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerRolesProvider(serviceName=" + this.serviceName + ").RangerRolesProvider()");
        }
        return roles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToCache(RangerRoles roles) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerRolesProvider(serviceName=" + this.serviceName + ").saveToCache()");
        }
        if (roles != null) {
            File cacheFile = null;
            if (this.cacheDir != null) {
                File cacheDirTmp = new File(this.cacheDir);
                if (cacheDirTmp.exists()) {
                    cacheFile = new File(this.cacheDir + File.separator + this.cacheFileName);
                } else {
                    try {
                        cacheDirTmp.mkdirs();
                        cacheFile = new File(this.cacheDir + File.separator + this.cacheFileName);
                    }
                    catch (SecurityException ex) {
                        LOG.error("Cannot create cache directory", (Throwable)ex);
                    }
                }
            }
            if (cacheFile != null) {
                RangerPerfTracer perf = null;
                if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYENGINE_INIT_LOG)) {
                    perf = RangerPerfTracer.getPerfTracer(PERF_POLICYENGINE_INIT_LOG, "RangerRolesProvider.saveToCache(serviceName=" + this.serviceName + ")");
                }
                FileWriter writer = null;
                try {
                    writer = new FileWriter(cacheFile);
                    JsonUtils.objectToWriter(writer, roles);
                }
                catch (Exception excp) {
                    LOG.error("failed to save roles to cache file '" + cacheFile.getAbsolutePath() + "'", (Throwable)excp);
                }
                finally {
                    if (writer != null) {
                        try {
                            ((Writer)writer).close();
                        }
                        catch (Exception excp) {
                            LOG.error("error while closing opened cache file '" + cacheFile.getAbsolutePath() + "'", (Throwable)excp);
                        }
                    }
                }
                RangerPerfTracer.log(perf);
            }
        } else {
            LOG.info("roles is null. Nothing to save in cache");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerRolesProvider.saveToCache(serviceName=" + this.serviceName + ")");
        }
    }

    private void disableCache() {
        File cacheFile;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerRolesProvider.disableCache(serviceName=" + this.serviceName + ")");
        }
        File file = cacheFile = this.cacheDir == null ? null : new File(this.cacheDir + File.separator + this.cacheFileName);
        if (cacheFile != null && cacheFile.isFile() && cacheFile.canRead()) {
            LOG.warn("Cleaning up local RangerRoles cache");
            String renamedCacheFile = cacheFile.getAbsolutePath() + "_" + System.currentTimeMillis();
            if (!cacheFile.renameTo(new File(renamedCacheFile))) {
                LOG.error("Failed to move " + cacheFile.getAbsolutePath() + " to " + renamedCacheFile);
            } else {
                LOG.warn("Moved " + cacheFile.getAbsolutePath() + " to " + renamedCacheFile);
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("No local RangerRoles cache found. No need to disable it!");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerRolesProvider.disableCache(serviceName=" + this.serviceName + ")");
        }
    }
}

