/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.service;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.service.ServiceStateChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class LoggingStateChangeListener
implements ServiceStateChangeListener {
    private static final Logger LOG = LoggerFactory.getLogger(LoggingStateChangeListener.class);
    private final Logger log;

    public LoggingStateChangeListener(Logger log) {
        log.isDebugEnabled();
        this.log = log;
    }

    public LoggingStateChangeListener() {
        this(LOG);
    }

    @Override
    public void stateChanged(Service service) {
        this.log.info("Entry to state " + (Object)((Object)service.getServiceState()) + " for " + service.getName());
    }
}

