/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.grpc.server;

import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.ratis.grpc.GrpcUtil;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.proto.grpc.RaftServerProtocolServiceGrpc;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.protocol.RaftServerProtocol;
import org.apache.ratis.server.util.ServerStringUtils;
import org.apache.ratis.thirdparty.io.grpc.Status;
import org.apache.ratis.thirdparty.io.grpc.StatusRuntimeException;
import org.apache.ratis.thirdparty.io.grpc.stub.StreamObserver;
import org.apache.ratis.util.ProtoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GrpcServerProtocolService
extends RaftServerProtocolServiceGrpc.RaftServerProtocolServiceImplBase {
    public static final Logger LOG = LoggerFactory.getLogger(GrpcServerProtocolService.class);
    private final Supplier<RaftPeerId> idSupplier;
    private final RaftServer server;

    GrpcServerProtocolService(Supplier<RaftPeerId> idSupplier, RaftServer server) {
        this.idSupplier = idSupplier;
        this.server = server;
    }

    RaftPeerId getId() {
        return this.idSupplier.get();
    }

    @Override
    public void requestVote(RaftProtos.RequestVoteRequestProto request, StreamObserver<RaftProtos.RequestVoteReplyProto> responseObserver) {
        try {
            RaftProtos.RequestVoteReplyProto reply = this.server.requestVote(request);
            responseObserver.onNext(reply);
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            GrpcUtil.warn(LOG, () -> this.getId() + ": Failed requestVote " + ProtoUtils.toString(request.getServerRequest()), e);
            responseObserver.onError(GrpcUtil.wrapException(e));
        }
    }

    @Override
    public void startLeaderElection(RaftProtos.StartLeaderElectionRequestProto request, StreamObserver<RaftProtos.StartLeaderElectionReplyProto> responseObserver) {
        try {
            RaftProtos.StartLeaderElectionReplyProto reply = this.server.startLeaderElection(request);
            responseObserver.onNext(reply);
            responseObserver.onCompleted();
        }
        catch (Throwable e) {
            GrpcUtil.warn(LOG, () -> this.getId() + ": Failed startLeaderElection " + ProtoUtils.toString(request.getServerRequest()), e);
            responseObserver.onError(GrpcUtil.wrapException(e));
        }
    }

    @Override
    public void readIndex(RaftProtos.ReadIndexRequestProto request, StreamObserver<RaftProtos.ReadIndexReplyProto> responseObserver) {
        Consumer<Throwable> warning = e -> GrpcUtil.warn(LOG, () -> this.getId() + ": Failed readIndex " + ProtoUtils.toString(request.getServerRequest()), e);
        GrpcUtil.asyncCall(responseObserver, () -> this.server.readIndexAsync(request), Function.identity(), warning);
    }

    @Override
    public StreamObserver<RaftProtos.AppendEntriesRequestProto> appendEntries(StreamObserver<RaftProtos.AppendEntriesReplyProto> responseObserver) {
        return new ServerRequestStreamObserver<RaftProtos.AppendEntriesRequestProto, RaftProtos.AppendEntriesReplyProto>(RaftServerProtocol.Op.APPEND_ENTRIES, responseObserver){

            @Override
            CompletableFuture<RaftProtos.AppendEntriesReplyProto> process(RaftProtos.AppendEntriesRequestProto request) throws IOException {
                return GrpcServerProtocolService.this.server.appendEntriesAsync(request);
            }

            @Override
            long getCallId(RaftProtos.AppendEntriesRequestProto request) {
                return request.getServerRequest().getCallId();
            }

            @Override
            String requestToString(RaftProtos.AppendEntriesRequestProto request) {
                return ServerStringUtils.toAppendEntriesRequestString(request);
            }

            @Override
            String replyToString(RaftProtos.AppendEntriesReplyProto reply) {
                return ServerStringUtils.toAppendEntriesReplyString(reply);
            }

            @Override
            boolean replyInOrder(RaftProtos.AppendEntriesRequestProto request) {
                return request.getEntriesCount() != 0;
            }

            @Override
            StatusRuntimeException wrapException(Throwable e, RaftProtos.AppendEntriesRequestProto request) {
                return GrpcUtil.wrapException(e, this.getCallId(request), request.getEntriesCount() == 0);
            }
        };
    }

    @Override
    public StreamObserver<RaftProtos.InstallSnapshotRequestProto> installSnapshot(StreamObserver<RaftProtos.InstallSnapshotReplyProto> responseObserver) {
        return new ServerRequestStreamObserver<RaftProtos.InstallSnapshotRequestProto, RaftProtos.InstallSnapshotReplyProto>(RaftServerProtocol.Op.INSTALL_SNAPSHOT, responseObserver){

            @Override
            CompletableFuture<RaftProtos.InstallSnapshotReplyProto> process(RaftProtos.InstallSnapshotRequestProto request) throws IOException {
                return CompletableFuture.completedFuture(GrpcServerProtocolService.this.server.installSnapshot(request));
            }

            @Override
            long getCallId(RaftProtos.InstallSnapshotRequestProto request) {
                return request.getServerRequest().getCallId();
            }

            @Override
            String requestToString(RaftProtos.InstallSnapshotRequestProto request) {
                return ServerStringUtils.toInstallSnapshotRequestString(request);
            }

            @Override
            String replyToString(RaftProtos.InstallSnapshotReplyProto reply) {
                return ServerStringUtils.toInstallSnapshotReplyString(reply);
            }

            @Override
            boolean replyInOrder(RaftProtos.InstallSnapshotRequestProto installSnapshotRequestProto) {
                return true;
            }
        };
    }

    abstract class ServerRequestStreamObserver<REQUEST, REPLY>
    implements StreamObserver<REQUEST> {
        private final RaftServerProtocol.Op op;
        private final StreamObserver<REPLY> responseObserver;
        private final AtomicReference<PendingServerRequest<REQUEST>> previousOnNext = new AtomicReference();
        private final AtomicReference<CompletableFuture<REPLY>> requestFuture = new AtomicReference<CompletableFuture<Object>>(CompletableFuture.completedFuture(null));
        private final AtomicBoolean isClosed = new AtomicBoolean(false);

        ServerRequestStreamObserver(RaftServerProtocol.Op op, StreamObserver<REPLY> responseObserver) {
            this.op = op;
            this.responseObserver = responseObserver;
        }

        private String getPreviousRequestString() {
            return Optional.ofNullable(this.previousOnNext.get()).map(PendingServerRequest::getRequest).map(this::requestToString).orElse(null);
        }

        abstract CompletableFuture<REPLY> process(REQUEST var1) throws IOException;

        abstract long getCallId(REQUEST var1);

        abstract String requestToString(REQUEST var1);

        abstract String replyToString(REPLY var1);

        abstract boolean replyInOrder(REQUEST var1);

        StatusRuntimeException wrapException(Throwable e, REQUEST request) {
            return GrpcUtil.wrapException(e, this.getCallId(request));
        }

        private void handleError(Throwable e, REQUEST request) {
            GrpcUtil.warn(LOG, () -> GrpcServerProtocolService.this.getId() + ": Failed " + (Object)((Object)this.op) + " request " + this.requestToString(request), e);
            if (this.isClosed.compareAndSet(false, true)) {
                this.responseObserver.onError(this.wrapException(e, request));
            }
        }

        private synchronized REPLY handleReply(REPLY reply) {
            if (!this.isClosed.get()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{}: reply {}", (Object)GrpcServerProtocolService.this.getId(), (Object)this.replyToString(reply));
                }
                this.responseObserver.onNext(reply);
            }
            return reply;
        }

        void composeRequest(CompletableFuture<REPLY> current) {
            this.requestFuture.updateAndGet(previous -> previous.thenCompose(reply -> current));
        }

        @Override
        public void onNext(REQUEST request) {
            if (!this.replyInOrder(request)) {
                try {
                    this.composeRequest((CompletableFuture<REPLY>)this.process(request).thenApply(this::handleReply));
                }
                catch (Exception e2) {
                    this.handleError(e2, request);
                }
                return;
            }
            PendingServerRequest<REQUEST> current = new PendingServerRequest<REQUEST>(request);
            PendingServerRequest<REQUEST> previous = this.previousOnNext.getAndSet(current);
            CompletableFuture<Object> previousFuture = Optional.ofNullable(previous).map(PendingServerRequest::getFuture).orElse(CompletableFuture.completedFuture(null));
            try {
                CompletionStage f = ((CompletableFuture)this.process(request).exceptionally(e -> {
                    this.handleError((Throwable)e, request);
                    current.getFuture().completeExceptionally((Throwable)e);
                    return null;
                })).thenCombine(previousFuture, (reply, v) -> {
                    this.handleReply(reply);
                    current.getFuture().complete(null);
                    return null;
                });
                this.composeRequest((CompletableFuture<REPLY>)f);
            }
            catch (Exception e3) {
                this.handleError(e3, request);
                current.getFuture().completeExceptionally(e3);
            }
        }

        @Override
        public void onCompleted() {
            if (this.isClosed.compareAndSet(false, true)) {
                LOG.info("{}: Completed {}, lastRequest: {}", new Object[]{GrpcServerProtocolService.this.getId(), this.op, this.getPreviousRequestString()});
                this.requestFuture.get().thenAccept(reply -> {
                    LOG.info("{}: Completed {}, lastReply: {}", new Object[]{GrpcServerProtocolService.this.getId(), this.op, reply});
                    this.responseObserver.onCompleted();
                });
            }
        }

        @Override
        public void onError(Throwable t2) {
            Status status;
            GrpcUtil.warn(LOG, () -> GrpcServerProtocolService.this.getId() + ": " + (Object)((Object)this.op) + " onError, lastRequest: " + this.getPreviousRequestString(), t2);
            if (this.isClosed.compareAndSet(false, true) && (status = Status.fromThrowable(t2)) != null && status.getCode() != Status.Code.CANCELLED) {
                this.responseObserver.onCompleted();
            }
        }
    }

    static class PendingServerRequest<REQUEST> {
        private final REQUEST request;
        private final CompletableFuture<Void> future = new CompletableFuture();

        PendingServerRequest(REQUEST request) {
            this.request = request;
        }

        REQUEST getRequest() {
            return this.request;
        }

        CompletableFuture<Void> getFuture() {
            return this.future;
        }
    }
}

