/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.TransferLeadershipRequest;
import org.apache.ratis.protocol.exceptions.TimeoutIOException;
import org.apache.ratis.server.impl.LeaderStateImpl;
import org.apache.ratis.server.leader.LeaderState;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.MemoizedSupplier;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.TimeDuration;
import org.apache.ratis.util.TimeoutExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PendingStepDown {
    public static final Logger LOG = LoggerFactory.getLogger(PendingStepDown.class);
    private final LeaderStateImpl leader;
    private final TimeoutExecutor scheduler = TimeoutExecutor.getInstance();
    private final PendingRequestReference pending = new PendingRequestReference();

    PendingStepDown(LeaderStateImpl leaderState) {
        this.leader = leaderState;
    }

    CompletableFuture<RaftClientReply> submitAsync(TransferLeadershipRequest request) {
        Preconditions.assertNull((Object)request.getNewLeader(), "request.getNewLeader()");
        MemoizedSupplier<PendingRequest> supplier = JavaUtils.memoize(() -> new PendingRequest(request));
        PendingRequest previous = this.pending.getAndUpdate(supplier);
        if (previous != null) {
            return previous.getReplyFuture();
        }
        this.leader.submitStepDownEvent(LeaderState.StepDownReason.FORCE);
        this.scheduler.onTimeout(TimeDuration.valueOf(request.getTimeoutMs(), TimeUnit.MILLISECONDS), this::timeout, LOG, () -> "Timeout check failed for step down leader request: " + request);
        return supplier.get().getReplyFuture();
    }

    void complete(Function<TransferLeadershipRequest, RaftClientReply> newSuccessReply) {
        this.pending.getAndSetNull().ifPresent(p -> p.complete(newSuccessReply));
    }

    void timeout() {
        this.pending.getAndSetNull().ifPresent(PendingRequest::timeout);
    }

    static class PendingRequestReference {
        private final AtomicReference<PendingRequest> ref = new AtomicReference();

        PendingRequestReference() {
        }

        Optional<PendingRequest> getAndSetNull() {
            return Optional.ofNullable(this.ref.getAndSet(null));
        }

        PendingRequest getAndUpdate(Supplier<PendingRequest> supplier) {
            return this.ref.getAndUpdate(p -> p != null ? p : (PendingRequest)supplier.get());
        }
    }

    class PendingRequest {
        private final TransferLeadershipRequest request;
        private final CompletableFuture<RaftClientReply> replyFuture = new CompletableFuture();

        PendingRequest(TransferLeadershipRequest request) {
            this.request = request;
        }

        CompletableFuture<RaftClientReply> getReplyFuture() {
            return this.replyFuture;
        }

        void complete(Function<TransferLeadershipRequest, RaftClientReply> newSuccessReply) {
            LOG.info("Successfully step down leader at {} for request {}", (Object)PendingStepDown.this.leader, (Object)this.request);
            this.replyFuture.complete(newSuccessReply.apply(this.request));
        }

        void timeout() {
            this.replyFuture.completeExceptionally(new TimeoutIOException(": Failed to step down leader on " + PendingStepDown.this.leader + "request " + this.request.getTimeoutMs() + "ms"));
        }

        public String toString() {
            return this.request.toString();
        }
    }
}

