/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.shell.cli.sh.command;

import java.io.PrintStream;
import java.net.InetSocketAddress;
import org.apache.ratis.shell.cli.Command;
import org.apache.ratis.shell.cli.sh.command.Context;

public abstract class AbstractCommand
implements Command {
    private final PrintStream printStream;

    protected AbstractCommand(Context context) {
        this.printStream = context.getPrintStream();
    }

    public static InetSocketAddress parseInetSocketAddress(String address) {
        try {
            String[] hostPortPair = address.split(":");
            if (hostPortPair.length < 2) {
                throw new IllegalArgumentException("Unexpected address format <HOST:PORT>.");
            }
            return new InetSocketAddress(hostPortPair[0], Integer.parseInt(hostPortPair[1]));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to parse the server address parameter \"" + address + "\".", e);
        }
    }

    protected PrintStream getPrintStream() {
        return this.printStream;
    }

    protected void printf(String format, Object ... args) {
        this.printStream.printf(format, args);
    }

    protected void println(Object message) {
        this.printStream.println(message);
    }
}

