/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.grpc.server;

import org.apache.ratis.client.impl.ClientProtoUtils;
import org.apache.ratis.grpc.GrpcUtil;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.proto.grpc.AdminProtocolServiceGrpc;
import org.apache.ratis.protocol.AdminAsynchronousProtocol;
import org.apache.ratis.protocol.GroupInfoRequest;
import org.apache.ratis.protocol.GroupListRequest;
import org.apache.ratis.protocol.GroupManagementRequest;
import org.apache.ratis.protocol.LeaderElectionManagementRequest;
import org.apache.ratis.protocol.SetConfigurationRequest;
import org.apache.ratis.protocol.SnapshotManagementRequest;
import org.apache.ratis.protocol.TransferLeadershipRequest;
import org.apache.ratis.thirdparty.io.grpc.stub.StreamObserver;

public class GrpcAdminProtocolService
extends AdminProtocolServiceGrpc.AdminProtocolServiceImplBase {
    private final AdminAsynchronousProtocol protocol;

    public GrpcAdminProtocolService(AdminAsynchronousProtocol protocol) {
        this.protocol = protocol;
    }

    @Override
    public void groupManagement(RaftProtos.GroupManagementRequestProto proto, StreamObserver<RaftProtos.RaftClientReplyProto> responseObserver) {
        GroupManagementRequest request = ClientProtoUtils.toGroupManagementRequest(proto);
        GrpcUtil.asyncCall(responseObserver, () -> this.protocol.groupManagementAsync(request), ClientProtoUtils::toRaftClientReplyProto);
    }

    @Override
    public void groupList(RaftProtos.GroupListRequestProto proto, StreamObserver<RaftProtos.GroupListReplyProto> responseObserver) {
        GroupListRequest request = ClientProtoUtils.toGroupListRequest(proto);
        GrpcUtil.asyncCall(responseObserver, () -> this.protocol.getGroupListAsync(request), ClientProtoUtils::toGroupListReplyProto);
    }

    @Override
    public void groupInfo(RaftProtos.GroupInfoRequestProto proto, StreamObserver<RaftProtos.GroupInfoReplyProto> responseObserver) {
        GroupInfoRequest request = ClientProtoUtils.toGroupInfoRequest(proto);
        GrpcUtil.asyncCall(responseObserver, () -> this.protocol.getGroupInfoAsync(request), ClientProtoUtils::toGroupInfoReplyProto);
    }

    @Override
    public void setConfiguration(RaftProtos.SetConfigurationRequestProto proto, StreamObserver<RaftProtos.RaftClientReplyProto> responseObserver) {
        SetConfigurationRequest request = ClientProtoUtils.toSetConfigurationRequest(proto);
        GrpcUtil.asyncCall(responseObserver, () -> this.protocol.setConfigurationAsync(request), ClientProtoUtils::toRaftClientReplyProto);
    }

    @Override
    public void transferLeadership(RaftProtos.TransferLeadershipRequestProto proto, StreamObserver<RaftProtos.RaftClientReplyProto> responseObserver) {
        TransferLeadershipRequest request = ClientProtoUtils.toTransferLeadershipRequest(proto);
        GrpcUtil.asyncCall(responseObserver, () -> this.protocol.transferLeadershipAsync(request), ClientProtoUtils::toRaftClientReplyProto);
    }

    @Override
    public void snapshotManagement(RaftProtos.SnapshotManagementRequestProto proto, StreamObserver<RaftProtos.RaftClientReplyProto> responseObserver) {
        SnapshotManagementRequest request = ClientProtoUtils.toSnapshotManagementRequest(proto);
        GrpcUtil.asyncCall(responseObserver, () -> this.protocol.snapshotManagementAsync(request), ClientProtoUtils::toRaftClientReplyProto);
    }

    @Override
    public void leaderElectionManagement(RaftProtos.LeaderElectionManagementRequestProto proto, StreamObserver<RaftProtos.RaftClientReplyProto> responseObserver) {
        LeaderElectionManagementRequest request = ClientProtoUtils.toLeaderElectionManagementRequest(proto);
        GrpcUtil.asyncCall(responseObserver, () -> this.protocol.leaderElectionManagementAsync(request), ClientProtoUtils::toRaftClientReplyProto);
    }
}

