/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.ClientInvocationId;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.exceptions.StreamException;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MessageStreamRequests {
    public static final Logger LOG = LoggerFactory.getLogger(MessageStreamRequests.class);
    private final String name;
    private final StreamMap streams = new StreamMap();

    MessageStreamRequests(Object name) {
        this.name = name + "-" + JavaUtils.getClassSimpleName(this.getClass());
    }

    CompletableFuture<?> streamAsync(RaftClientRequest request) {
        RaftProtos.MessageStreamRequestTypeProto stream = request.getType().getMessageStream();
        Preconditions.assertTrue(!stream.getEndOfRequest());
        ClientInvocationId key = ClientInvocationId.valueOf(request.getClientId(), stream.getStreamId());
        PendingStream pending = this.streams.computeIfAbsent(key);
        return pending.append(stream.getMessageId(), request.getMessage());
    }

    CompletableFuture<ByteString> streamEndOfRequestAsync(RaftClientRequest request) {
        RaftProtos.MessageStreamRequestTypeProto stream = request.getType().getMessageStream();
        Preconditions.assertTrue(stream.getEndOfRequest());
        ClientInvocationId key = ClientInvocationId.valueOf(request.getClientId(), stream.getStreamId());
        PendingStream pending = this.streams.remove(key);
        if (pending == null) {
            return JavaUtils.completeExceptionally(new StreamException(this.name + ": " + key + " not found"));
        }
        return pending.getBytes(stream.getMessageId(), request.getMessage());
    }

    void clear() {
        this.streams.clear();
    }

    static class StreamMap {
        private final ConcurrentMap<ClientInvocationId, PendingStream> map = new ConcurrentHashMap<ClientInvocationId, PendingStream>();

        StreamMap() {
        }

        PendingStream computeIfAbsent(ClientInvocationId key) {
            return this.map.computeIfAbsent(key, PendingStream::new);
        }

        PendingStream remove(ClientInvocationId key) {
            return (PendingStream)this.map.remove(key);
        }

        void clear() {
            this.map.clear();
        }
    }

    private static class PendingStream {
        private final ClientInvocationId key;
        private long nextId = -1L;
        private ByteString bytes = ByteString.EMPTY;

        PendingStream(ClientInvocationId key) {
            this.key = key;
        }

        synchronized CompletableFuture<ByteString> append(long messageId, Message message) {
            if (this.nextId == -1L) {
                this.nextId = messageId;
            } else if (messageId != this.nextId) {
                return JavaUtils.completeExceptionally(new StreamException("Unexpected message id in " + this.key + ": messageId = " + messageId + " != nextId = " + this.nextId));
            }
            ++this.nextId;
            this.bytes = this.bytes.concat(message.getContent());
            return CompletableFuture.completedFuture(this.bytes);
        }

        synchronized CompletableFuture<ByteString> getBytes(long messageId, Message message) {
            return this.append(messageId, message);
        }
    }
}

