/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.examples.counter.server;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ratis.examples.counter.CounterCommand;
import org.apache.ratis.io.MD5Hash;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.server.storage.FileInfo;
import org.apache.ratis.server.storage.RaftStorage;
import org.apache.ratis.statemachine.TransactionContext;
import org.apache.ratis.statemachine.impl.BaseStateMachine;
import org.apache.ratis.statemachine.impl.SimpleStateMachineStorage;
import org.apache.ratis.statemachine.impl.SingleFileSnapshotInfo;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.thirdparty.com.google.protobuf.UnsafeByteOperations;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.MD5FileUtil;
import org.apache.ratis.util.TimeDuration;

public class CounterStateMachine
extends BaseStateMachine {
    private final SimpleStateMachineStorage storage = new SimpleStateMachineStorage();
    private final AtomicInteger counter = new AtomicInteger(0);
    private final TimeDuration simulatedSlowness;

    public CounterStateMachine(TimeDuration simulatedSlowness) {
        this.simulatedSlowness = simulatedSlowness.isPositive() ? simulatedSlowness : null;
    }

    public CounterStateMachine() {
        this(TimeDuration.ZERO);
    }

    synchronized CounterState getState() {
        return new CounterState(this.getLastAppliedTermIndex(), this.counter.get());
    }

    synchronized void updateState(TermIndex applied, int counterValue) {
        this.updateLastAppliedTermIndex(applied);
        this.counter.set(counterValue);
    }

    private synchronized int incrementCounter(TermIndex termIndex) {
        if (this.simulatedSlowness != null) {
            try {
                this.simulatedSlowness.sleep();
            }
            catch (InterruptedException e) {
                LOG.warn("{}: get interrupted in simulated slowness sleep before apply transaction", (Object)this);
                Thread.currentThread().interrupt();
            }
        }
        this.updateLastAppliedTermIndex(termIndex);
        return this.counter.incrementAndGet();
    }

    @Override
    public void initialize(RaftServer server, RaftGroupId groupId, RaftStorage raftStorage) throws IOException {
        super.initialize(server, groupId, raftStorage);
        this.storage.init(raftStorage);
        this.reinitialize();
    }

    @Override
    public void reinitialize() throws IOException {
        this.load(this.storage.loadLatestSnapshot());
    }

    @Override
    public SimpleStateMachineStorage getStateMachineStorage() {
        return this.storage;
    }

    @Override
    public long takeSnapshot() throws IOException {
        CounterState state = this.getState();
        long index = state.getApplied().getIndex();
        File snapshotFile = this.storage.getSnapshotFile(state.getApplied().getTerm(), index);
        try {
            this.saveSnapshot(state, snapshotFile);
        }
        catch (Exception e) {
            throw new IOException("Failed to save snapshot (" + state + ") to file " + snapshotFile, e);
        }
        return index;
    }

    void saveSnapshot(CounterState state, File snapshotFile) throws IOException {
        try (ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(Files.newOutputStream(snapshotFile.toPath(), new OpenOption[0])));){
            out.writeInt(state.getCounter());
        }
        MD5Hash md5 = MD5FileUtil.computeAndSaveMd5ForFile(snapshotFile);
        FileInfo info = new FileInfo(snapshotFile.toPath(), md5);
        this.storage.updateLatestSnapshot(new SingleFileSnapshotInfo(info, state.getApplied()));
    }

    private void load(SingleFileSnapshotInfo snapshot) throws IOException {
        int counterValue;
        if (snapshot == null) {
            return;
        }
        Path snapshotPath = snapshot.getFile().getPath();
        if (!Files.exists(snapshotPath, new LinkOption[0])) {
            LOG.warn("The snapshot file {} does not exist for snapshot {}", (Object)snapshotPath, (Object)snapshot);
            return;
        }
        MD5Hash md5 = snapshot.getFile().getFileDigest();
        if (md5 != null) {
            MD5FileUtil.verifySavedMD5(snapshotPath.toFile(), md5);
        }
        TermIndex last = SimpleStateMachineStorage.getTermIndexFromSnapshotFile(snapshotPath.toFile());
        try (ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(Files.newInputStream(snapshotPath, new OpenOption[0])));){
            counterValue = in.readInt();
        }
        this.updateState(last, counterValue);
    }

    @Override
    public CompletableFuture<Message> query(Message request) {
        String command = request.getContent().toStringUtf8();
        if (!CounterCommand.GET.matches(command)) {
            return JavaUtils.completeExceptionally(new IllegalArgumentException("Invalid Command: " + command));
        }
        return CompletableFuture.completedFuture(Message.valueOf(CounterStateMachine.toByteString(this.counter.get())));
    }

    @Override
    public TransactionContext startTransaction(RaftClientRequest request) throws IOException {
        TransactionContext transaction = super.startTransaction(request);
        ByteString command = request.getMessage().getContent();
        if (!CounterCommand.INCREMENT.matches(command)) {
            transaction.setException(new IllegalArgumentException("Invalid Command: " + command));
        }
        return transaction;
    }

    @Override
    public CompletableFuture<Message> applyTransaction(TransactionContext trx) {
        RaftProtos.LogEntryProto entry = trx.getLogEntry();
        TermIndex termIndex = TermIndex.valueOf(entry);
        int incremented = this.incrementCounter(termIndex);
        if (LOG.isDebugEnabled() && trx.getServerRole() == RaftProtos.RaftPeerRole.LEADER) {
            LOG.debug("{}: Increment to {}", (Object)termIndex, (Object)incremented);
        }
        return CompletableFuture.completedFuture(Message.valueOf(CounterStateMachine.toByteString(incremented)));
    }

    static ByteString toByteString(int n) {
        byte[] array = new byte[4];
        ByteBuffer.wrap(array).putInt(n);
        return UnsafeByteOperations.unsafeWrap(array);
    }

    static class CounterState {
        private final TermIndex applied;
        private final int counter;

        CounterState(TermIndex applied, int counter) {
            this.applied = applied;
            this.counter = counter;
        }

        TermIndex getApplied() {
            return this.applied;
        }

        int getCounter() {
            return this.counter;
        }

        public String toString() {
            return this.counter + "@" + this.applied;
        }
    }
}

