/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.client;

import io.netty.channel.Channel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.rocketmq.broker.client.ClientChannelInfo;
import org.apache.rocketmq.broker.util.PositiveAtomicCounter;
import org.apache.rocketmq.common.protocol.body.ProducerInfo;
import org.apache.rocketmq.common.protocol.body.ProducerTableInfo;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.logging.InternalLoggerFactory;
import org.apache.rocketmq.remoting.common.RemotingHelper;
import org.apache.rocketmq.remoting.common.RemotingUtil;

public class ProducerManager {
    private static final InternalLogger log = InternalLoggerFactory.getLogger((String)"RocketmqBroker");
    private static final long CHANNEL_EXPIRED_TIMEOUT = 120000L;
    private static final int GET_AVAILABLE_CHANNEL_RETRY_COUNT = 3;
    private final ConcurrentHashMap<String, ConcurrentHashMap<Channel, ClientChannelInfo>> groupChannelTable = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Channel> clientChannelTable = new ConcurrentHashMap();
    private PositiveAtomicCounter positiveAtomicCounter = new PositiveAtomicCounter();

    public ConcurrentHashMap<String, ConcurrentHashMap<Channel, ClientChannelInfo>> getGroupChannelTable() {
        return this.groupChannelTable;
    }

    public ProducerTableInfo getProducerTable() {
        HashMap<String, ArrayList<ProducerInfo>> map = new HashMap<String, ArrayList<ProducerInfo>>();
        for (String group : this.groupChannelTable.keySet()) {
            for (Map.Entry<Channel, ClientChannelInfo> entry : this.groupChannelTable.get(group).entrySet()) {
                ClientChannelInfo clientChannelInfo = entry.getValue();
                if (map.containsKey(group)) {
                    ((List)map.get(group)).add(new ProducerInfo(clientChannelInfo.getClientId(), clientChannelInfo.getChannel().remoteAddress().toString(), clientChannelInfo.getLanguage(), clientChannelInfo.getVersion(), clientChannelInfo.getLastUpdateTimestamp()));
                    continue;
                }
                map.put(group, new ArrayList<ProducerInfo>(Collections.singleton(new ProducerInfo(clientChannelInfo.getClientId(), clientChannelInfo.getChannel().remoteAddress().toString(), clientChannelInfo.getLanguage(), clientChannelInfo.getVersion(), clientChannelInfo.getLastUpdateTimestamp()))));
            }
        }
        return new ProducerTableInfo(map);
    }

    public void scanNotActiveChannel() {
        for (Map.Entry<String, ConcurrentHashMap<Channel, ClientChannelInfo>> entry : this.groupChannelTable.entrySet()) {
            String group = entry.getKey();
            ConcurrentHashMap<Channel, ClientChannelInfo> chlMap = entry.getValue();
            Iterator<Map.Entry<Channel, ClientChannelInfo>> it = chlMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Channel, ClientChannelInfo> item = it.next();
                ClientChannelInfo info = item.getValue();
                long diff = System.currentTimeMillis() - info.getLastUpdateTimestamp();
                if (diff <= 120000L) continue;
                it.remove();
                this.clientChannelTable.remove(info.getClientId());
                log.warn("SCAN: remove expired channel[{}] from ProducerManager groupChannelTable, producer group name: {}", (Object)RemotingHelper.parseChannelRemoteAddr((Channel)info.getChannel()), (Object)group);
                RemotingUtil.closeChannel((Channel)info.getChannel());
            }
        }
    }

    public synchronized void doChannelCloseEvent(String remoteAddr, Channel channel) {
        if (channel != null) {
            for (Map.Entry<String, ConcurrentHashMap<Channel, ClientChannelInfo>> entry : this.groupChannelTable.entrySet()) {
                String group = entry.getKey();
                ConcurrentHashMap<Channel, ClientChannelInfo> clientChannelInfoTable = entry.getValue();
                ClientChannelInfo clientChannelInfo = clientChannelInfoTable.remove(channel);
                if (clientChannelInfo == null) continue;
                this.clientChannelTable.remove(clientChannelInfo.getClientId());
                log.info("NETTY EVENT: remove channel[{}][{}] from ProducerManager groupChannelTable, producer group: {}", new Object[]{clientChannelInfo.toString(), remoteAddr, group});
            }
        }
    }

    public synchronized void registerProducer(String group, ClientChannelInfo clientChannelInfo) {
        ClientChannelInfo clientChannelInfoFound = null;
        ConcurrentHashMap<Object, ClientChannelInfo> channelTable = this.groupChannelTable.get(group);
        if (null == channelTable) {
            channelTable = new ConcurrentHashMap();
            this.groupChannelTable.put(group, channelTable);
        }
        if (null == (clientChannelInfoFound = channelTable.get(clientChannelInfo.getChannel()))) {
            channelTable.put(clientChannelInfo.getChannel(), clientChannelInfo);
            this.clientChannelTable.put(clientChannelInfo.getClientId(), clientChannelInfo.getChannel());
            log.info("new producer connected, group: {} channel: {}", (Object)group, (Object)clientChannelInfo.toString());
        }
        if (clientChannelInfoFound != null) {
            clientChannelInfoFound.setLastUpdateTimestamp(System.currentTimeMillis());
        }
    }

    public synchronized void unregisterProducer(String group, ClientChannelInfo clientChannelInfo) {
        ConcurrentHashMap<Channel, ClientChannelInfo> channelTable = this.groupChannelTable.get(group);
        if (null != channelTable && !channelTable.isEmpty()) {
            ClientChannelInfo old = channelTable.remove(clientChannelInfo.getChannel());
            this.clientChannelTable.remove(clientChannelInfo.getClientId());
            if (old != null) {
                log.info("unregister a producer[{}] from groupChannelTable {}", (Object)group, (Object)clientChannelInfo.toString());
            }
            if (channelTable.isEmpty()) {
                this.groupChannelTable.remove(group);
                log.info("unregister a producer group[{}] from groupChannelTable", (Object)group);
            }
        }
    }

    public Channel getAvailableChannel(String groupId) {
        boolean isOk;
        if (groupId == null) {
            return null;
        }
        ConcurrentHashMap<Channel, ClientChannelInfo> channelClientChannelInfoHashMap = this.groupChannelTable.get(groupId);
        if (channelClientChannelInfoHashMap == null) {
            log.warn("Check transaction failed, channel table is empty. groupId={}", (Object)groupId);
            return null;
        }
        ArrayList channelList = new ArrayList(channelClientChannelInfoHashMap.keySet());
        int size = channelList.size();
        if (0 == size) {
            log.warn("Channel list is empty. groupId={}", (Object)groupId);
            return null;
        }
        Channel lastActiveChannel = null;
        int index = this.positiveAtomicCounter.incrementAndGet() % size;
        Channel channel = (Channel)channelList.get(index);
        int count = 0;
        boolean bl = isOk = channel.isActive() && channel.isWritable();
        while (count++ < 3) {
            if (isOk) {
                return channel;
            }
            if (channel.isActive()) {
                lastActiveChannel = channel;
            }
            ++index;
            channel = (Channel)channelList.get(index %= size);
            isOk = channel.isActive() && channel.isWritable();
        }
        return lastActiveChannel;
    }

    public Channel findChannel(String clientId) {
        return this.clientChannelTable.get(clientId);
    }
}

