/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.remoting.channel;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.base.MoreObjects;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelMetadata;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.utils.NetworkUtil;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.proxy.common.channel.ChannelHelper;
import org.apache.rocketmq.proxy.common.utils.FutureUtils;
import org.apache.rocketmq.proxy.config.ConfigurationManager;
import org.apache.rocketmq.proxy.processor.channel.ChannelExtendAttributeGetter;
import org.apache.rocketmq.proxy.processor.channel.ChannelProtocolType;
import org.apache.rocketmq.proxy.processor.channel.RemoteChannel;
import org.apache.rocketmq.proxy.processor.channel.RemoteChannelConverter;
import org.apache.rocketmq.proxy.remoting.RemotingProxyOutClient;
import org.apache.rocketmq.proxy.remoting.common.RemotingConverter;
import org.apache.rocketmq.proxy.service.relay.ProxyChannel;
import org.apache.rocketmq.proxy.service.relay.ProxyRelayResult;
import org.apache.rocketmq.proxy.service.relay.ProxyRelayService;
import org.apache.rocketmq.proxy.service.transaction.TransactionData;
import org.apache.rocketmq.remoting.CommandCustomHeader;
import org.apache.rocketmq.remoting.exception.RemotingException;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.remoting.protocol.body.ConsumeMessageDirectlyResult;
import org.apache.rocketmq.remoting.protocol.body.ConsumerRunningInfo;
import org.apache.rocketmq.remoting.protocol.header.CheckTransactionStateRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.ConsumeMessageDirectlyResultRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.GetConsumerRunningInfoRequestHeader;
import org.apache.rocketmq.remoting.protocol.heartbeat.SubscriptionData;

public class RemotingChannel
extends ProxyChannel
implements RemoteChannelConverter,
ChannelExtendAttributeGetter {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqProxy");
    private static final long DEFAULT_MQ_CLIENT_TIMEOUT = Duration.ofSeconds(3L).toMillis();
    private final String clientId;
    private final String remoteAddress;
    private final String localAddress;
    private final RemotingProxyOutClient remotingProxyOutClient;
    private final Set<SubscriptionData> subscriptionData;

    public RemotingChannel(RemotingProxyOutClient remotingProxyOutClient, ProxyRelayService proxyRelayService, Channel parent, String clientId, Set<SubscriptionData> subscriptionData) {
        super(proxyRelayService, parent, parent.id(), NetworkUtil.socketAddress2String((SocketAddress)parent.remoteAddress()), NetworkUtil.socketAddress2String((SocketAddress)parent.localAddress()));
        this.remotingProxyOutClient = remotingProxyOutClient;
        this.clientId = clientId;
        this.remoteAddress = NetworkUtil.socketAddress2String((SocketAddress)parent.remoteAddress());
        this.localAddress = NetworkUtil.socketAddress2String((SocketAddress)parent.localAddress());
        this.subscriptionData = subscriptionData;
    }

    @Override
    public boolean isOpen() {
        return this.parent().isOpen();
    }

    @Override
    public boolean isActive() {
        return this.parent().isActive();
    }

    @Override
    public boolean isWritable() {
        return this.parent().isWritable();
    }

    @Override
    public ChannelFuture close() {
        return this.parent().close();
    }

    @Override
    public ChannelConfig config() {
        return this.parent().config();
    }

    @Override
    public ChannelMetadata metadata() {
        return this.parent().metadata();
    }

    @Override
    protected CompletableFuture<Void> processOtherMessage(Object msg) {
        this.parent().writeAndFlush(msg);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    protected CompletableFuture<Void> processCheckTransaction(CheckTransactionStateRequestHeader header, MessageExt messageExt, TransactionData transactionData, CompletableFuture<ProxyRelayResult<Void>> responseFuture) {
        CompletableFuture<Void> writeFuture = new CompletableFuture<Void>();
        try {
            CheckTransactionStateRequestHeader requestHeader = new CheckTransactionStateRequestHeader();
            requestHeader.setCommitLogOffset(Long.valueOf(transactionData.getCommitLogOffset()));
            requestHeader.setTranStateTableOffset(Long.valueOf(transactionData.getTranStateTableOffset()));
            requestHeader.setTransactionId(transactionData.getTransactionId());
            requestHeader.setMsgId(header.getMsgId());
            RemotingCommand request = RemotingCommand.createRequestCommand((int)39, (CommandCustomHeader)requestHeader);
            request.setBody(RemotingConverter.getInstance().convertMsgToBytes(messageExt));
            this.parent().writeAndFlush((Object)request).addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                if (future.isSuccess()) {
                    responseFuture.complete(null);
                    writeFuture.complete(null);
                } else {
                    RemotingException e = new RemotingException("write and flush data failed");
                    responseFuture.completeExceptionally((Throwable)e);
                    writeFuture.completeExceptionally((Throwable)e);
                }
            }));
        }
        catch (Throwable t) {
            responseFuture.completeExceptionally(t);
            writeFuture.completeExceptionally(t);
        }
        return writeFuture;
    }

    @Override
    protected CompletableFuture<Void> processGetConsumerRunningInfo(RemotingCommand command, GetConsumerRunningInfoRequestHeader header, CompletableFuture<ProxyRelayResult<ConsumerRunningInfo>> responseFuture) {
        try {
            RemotingCommand request = RemotingCommand.createRequestCommand((int)307, (CommandCustomHeader)header);
            this.remotingProxyOutClient.invokeToClient(this.parent(), request, DEFAULT_MQ_CLIENT_TIMEOUT).thenAccept(response -> {
                if (response.getCode() == 0) {
                    ConsumerRunningInfo consumerRunningInfo = (ConsumerRunningInfo)ConsumerRunningInfo.decode((byte[])response.getBody(), ConsumerRunningInfo.class);
                    responseFuture.complete(new ProxyRelayResult<ConsumerRunningInfo>(0, "", consumerRunningInfo));
                }
                String errMsg = String.format("get consumer running info failed, code:%s remark:%s", response.getCode(), response.getRemark());
                RuntimeException e = new RuntimeException(errMsg);
                responseFuture.completeExceptionally(e);
            });
            return CompletableFuture.completedFuture(null);
        }
        catch (Throwable t) {
            responseFuture.completeExceptionally(t);
            return FutureUtils.completeExceptionally(t);
        }
    }

    @Override
    protected CompletableFuture<Void> processConsumeMessageDirectly(RemotingCommand command, ConsumeMessageDirectlyResultRequestHeader header, MessageExt messageExt, CompletableFuture<ProxyRelayResult<ConsumeMessageDirectlyResult>> responseFuture) {
        try {
            RemotingCommand request = RemotingCommand.createRequestCommand((int)309, (CommandCustomHeader)header);
            request.setBody(RemotingConverter.getInstance().convertMsgToBytes(messageExt));
            this.remotingProxyOutClient.invokeToClient(this.parent(), request, DEFAULT_MQ_CLIENT_TIMEOUT).thenAccept(response -> {
                if (response.getCode() == 0) {
                    ConsumeMessageDirectlyResult result = (ConsumeMessageDirectlyResult)ConsumeMessageDirectlyResult.decode((byte[])response.getBody(), ConsumeMessageDirectlyResult.class);
                    responseFuture.complete(new ProxyRelayResult<ConsumeMessageDirectlyResult>(0, "", result));
                }
                String errMsg = String.format("consume message directly failed, code:%s remark:%s", response.getCode(), response.getRemark());
                RuntimeException e = new RuntimeException(errMsg);
                responseFuture.completeExceptionally(e);
            });
            return CompletableFuture.completedFuture(null);
        }
        catch (Throwable t) {
            responseFuture.completeExceptionally(t);
            return FutureUtils.completeExceptionally(t);
        }
    }

    public String getClientId() {
        return this.clientId;
    }

    @Override
    public String getChannelExtendAttribute() {
        if (this.subscriptionData == null) {
            return null;
        }
        return JSON.toJSONString(this.subscriptionData);
    }

    public static Set<SubscriptionData> parseChannelExtendAttribute(Channel channel) {
        if (ChannelHelper.getChannelProtocolType(channel).equals((Object)ChannelProtocolType.REMOTING) && channel instanceof ChannelExtendAttributeGetter) {
            String attr = ((ChannelExtendAttributeGetter)channel).getChannelExtendAttribute();
            if (attr == null) {
                return null;
            }
            try {
                return (Set)JSON.parseObject((String)attr, (TypeReference)new TypeReference<Set<SubscriptionData>>(){}, (Feature[])new Feature[0]);
            }
            catch (Exception e) {
                log.error("convert remoting extend attribute to subscriptionDataSet failed. data:{}", (Object)attr, (Object)e);
                return null;
            }
        }
        return null;
    }

    @Override
    public RemoteChannel toRemoteChannel() {
        return new RemoteChannel(ConfigurationManager.getProxyConfig().getLocalServeAddr(), this.getRemoteAddress(), this.getLocalAddress(), ChannelProtocolType.REMOTING, this.getChannelExtendAttribute());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("parent", (Object)this.parent()).add("clientId", (Object)this.clientId).add("remoteAddress", (Object)this.remoteAddress).add("localAddress", (Object)this.localAddress).add("subscriptionData", this.subscriptionData).toString();
    }
}

