/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tieredstore;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class MessageStoreConfig {
    private String brokerName = MessageStoreConfig.localHostName();
    private String brokerClusterName = "DefaultCluster";
    private TieredStorageLevel tieredStorageLevel = TieredStorageLevel.NOT_IN_DISK;
    private String storePathRootDir = System.getProperty("user.home") + File.separator + "store";
    private boolean messageIndexEnable = true;
    private boolean recordGetMessageResult = false;
    private long tieredStoreCommitLogMaxSize = 0x40000000L;
    private long tieredStoreConsumeQueueMaxSize = 0x6400000L;
    private int tieredStoreIndexFileMaxHashSlotNum = 5000000;
    private int tieredStoreIndexFileMaxIndexNum = 20000000;
    private int tieredStoreIndexFileRollingIdleInterval = 10800000;
    private String tieredMetadataServiceProvider = "org.apache.rocketmq.tieredstore.metadata.DefaultMetadataStore";
    private String tieredBackendServiceProvider = "org.apache.rocketmq.tieredstore.provider.MemoryFileSegment";
    private int tieredStoreFileReservedTime = 72;
    private int commitLogRollingInterval = 24;
    private int commitLogRollingMinimumSize = 0x8000000;
    private int maxCommitJitter = 100;
    private boolean tieredStoreGroupCommit = true;
    private int tieredStoreGroupCommitTimeout = 30000;
    private int tieredStoreGroupCommitCount = 4096;
    private int tieredStoreGroupCommitSize = 0x400000;
    private int tieredStoreMaxGroupCommitCount = 10000;
    private long tieredStoreMaxFallBehindSize = 0x8000000L;
    private boolean readAheadCacheEnable = true;
    private int readAheadMessageCountThreshold = 4096;
    private int readAheadMessageSizeThreshold = 0x1000000;
    private long readAheadCacheExpireDuration = 15000L;
    private double readAheadCacheSizeThresholdRate = 0.3;
    private int tieredStoreMaxPendingLimit = 10000;
    private boolean tieredStoreCrcCheckEnable = false;
    private String tieredStoreFilePath = "";
    private String objectStoreEndpoint = "";
    private String objectStoreBucket = "";
    private String objectStoreAccessKey = "";
    private String objectStoreSecretKey = "";

    public static String localHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return "DEFAULT_BROKER";
        }
    }

    public String getBrokerName() {
        return this.brokerName;
    }

    public void setBrokerName(String brokerName) {
        this.brokerName = brokerName;
    }

    public String getBrokerClusterName() {
        return this.brokerClusterName;
    }

    public void setBrokerClusterName(String brokerClusterName) {
        this.brokerClusterName = brokerClusterName;
    }

    public TieredStorageLevel getTieredStorageLevel() {
        return this.tieredStorageLevel;
    }

    public void setTieredStorageLevel(TieredStorageLevel tieredStorageLevel) {
        this.tieredStorageLevel = tieredStorageLevel;
    }

    public void setTieredStorageLevel(int tieredStorageLevel) {
        this.tieredStorageLevel = TieredStorageLevel.valueOf(tieredStorageLevel);
    }

    public void setTieredStorageLevel(String tieredStorageLevel) {
        this.tieredStorageLevel = TieredStorageLevel.valueOf(tieredStorageLevel);
    }

    public String getStorePathRootDir() {
        return this.storePathRootDir;
    }

    public void setStorePathRootDir(String storePathRootDir) {
        this.storePathRootDir = storePathRootDir;
    }

    public boolean isMessageIndexEnable() {
        return this.messageIndexEnable;
    }

    public void setMessageIndexEnable(boolean messageIndexEnable) {
        this.messageIndexEnable = messageIndexEnable;
    }

    public boolean isRecordGetMessageResult() {
        return this.recordGetMessageResult;
    }

    public void setRecordGetMessageResult(boolean recordGetMessageResult) {
        this.recordGetMessageResult = recordGetMessageResult;
    }

    public long getTieredStoreCommitLogMaxSize() {
        return this.tieredStoreCommitLogMaxSize;
    }

    public void setTieredStoreCommitLogMaxSize(long tieredStoreCommitLogMaxSize) {
        this.tieredStoreCommitLogMaxSize = tieredStoreCommitLogMaxSize;
    }

    public long getTieredStoreConsumeQueueMaxSize() {
        return this.tieredStoreConsumeQueueMaxSize;
    }

    public void setTieredStoreConsumeQueueMaxSize(long tieredStoreConsumeQueueMaxSize) {
        this.tieredStoreConsumeQueueMaxSize = tieredStoreConsumeQueueMaxSize;
    }

    public int getTieredStoreIndexFileMaxHashSlotNum() {
        return this.tieredStoreIndexFileMaxHashSlotNum;
    }

    public void setTieredStoreIndexFileMaxHashSlotNum(int tieredStoreIndexFileMaxHashSlotNum) {
        this.tieredStoreIndexFileMaxHashSlotNum = tieredStoreIndexFileMaxHashSlotNum;
    }

    public int getTieredStoreIndexFileMaxIndexNum() {
        return this.tieredStoreIndexFileMaxIndexNum;
    }

    public void setTieredStoreIndexFileMaxIndexNum(int tieredStoreIndexFileMaxIndexNum) {
        this.tieredStoreIndexFileMaxIndexNum = tieredStoreIndexFileMaxIndexNum;
    }

    public int getTieredStoreIndexFileRollingIdleInterval() {
        return this.tieredStoreIndexFileRollingIdleInterval;
    }

    public void setTieredStoreIndexFileRollingIdleInterval(int tieredStoreIndexFileRollingIdleInterval) {
        this.tieredStoreIndexFileRollingIdleInterval = tieredStoreIndexFileRollingIdleInterval;
    }

    public String getTieredMetadataServiceProvider() {
        return this.tieredMetadataServiceProvider;
    }

    public void setTieredMetadataServiceProvider(String tieredMetadataServiceProvider) {
        this.tieredMetadataServiceProvider = tieredMetadataServiceProvider;
    }

    public String getTieredBackendServiceProvider() {
        return this.tieredBackendServiceProvider;
    }

    public void setTieredBackendServiceProvider(String tieredBackendServiceProvider) {
        this.tieredBackendServiceProvider = tieredBackendServiceProvider;
    }

    public int getTieredStoreFileReservedTime() {
        return this.tieredStoreFileReservedTime;
    }

    public void setTieredStoreFileReservedTime(int tieredStoreFileReservedTime) {
        this.tieredStoreFileReservedTime = tieredStoreFileReservedTime;
    }

    public int getCommitLogRollingInterval() {
        return this.commitLogRollingInterval;
    }

    public void setCommitLogRollingInterval(int commitLogRollingInterval) {
        this.commitLogRollingInterval = commitLogRollingInterval;
    }

    public int getCommitLogRollingMinimumSize() {
        return this.commitLogRollingMinimumSize;
    }

    public void setCommitLogRollingMinimumSize(int commitLogRollingMinimumSize) {
        this.commitLogRollingMinimumSize = commitLogRollingMinimumSize;
    }

    public int getMaxCommitJitter() {
        return this.maxCommitJitter;
    }

    public void setMaxCommitJitter(int maxCommitJitter) {
        this.maxCommitJitter = maxCommitJitter;
    }

    public boolean isTieredStoreGroupCommit() {
        return this.tieredStoreGroupCommit;
    }

    public void setTieredStoreGroupCommit(boolean tieredStoreGroupCommit) {
        this.tieredStoreGroupCommit = tieredStoreGroupCommit;
    }

    public int getTieredStoreGroupCommitTimeout() {
        return this.tieredStoreGroupCommitTimeout;
    }

    public void setTieredStoreGroupCommitTimeout(int tieredStoreGroupCommitTimeout) {
        this.tieredStoreGroupCommitTimeout = tieredStoreGroupCommitTimeout;
    }

    public int getTieredStoreGroupCommitCount() {
        return this.tieredStoreGroupCommitCount;
    }

    public void setTieredStoreGroupCommitCount(int tieredStoreGroupCommitCount) {
        this.tieredStoreGroupCommitCount = tieredStoreGroupCommitCount;
    }

    public int getTieredStoreGroupCommitSize() {
        return this.tieredStoreGroupCommitSize;
    }

    public void setTieredStoreGroupCommitSize(int tieredStoreGroupCommitSize) {
        this.tieredStoreGroupCommitSize = tieredStoreGroupCommitSize;
    }

    public int getTieredStoreMaxGroupCommitCount() {
        return this.tieredStoreMaxGroupCommitCount;
    }

    public void setTieredStoreMaxGroupCommitCount(int tieredStoreMaxGroupCommitCount) {
        this.tieredStoreMaxGroupCommitCount = tieredStoreMaxGroupCommitCount;
    }

    public long getTieredStoreMaxFallBehindSize() {
        return this.tieredStoreMaxFallBehindSize;
    }

    public void setTieredStoreMaxFallBehindSize(long tieredStoreMaxFallBehindSize) {
        this.tieredStoreMaxFallBehindSize = tieredStoreMaxFallBehindSize;
    }

    public boolean isReadAheadCacheEnable() {
        return this.readAheadCacheEnable;
    }

    public void setReadAheadCacheEnable(boolean readAheadCacheEnable) {
        this.readAheadCacheEnable = readAheadCacheEnable;
    }

    public int getReadAheadMessageCountThreshold() {
        return this.readAheadMessageCountThreshold;
    }

    public void setReadAheadMessageCountThreshold(int readAheadMessageCountThreshold) {
        this.readAheadMessageCountThreshold = readAheadMessageCountThreshold;
    }

    public int getReadAheadMessageSizeThreshold() {
        return this.readAheadMessageSizeThreshold;
    }

    public void setReadAheadMessageSizeThreshold(int readAheadMessageSizeThreshold) {
        this.readAheadMessageSizeThreshold = readAheadMessageSizeThreshold;
    }

    public long getReadAheadCacheExpireDuration() {
        return this.readAheadCacheExpireDuration;
    }

    public void setReadAheadCacheExpireDuration(long duration) {
        this.readAheadCacheExpireDuration = duration;
    }

    public double getReadAheadCacheSizeThresholdRate() {
        return this.readAheadCacheSizeThresholdRate;
    }

    public void setReadAheadCacheSizeThresholdRate(double rate) {
        this.readAheadCacheSizeThresholdRate = rate;
    }

    public int getTieredStoreMaxPendingLimit() {
        return this.tieredStoreMaxPendingLimit;
    }

    public void setTieredStoreMaxPendingLimit(int tieredStoreMaxPendingLimit) {
        this.tieredStoreMaxPendingLimit = tieredStoreMaxPendingLimit;
    }

    public boolean isTieredStoreCrcCheckEnable() {
        return this.tieredStoreCrcCheckEnable;
    }

    public void setTieredStoreCrcCheckEnable(boolean tieredStoreCrcCheckEnable) {
        this.tieredStoreCrcCheckEnable = tieredStoreCrcCheckEnable;
    }

    public String getTieredStoreFilePath() {
        return this.tieredStoreFilePath;
    }

    public void setTieredStoreFilePath(String tieredStoreFilePath) {
        this.tieredStoreFilePath = tieredStoreFilePath;
    }

    public void setObjectStoreEndpoint(String objectStoreEndpoint) {
        this.objectStoreEndpoint = objectStoreEndpoint;
    }

    public String getObjectStoreBucket() {
        return this.objectStoreBucket;
    }

    public void setObjectStoreBucket(String objectStoreBucket) {
        this.objectStoreBucket = objectStoreBucket;
    }

    public String getObjectStoreAccessKey() {
        return this.objectStoreAccessKey;
    }

    public void setObjectStoreAccessKey(String objectStoreAccessKey) {
        this.objectStoreAccessKey = objectStoreAccessKey;
    }

    public String getObjectStoreSecretKey() {
        return this.objectStoreSecretKey;
    }

    public void setObjectStoreSecretKey(String objectStoreSecretKey) {
        this.objectStoreSecretKey = objectStoreSecretKey;
    }

    public String getObjectStoreEndpoint() {
        return this.objectStoreEndpoint;
    }

    public static enum TieredStorageLevel {
        DISABLE(0),
        NOT_IN_DISK(1),
        NOT_IN_MEM(2),
        FORCE(3);

        private final int value;

        private TieredStorageLevel(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static TieredStorageLevel valueOf(int value) {
            switch (value) {
                case 1: {
                    return NOT_IN_DISK;
                }
                case 2: {
                    return NOT_IN_MEM;
                }
                case 3: {
                    return FORCE;
                }
            }
            return DISABLE;
        }

        public boolean isEnable() {
            return this.value > 0;
        }

        public boolean check(TieredStorageLevel targetLevel) {
            return this.value >= targetLevel.value;
        }
    }
}

