/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.config.v1;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.File;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.RocksDBConfigManager;
import org.apache.rocketmq.broker.subscription.SubscriptionGroupManager;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.utils.DataConverter;
import org.apache.rocketmq.remoting.protocol.DataVersion;
import org.apache.rocketmq.remoting.protocol.subscription.SubscriptionGroupConfig;
import org.rocksdb.CompressionType;
import org.rocksdb.RocksIterator;

public class RocksDBSubscriptionGroupManager
extends SubscriptionGroupManager {
    protected transient RocksDBConfigManager rocksDBConfigManager;

    public RocksDBSubscriptionGroupManager(BrokerController brokerController) {
        super(brokerController, false);
        this.rocksDBConfigManager = new RocksDBConfigManager(this.rocksdbConfigFilePath(), brokerController.getMessageStoreConfig().getMemTableFlushIntervalMs(), CompressionType.getCompressionType((String)brokerController.getMessageStoreConfig().getRocksdbCompressionType()));
    }

    public boolean load() {
        if (!this.rocksDBConfigManager.init()) {
            return false;
        }
        if (!this.loadDataVersion() || !this.loadSubscriptionGroupAndForbidden()) {
            return false;
        }
        this.init();
        return true;
    }

    @Override
    public boolean loadDataVersion() {
        return this.rocksDBConfigManager.loadDataVersion();
    }

    public boolean loadSubscriptionGroupAndForbidden() {
        return this.rocksDBConfigManager.loadData(this::decodeSubscriptionGroup) && this.loadForbidden(this::decodeForbidden) && this.merge();
    }

    public boolean loadForbidden(BiConsumer<byte[], byte[]> biConsumer) {
        try (RocksIterator iterator = this.rocksDBConfigManager.configRocksDBStorage.forbiddenIterator();){
            iterator.seekToFirst();
            while (iterator.isValid()) {
                biConsumer.accept(iterator.key(), iterator.value());
                iterator.next();
            }
        }
        return true;
    }

    private boolean merge() {
        if (!UtilAll.isPathExists((String)this.configFilePath()) && !UtilAll.isPathExists((String)(this.configFilePath() + ".bak"))) {
            log.info("subGroup json file does not exist, so skip merge");
            return true;
        }
        if (!super.loadDataVersion()) {
            log.error("load json subGroup dataVersion error, startup will exit");
            return false;
        }
        DataVersion dataVersion = super.getDataVersion();
        DataVersion kvDataVersion = this.getDataVersion();
        if (dataVersion.getCounter().get() > kvDataVersion.getCounter().get()) {
            if (!super.load()) {
                log.error("load group and forbidden info from json file error, startup will exit");
                return false;
            }
            ConcurrentMap<String, SubscriptionGroupConfig> groupTable = this.getSubscriptionGroupTable();
            for (Map.Entry entry : groupTable.entrySet()) {
                this.putSubscriptionGroupConfig((SubscriptionGroupConfig)entry.getValue());
                log.info("import subscription config to rocksdb, group={}", entry.getValue());
            }
            ConcurrentMap<String, ConcurrentMap<String, Integer>> forbiddenTable = this.getForbiddenTable();
            for (Map.Entry entry : forbiddenTable.entrySet()) {
                try {
                    this.rocksDBConfigManager.updateForbidden((String)entry.getKey(), JSON.toJSONString(entry.getValue()));
                    log.info("import forbidden config to rocksdb, group={}", entry.getValue());
                }
                catch (Exception e) {
                    log.error("import forbidden config to rocksdb failed, group={}", entry.getValue());
                    return false;
                }
            }
            this.getDataVersion().assignNewOne(dataVersion);
            this.updateDataVersion();
        } else {
            log.info("dataVersion is not greater than kvDataVersion, no need to merge group metaData, dataVersion={}, kvDataVersion={}", (Object)dataVersion, (Object)kvDataVersion);
        }
        log.info("finish marge subscription config from json file and merge to rocksdb");
        this.persist();
        return true;
    }

    public boolean stop() {
        return this.rocksDBConfigManager.stop();
    }

    @Override
    public SubscriptionGroupConfig putSubscriptionGroupConfig(SubscriptionGroupConfig subscriptionGroupConfig) {
        String groupName = subscriptionGroupConfig.getGroupName();
        SubscriptionGroupConfig oldConfig = this.subscriptionGroupTable.put(groupName, subscriptionGroupConfig);
        try {
            byte[] keyBytes = groupName.getBytes(DataConverter.CHARSET_UTF8);
            byte[] valueBytes = JSON.toJSONBytes((Object)subscriptionGroupConfig, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.BrowserCompatible});
            this.rocksDBConfigManager.put(keyBytes, keyBytes.length, valueBytes);
        }
        catch (Exception e) {
            log.error("kv put sub Failed, {}", (Object)subscriptionGroupConfig.toString());
        }
        return oldConfig;
    }

    @Override
    protected SubscriptionGroupConfig putSubscriptionGroupConfigIfAbsent(SubscriptionGroupConfig subscriptionGroupConfig) {
        String groupName = subscriptionGroupConfig.getGroupName();
        SubscriptionGroupConfig oldConfig = this.subscriptionGroupTable.putIfAbsent(groupName, subscriptionGroupConfig);
        if (oldConfig == null) {
            try {
                byte[] keyBytes = groupName.getBytes(DataConverter.CHARSET_UTF8);
                byte[] valueBytes = JSON.toJSONBytes((Object)subscriptionGroupConfig, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.BrowserCompatible});
                this.rocksDBConfigManager.put(keyBytes, keyBytes.length, valueBytes);
            }
            catch (Exception e) {
                log.error("kv put sub Failed, {}", (Object)subscriptionGroupConfig.toString());
            }
        }
        return oldConfig;
    }

    @Override
    protected SubscriptionGroupConfig removeSubscriptionGroupConfig(String groupName) {
        SubscriptionGroupConfig subscriptionGroupConfig = (SubscriptionGroupConfig)this.subscriptionGroupTable.remove(groupName);
        try {
            this.rocksDBConfigManager.delete(groupName.getBytes(DataConverter.CHARSET_UTF8));
        }
        catch (Exception e) {
            log.error("kv delete sub Failed, {}", (Object)subscriptionGroupConfig.toString());
        }
        return subscriptionGroupConfig;
    }

    protected void decodeSubscriptionGroup(byte[] key, byte[] body) {
        String groupName = new String(key, DataConverter.CHARSET_UTF8);
        SubscriptionGroupConfig subscriptionGroupConfig = (SubscriptionGroupConfig)JSON.parseObject((byte[])body, SubscriptionGroupConfig.class, (Feature[])new Feature[0]);
        this.subscriptionGroupTable.put(groupName, subscriptionGroupConfig);
        log.info("load exist local sub, {}", (Object)subscriptionGroupConfig.toString());
    }

    public synchronized void persist() {
        if (this.brokerController.getMessageStoreConfig().isRealTimePersistRocksDBConfig()) {
            this.rocksDBConfigManager.flushWAL();
        }
    }

    public synchronized void exportToJson() {
        log.info("RocksDBSubscriptionGroupManager export subscription group to json file");
        super.persist();
    }

    public String rocksdbConfigFilePath() {
        return this.brokerController.getMessageStoreConfig().getStorePathRootDir() + File.separator + "config" + File.separator + "subscriptionGroups" + File.separator;
    }

    @Override
    public DataVersion getDataVersion() {
        return this.rocksDBConfigManager.getKvDataVersion();
    }

    @Override
    public void updateDataVersion() {
        try {
            this.rocksDBConfigManager.updateKvDataVersion();
        }
        catch (Exception e) {
            log.error("update group config dataVersion error", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected void decodeForbidden(byte[] key, byte[] body) {
        String forbiddenGroupName = new String(key, DataConverter.CHARSET_UTF8);
        JSONObject jsonObject = JSON.parseObject((String)new String(body, DataConverter.CHARSET_UTF8));
        Set entries = jsonObject.entrySet();
        ConcurrentHashMap forbiddenGroup = new ConcurrentHashMap(entries.size());
        for (Map.Entry entry : entries) {
            forbiddenGroup.put(entry.getKey(), (Integer)entry.getValue());
        }
        this.getForbiddenTable().put(forbiddenGroupName, forbiddenGroup);
        log.info("load forbidden,{} value {}", (Object)forbiddenGroupName, (Object)((Object)forbiddenGroup).toString());
    }

    @Override
    public void updateForbidden(String group, String topic, int forbiddenIndex, boolean setOrClear) {
        try {
            super.updateForbidden(group, topic, forbiddenIndex, setOrClear);
            this.rocksDBConfigManager.updateForbidden(group, JSON.toJSONString(this.getForbiddenTable().get(group)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setForbidden(String group, String topic, int forbiddenIndex) {
        try {
            super.setForbidden(group, topic, forbiddenIndex);
            this.rocksDBConfigManager.updateForbidden(group, JSON.toJSONString(this.getForbiddenTable().get(group)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void clearForbidden(String group, String topic, int forbiddenIndex) {
        try {
            super.clearForbidden(group, topic, forbiddenIndex);
            this.rocksDBConfigManager.updateForbidden(group, JSON.toJSONString(this.getForbiddenTable().get(group)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

