/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.config.v2;

import io.netty.buffer.ByteBuf;
import io.netty.util.internal.PlatformDependent;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.config.v2.ConfigHelper;
import org.apache.rocketmq.broker.config.v2.ConfigStorage;
import org.apache.rocketmq.broker.config.v2.RecordPrefix;
import org.apache.rocketmq.broker.config.v2.TableId;
import org.apache.rocketmq.broker.config.v2.TablePrefix;
import org.apache.rocketmq.broker.offset.ConsumerOffsetManager;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.common.config.AbstractRocksDBStorage;
import org.apache.rocketmq.store.MessageStore;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.WriteBatch;

public class ConsumerOffsetManagerV2
extends ConsumerOffsetManager {
    private final ConfigStorage configStorage;

    public ConsumerOffsetManagerV2(BrokerController brokerController, ConfigStorage configStorage) {
        super(brokerController);
        this.configStorage = configStorage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void removeConsumerOffset(String topicAtGroup) {
        String[] topicGroup;
        if (!MixAll.isLmq((String)topicAtGroup)) {
            super.removeConsumerOffset(topicAtGroup);
        }
        if ((topicGroup = topicAtGroup.split("@")).length != 2) {
            LOG.error("Invalid topic group: {}", (Object)topicAtGroup);
            return;
        }
        byte[] topicBytes = topicGroup[0].getBytes(StandardCharsets.UTF_8);
        byte[] groupBytes = topicGroup[1].getBytes(StandardCharsets.UTF_8);
        int keyLen = 6 + groupBytes.length + 1 + 2 + topicBytes.length + 1;
        ByteBuf beginKey = AbstractRocksDBStorage.POOLED_ALLOCATOR.buffer(keyLen);
        beginKey.writeByte((int)TablePrefix.TABLE.getValue());
        beginKey.writeShort((int)TableId.CONSUMER_OFFSET.getValue());
        beginKey.writeByte((int)RecordPrefix.DATA.getValue());
        beginKey.writeShort(groupBytes.length);
        beginKey.writeBytes(groupBytes);
        beginKey.writeByte(1);
        beginKey.writeShort(topicBytes.length);
        beginKey.writeBytes(topicBytes);
        beginKey.writeByte(1);
        ByteBuf endKey = AbstractRocksDBStorage.POOLED_ALLOCATOR.buffer(keyLen);
        endKey.writeByte((int)TablePrefix.TABLE.getValue());
        endKey.writeShort((int)TableId.CONSUMER_OFFSET.getValue());
        endKey.writeByte((int)RecordPrefix.DATA.getValue());
        endKey.writeShort(groupBytes.length);
        endKey.writeBytes(groupBytes);
        endKey.writeByte(1);
        endKey.writeShort(topicBytes.length);
        endKey.writeBytes(topicBytes);
        endKey.writeByte(2);
        try (WriteBatch writeBatch = new WriteBatch();){
            writeBatch.deleteRange(ConfigHelper.readBytes(beginKey), ConfigHelper.readBytes(endKey));
            long stateMachineVersion = this.brokerController.getMessageStore() != null ? this.brokerController.getMessageStore().getStateMachineVersion() : 0L;
            ConfigHelper.stampDataVersion(writeBatch, TableId.CONSUMER_OFFSET, this.dataVersion, stateMachineVersion);
            this.configStorage.write(writeBatch);
        }
        catch (RocksDBException e) {
            LOG.error("Failed to removeConsumerOffset, topicAtGroup={}", (Object)topicAtGroup, (Object)e);
        }
        finally {
            beginKey.release();
            endKey.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeOffset(String group) {
        if (!MixAll.isLmq((String)group)) {
            super.removeOffset(group);
        }
        byte[] groupBytes = group.getBytes(StandardCharsets.UTF_8);
        int keyLen = 6 + groupBytes.length + 1;
        ByteBuf beginKey = AbstractRocksDBStorage.POOLED_ALLOCATOR.buffer(keyLen);
        beginKey.writeByte((int)TablePrefix.TABLE.getValue());
        beginKey.writeShort((int)TableId.CONSUMER_OFFSET.getValue());
        beginKey.writeByte((int)RecordPrefix.DATA.getValue());
        beginKey.writeShort(groupBytes.length);
        beginKey.writeBytes(groupBytes);
        beginKey.writeByte(1);
        ByteBuf endKey = AbstractRocksDBStorage.POOLED_ALLOCATOR.buffer(keyLen);
        endKey.writeByte((int)TablePrefix.TABLE.getValue());
        endKey.writeShort((int)TableId.CONSUMER_OFFSET.getValue());
        endKey.writeByte((int)RecordPrefix.DATA.getValue());
        endKey.writeShort(groupBytes.length);
        endKey.writeBytes(groupBytes);
        endKey.writeByte(2);
        try (WriteBatch writeBatch = new WriteBatch();){
            writeBatch.deleteRange(ConfigHelper.readBytes(beginKey), ConfigHelper.readBytes(endKey));
            MessageStore messageStore = this.brokerController.getMessageStore();
            long stateMachineVersion = messageStore != null ? messageStore.getStateMachineVersion() : 0L;
            ConfigHelper.stampDataVersion(writeBatch, TableId.CONSUMER_OFFSET, this.dataVersion, stateMachineVersion);
            this.configStorage.write(writeBatch);
        }
        catch (RocksDBException e) {
            LOG.error("Failed to consumer offsets by group={}", (Object)group, (Object)e);
        }
        finally {
            beginKey.release();
            endKey.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commitOffset(String clientHost, String group, String topic, int queueId, long offset) {
        String key = topic + "@" + group;
        if (!MixAll.isLmq((String)topic)) {
            if (this.offsetTable.containsKey(key)) {
                ((ConcurrentMap)this.offsetTable.get(key)).put(queueId, offset);
            } else {
                ConcurrentMap<Integer, Long> map = new ConcurrentHashMap<Integer, Long>();
                ConcurrentMap prev = this.offsetTable.putIfAbsent(key, map);
                if (null != prev) {
                    map = prev;
                }
                map.put(queueId, offset);
            }
        }
        ByteBuf keyBuf = this.keyOfConsumerOffset(group, topic, queueId);
        ByteBuf valueBuf = ConfigStorage.POOLED_ALLOCATOR.buffer(8);
        try (WriteBatch writeBatch = new WriteBatch();){
            valueBuf.writeLong(offset);
            writeBatch.put(keyBuf.nioBuffer(), valueBuf.nioBuffer());
            MessageStore messageStore = this.brokerController.getMessageStore();
            long stateMachineVersion = messageStore != null ? messageStore.getStateMachineVersion() : 0L;
            ConfigHelper.stampDataVersion(writeBatch, TableId.CONSUMER_OFFSET, this.dataVersion, stateMachineVersion);
            this.configStorage.write(writeBatch);
        }
        catch (RocksDBException e) {
            LOG.error("Failed to commit consumer offset", (Throwable)e);
        }
        finally {
            keyBuf.release();
            valueBuf.release();
        }
    }

    private ByteBuf keyOfConsumerOffset(String group, String topic, int queueId) {
        byte[] groupBytes = group.getBytes(StandardCharsets.UTF_8);
        byte[] topicBytes = topic.getBytes(StandardCharsets.UTF_8);
        int keyLen = 6 + groupBytes.length + 1 + 2 + topicBytes.length + 1 + 4;
        ByteBuf keyBuf = ConfigStorage.POOLED_ALLOCATOR.buffer(keyLen);
        keyBuf.writeByte((int)TablePrefix.TABLE.getValue());
        keyBuf.writeShort((int)TableId.CONSUMER_OFFSET.getValue());
        keyBuf.writeByte((int)RecordPrefix.DATA.getValue());
        keyBuf.writeShort(groupBytes.length);
        keyBuf.writeBytes(groupBytes);
        keyBuf.writeByte(1);
        keyBuf.writeShort(topicBytes.length);
        keyBuf.writeBytes(topicBytes);
        keyBuf.writeByte(1);
        keyBuf.writeInt(queueId);
        return keyBuf;
    }

    private ByteBuf keyOfPullOffset(String group, String topic, int queueId) {
        byte[] groupBytes = group.getBytes(StandardCharsets.UTF_8);
        byte[] topicBytes = topic.getBytes(StandardCharsets.UTF_8);
        int keyLen = 6 + groupBytes.length + 1 + 2 + topicBytes.length + 1 + 4;
        ByteBuf keyBuf = ConfigStorage.POOLED_ALLOCATOR.buffer(keyLen);
        keyBuf.writeByte((int)TablePrefix.TABLE.getValue());
        keyBuf.writeShort((int)TableId.PULL_OFFSET.getValue());
        keyBuf.writeByte((int)RecordPrefix.DATA.getValue());
        keyBuf.writeShort(groupBytes.length);
        keyBuf.writeBytes(groupBytes);
        keyBuf.writeByte(1);
        keyBuf.writeShort(topicBytes.length);
        keyBuf.writeBytes(topicBytes);
        keyBuf.writeByte(1);
        keyBuf.writeInt(queueId);
        return keyBuf;
    }

    public boolean load() {
        return this.loadDataVersion() && this.loadConsumerOffsets();
    }

    public synchronized void persist() {
        try {
            this.configStorage.flushWAL();
        }
        catch (RocksDBException e) {
            LOG.error("Failed to flush RocksDB config instance WAL", (Throwable)e);
        }
    }

    @Override
    public boolean loadDataVersion() {
        try {
            ConfigHelper.loadDataVersion(this.configStorage, TableId.CONSUMER_OFFSET).ifPresent(buf -> ConfigHelper.onDataVersionLoad(buf, this.dataVersion));
        }
        catch (RocksDBException e) {
            LOG.error("Failed to load RocksDB config", (Throwable)e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadConsumerOffsets() {
        ByteBuf beginKeyBuf = AbstractRocksDBStorage.POOLED_ALLOCATOR.buffer(4);
        beginKeyBuf.writeByte((int)TablePrefix.TABLE.getValue());
        beginKeyBuf.writeShort((int)TableId.CONSUMER_OFFSET.getValue());
        beginKeyBuf.writeByte((int)RecordPrefix.DATA.getValue());
        ByteBuf endKeyBuf = AbstractRocksDBStorage.POOLED_ALLOCATOR.buffer(4);
        endKeyBuf.writeByte((int)TablePrefix.TABLE.getValue());
        endKeyBuf.writeShort((int)TableId.CONSUMER_OFFSET.getValue());
        endKeyBuf.writeByte(RecordPrefix.DATA.getValue() + 1);
        try (RocksIterator iterator = this.configStorage.iterate(beginKeyBuf.nioBuffer(), endKeyBuf.nioBuffer());){
            int keyCapacity = 256;
            ByteBuffer keyBuffer = ByteBuffer.allocateDirect(keyCapacity);
            ByteBuffer valueBuffer = ByteBuffer.allocateDirect(8);
            while (iterator.isValid()) {
                keyBuffer.clear();
                valueBuffer.clear();
                int len = iterator.key(keyBuffer);
                if (len > keyCapacity) {
                    keyCapacity = len;
                    PlatformDependent.freeDirectBuffer((ByteBuffer)keyBuffer);
                    keyBuffer = ByteBuffer.allocateDirect(keyCapacity);
                    continue;
                }
                len = iterator.value(valueBuffer);
                assert (len == 8);
                keyBuffer.position(4);
                short groupLen = keyBuffer.getShort();
                byte[] groupBytes = new byte[groupLen];
                keyBuffer.get(groupBytes);
                byte ctrl = keyBuffer.get();
                assert (ctrl == 1);
                short topicLen = keyBuffer.getShort();
                byte[] topicBytes = new byte[topicLen];
                keyBuffer.get(topicBytes);
                String topic = new String(topicBytes, StandardCharsets.UTF_8);
                ctrl = keyBuffer.get();
                assert (ctrl == 1);
                int queueId = keyBuffer.getInt();
                long offset = valueBuffer.getLong();
                if (!MixAll.isLmq((String)topic)) {
                    String group = new String(groupBytes, StandardCharsets.UTF_8);
                    this.onConsumerOffsetRecordLoad(topic, group, queueId, offset);
                }
                iterator.next();
            }
            PlatformDependent.freeDirectBuffer((ByteBuffer)keyBuffer);
            PlatformDependent.freeDirectBuffer((ByteBuffer)valueBuffer);
        }
        finally {
            beginKeyBuf.release();
            endKeyBuf.release();
        }
        return true;
    }

    private void onConsumerOffsetRecordLoad(String topic, String group, int queueId, long offset) {
        if (MixAll.isLmq((String)topic)) {
            return;
        }
        String key = topic + "@" + group;
        if (!this.offsetTable.containsKey(key)) {
            ConcurrentHashMap map = new ConcurrentHashMap();
            this.offsetTable.putIfAbsent(key, map);
        }
        ((ConcurrentMap)this.offsetTable.get(key)).put(queueId, offset);
    }

    @Override
    public long queryOffset(String group, String topic, int queueId) {
        if (!MixAll.isLmq((String)topic)) {
            return super.queryOffset(group, topic, queueId);
        }
        ByteBuf keyBuf = this.keyOfConsumerOffset(group, topic, queueId);
        try {
            byte[] slice = this.configStorage.get(keyBuf.nioBuffer());
            if (null == slice) {
                long l = -1L;
                return l;
            }
            assert (slice.length == 8);
            long l = ByteBuffer.wrap(slice).getLong();
            return l;
        }
        catch (RocksDBException e) {
            throw new RuntimeException(e);
        }
        finally {
            keyBuf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commitPullOffset(String clientHost, String group, String topic, int queueId, long offset) {
        if (!MixAll.isLmq((String)topic)) {
            super.commitPullOffset(clientHost, group, topic, queueId, offset);
        }
        ByteBuf keyBuf = this.keyOfPullOffset(group, topic, queueId);
        ByteBuf valueBuf = AbstractRocksDBStorage.POOLED_ALLOCATOR.buffer(8);
        valueBuf.writeLong(offset);
        try (WriteBatch writeBatch = new WriteBatch();){
            writeBatch.put(keyBuf.nioBuffer(), valueBuf.nioBuffer());
            long stateMachineVersion = this.brokerController.getMessageStore() != null ? this.brokerController.getMessageStore().getStateMachineVersion() : 0L;
            ConfigHelper.stampDataVersion(writeBatch, TableId.PULL_OFFSET, this.dataVersion, stateMachineVersion);
            this.configStorage.write(writeBatch);
        }
        catch (RocksDBException e) {
            LOG.error("Failed to commit pull offset. group={}, topic={}, queueId={}, offset={}", new Object[]{group, topic, queueId, offset});
        }
        finally {
            keyBuf.release();
            valueBuf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long queryPullOffset(String group, String topic, int queueId) {
        if (!MixAll.isLmq((String)topic)) {
            return super.queryPullOffset(group, topic, queueId);
        }
        ByteBuf keyBuf = this.keyOfPullOffset(group, topic, queueId);
        try {
            byte[] valueBytes = this.configStorage.get(keyBuf.nioBuffer());
            if (null == valueBytes) {
                long l = -1L;
                return l;
            }
            long l = ByteBuffer.wrap(valueBytes).getLong();
            return l;
        }
        catch (RocksDBException e) {
            LOG.error("Failed to queryPullOffset. group={}, topic={}, queueId={}", new Object[]{group, topic, queueId});
        }
        finally {
            keyBuf.release();
        }
        return -1L;
    }
}

