/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import org.springframework.boot.actuate.autoconfigure.MetricsFilterSubmission;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="endpoints.metrics.filter")
public class MetricFilterProperties {
    private Set<MetricsFilterSubmission> gaugeSubmissions = new HashSet<MetricsFilterSubmission>(EnumSet.of(MetricsFilterSubmission.MERGED));
    private Set<MetricsFilterSubmission> counterSubmissions = new HashSet<MetricsFilterSubmission>(EnumSet.of(MetricsFilterSubmission.MERGED));

    public Set<MetricsFilterSubmission> getGaugeSubmissions() {
        return this.gaugeSubmissions;
    }

    public void setGaugeSubmissions(Set<MetricsFilterSubmission> gaugeSubmissions) {
        this.gaugeSubmissions = gaugeSubmissions;
    }

    public Set<MetricsFilterSubmission> getCounterSubmissions() {
        return this.counterSubmissions;
    }

    public void setCounterSubmissions(Set<MetricsFilterSubmission> counterSubmissions) {
        this.counterSubmissions = counterSubmissions;
    }

    boolean shouldSubmitToGauge(MetricsFilterSubmission submission) {
        return this.shouldSubmit(this.gaugeSubmissions, submission);
    }

    boolean shouldSubmitToCounter(MetricsFilterSubmission submission) {
        return this.shouldSubmit(this.counterSubmissions, submission);
    }

    private boolean shouldSubmit(Set<MetricsFilterSubmission> submissions, MetricsFilterSubmission submission) {
        return submissions != null && submissions.contains((Object)submission);
    }
}

