/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.autoconfigure;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.autoconfigure.EndpointAutoConfiguration;
import org.springframework.boot.actuate.condition.ConditionalOnEnabledEndpoint;
import org.springframework.boot.actuate.endpoint.Endpoint;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;
import org.springframework.cloud.bootstrap.config.PropertySourceBootstrapConfiguration;
import org.springframework.cloud.context.properties.ConfigurationPropertiesRebinder;
import org.springframework.cloud.context.refresh.ContextRefresher;
import org.springframework.cloud.context.restart.RestartEndpoint;
import org.springframework.cloud.context.scope.refresh.RefreshScope;
import org.springframework.cloud.endpoint.RefreshEndpoint;
import org.springframework.cloud.health.RefreshScopeHealthIndicator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.integration.monitor.IntegrationMBeanExporter;

@Configuration
@ConditionalOnClass(value={Endpoint.class})
@AutoConfigureAfter(value={EndpointAutoConfiguration.class, RefreshAutoConfiguration.class})
public class RefreshEndpointAutoConfiguration {
    @Bean
    @ConditionalOnBean(value={RefreshScope.class})
    @ConditionalOnMissingBean
    @ConditionalOnEnabledHealthIndicator(value="refresh")
    RefreshScopeHealthIndicator refreshScopeHealthIndicator(RefreshScope scope, ConfigurationPropertiesRebinder rebinder) {
        return new RefreshScopeHealthIndicator(scope, rebinder);
    }

    @Configuration
    @ConditionalOnEnabledEndpoint(value="refresh")
    @ConditionalOnBean(value={PropertySourceBootstrapConfiguration.class})
    protected static class RefreshEndpointConfiguration {
        protected RefreshEndpointConfiguration() {
        }

        @Bean
        @ConditionalOnBean(value={ContextRefresher.class})
        @ConditionalOnMissingBean
        public RefreshEndpoint refreshEndpoint(ContextRefresher contextRefresher) {
            RefreshEndpoint endpoint = new RefreshEndpoint(contextRefresher);
            return endpoint;
        }
    }

    @ConditionalOnEnabledEndpoint(value="restart", enabledByDefault=false)
    protected static class PauseResumeEndpoints {
        protected PauseResumeEndpoints() {
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnEnabledEndpoint(value="pause")
        public RestartEndpoint.PauseEndpoint pauseEndpoint(RestartEndpoint restartEndpoint) {
            return restartEndpoint.getPauseEndpoint();
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnEnabledEndpoint(value="resume")
        public RestartEndpoint.ResumeEndpoint resumeEndpoint(RestartEndpoint restartEndpoint) {
            return restartEndpoint.getResumeEndpoint();
        }
    }

    @ConditionalOnMissingClass(value={"org.springframework.integration.monitor.IntegrationMBeanExporter"})
    @ConditionalOnEnabledEndpoint(value="restart", enabledByDefault=false)
    protected static class RestartEndpointWithoutIntegration {
        protected RestartEndpointWithoutIntegration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public RestartEndpoint restartEndpointWithoutIntegration() {
            return new RestartEndpoint();
        }
    }

    @ConditionalOnClass(value={IntegrationMBeanExporter.class})
    @ConditionalOnEnabledEndpoint(value="restart", enabledByDefault=false)
    protected static class RestartEndpointWithIntegration {
        @Autowired(required=false)
        private IntegrationMBeanExporter exporter;

        protected RestartEndpointWithIntegration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public RestartEndpoint restartEndpoint() {
            RestartEndpoint endpoint = new RestartEndpoint();
            if (this.exporter != null) {
                endpoint.setIntegrationMBeanExporter(this.exporter);
            }
            return endpoint;
        }
    }
}

