/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.oasv.validation.skeleton.paths;

import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.servicecomb.toolkit.oasv.common.OasObjectPropertyLocation;
import org.apache.servicecomb.toolkit.oasv.common.OasObjectType;
import org.apache.servicecomb.toolkit.oasv.validation.api.OasValidationContext;
import org.apache.servicecomb.toolkit.oasv.validation.api.OasViolation;
import org.apache.servicecomb.toolkit.oasv.validation.api.PathItemValidator;
import org.apache.servicecomb.toolkit.oasv.validation.api.PathsValidator;
import org.apache.servicecomb.toolkit.oasv.validation.util.OasObjectValidatorUtils;

public class PathsPathItemsValidator
implements PathsValidator {
    private final List<PathItemValidator> pathItemValidators;

    public PathsPathItemsValidator(List<PathItemValidator> pathItemValidators) {
        this.pathItemValidators = pathItemValidators;
    }

    @Override
    public List<OasViolation> validate(OasValidationContext context, OasObjectPropertyLocation location, Paths oasObject) {
        ArrayList<OasViolation> violations = new ArrayList<OasViolation>();
        for (Map.Entry entry : oasObject.entrySet()) {
            String path = (String)entry.getKey();
            PathItem pathItem = (PathItem)entry.getValue();
            OasObjectPropertyLocation pathItemLocation = location.property(path, OasObjectType.PATH_ITEM);
            violations.addAll(OasObjectValidatorUtils.doValidateProperty(context, pathItemLocation, pathItem, this.pathItemValidators));
        }
        return violations;
    }
}

